% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-simphybreak.R
\name{plot.phybreakdata}
\alias{plot.phybreakdata}
\title{Plotting a phybreakdata object.}
\usage{
\method{plot}{phybreakdata}(x, ...)
}
\arguments{
\item{x}{An object of class \code{phybreakdata}.}

\item{...}{Some methods for this generic require additional arguments. None are used in this method.}
}
\description{
Plots a \code{phybreakdata}-object twice: (1) as transmission tree and (2) as phylogenetic tree, using the default graphical parameters
  of \code{\link{plotTrans}} and \code{\link{plotPhylo}}. The default 
  is to plot the current state, but any posterior sample can be chosen, as well as various consensus trees. Consensus tree "edmonds"
  plots only a transmission tree, consensus tree "mcc" only a phylogenetic tree.
}
\examples{
#First build a phybreak-object containing samples.
simulation <- sim.phybreak(obsize = 5)
MCMCstate <- phybreak(data = simulation$sequences, times = simulation$sample.times)
MCMCstate <- burnin.phybreak(MCMCstate, ncycles = 20)
MCMCstate <- sample.phybreak(MCMCstate, nsample = 50, thin = 2)

plot(MCMCstate, plot.which = "mpc")
}
\references{
\href{http://dx.doi.org/10.1371/journal.pcbi.1005495}{Klinkenberg et al. (2017)} Simultaneous 
  inference of phylogenetic and transmission trees in infectious disease outbreaks. 
  \emph{PLoS Comput Biol}, \strong{13}(5): e1005495.
}
\author{
Don Klinkenberg \email{don@xs4all.nl}
}
