% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phraseDoc.R
\name{as.matrix.phraseDoc}
\alias{as.matrix.phraseDoc}
\title{Convert a phraseDoc Object to a Matrix}
\usage{
\method{as.matrix}{phraseDoc}(x, ids = TRUE, sparse = FALSE, ...)
}
\arguments{
\item{x}{A phraseDoc object.}

\item{ids}{A logical value with TRUE (default) to use ids (if available), 
FALSE to use indices}

\item{sparse}{A logical value indicates whether a sparse matrix should be
returned (default FALSE)}

\item{...}{Additional arguments}
}
\value{
A matrix with phrases as rows, texts as columns, and elements
containing the number of times the phrase occurs in the text
}
\description{
Convert a phraseDoc Object to a Matrix
}
\examples{
tst=c("This is a test text",
      "This is a test text 2",
      "This is another test text",
      "This is another test text 2",
      "This girl will test text that man",
      "This boy will test text that man")
pd=phraseDoc(tst)
as.matrix(pd)
}
