% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_t_weibull.R
\name{simulate_t_weibull}
\alias{simulate_t_weibull}
\title{Generate survival data from a Weibull model}
\usage{
simulate_t_weibull(n, lambda, nu, X, beta, seed = 1)
}
\arguments{
\item{n}{sample size}

\item{lambda}{Weibull location parameter, positive}

\item{nu}{Weibull scale parameter, positive}

\item{X}{design matrix (n rows, p columns)}

\item{beta}{p-dimensional vector of regression coefficients
associated to X}

\item{seed}{random seed (defaults to 1)}
}
\value{
A vector of survival times
}
\description{
This function implements the algorithm proposed by
Bender et al. (2005) to simulate survival times from 
a Weibull model
}
\examples{
# generate example data
set.seed(1)
n = 50
X = cbind(matrix(1, n, 1), 
   matrix(rnorm(n*9, sd = 0.7), n, 9))
beta = rnorm(10, sd = 0.7)
times = simulate_t_weibull(n = n, lambda = 1, nu = 2,
   X = X, beta = beta)
hist(times, 20)
}
\references{
Bender, R., Augustin, T., & Blettner, M. (2005). 
Generating survival times to simulate Cox proportional 
hazards models. Statistics in medicine, 24(11), 1713-1723.

Signorelli, M., Spitali, P., Al-Khalili Szigyarto, C, 
The MARK-MD Consortium, Tsonaka, R. (2021). 
Penalized regression calibration: a method for the prediction 
of survival outcomes using complex longitudinal and 
high-dimensional data. Statistics in Medicine, 40 (27), 6178-6196.
DOI: 10.1002/sim.9178
}
\author{
Mirko Signorelli
}
