% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{gml_mid_ddydisps}
\alias{gml_mid_ddydisps}
\title{Directed Dyadic Dispute-Year Data with No Duplicate Dyad-Years (GML, v. 2.2.1)}
\format{
A data frame with 9262 observations on the following 25 variables.
\describe{
\item{\code{dispnum}}{a numeric vector for the dispute number}
\item{\code{ccode1}}{a numeric vector for the focal state in the dyad}
\item{\code{ccode2}}{a numeric vector for the target state in the dyad}
\item{\code{year}}{a numeric vector for the dispute-year}
\item{\code{gmlmidongoing}}{a numeric vector for whether there was a dispute ongoing in that year}
\item{\code{gmlmidonset}}{a numeric vector for whether it was the onset of a new dispute (or new participant-entry into a recurring dispute)}
\item{\code{sidea1}}{is \code{ccode1} on side A of the dispute?}
\item{\code{sidea2}}{is \code{ccode2} on side A of the dispute?}
\item{\code{fatality1}}{a numeric vector for the overall fatality level of \code{ccode1} in the dispute}
\item{\code{fatality2}}{a numeric vector for the overall fatality level of \code{ccode2} in the dispute}
\item{\code{fatalpre1}}{a numeric vector for the known fatalities (with precision) for \code{ccode1} in the dispute}
\item{\code{fatalpre2}}{a numeric vector for the known fatalities (with precision) for \code{ccode2} in the dispute}
\item{\code{hiact1}}{a numeric vector for the highest action of \code{ccode1} in the dispute}
\item{\code{hiact2}}{a numeric vector for the highest action of \code{ccode2} in the dispute}
\item{\code{hostlev1}}{a numeric vector for the hostility level of \code{ccode1} in the dispute}
\item{\code{hostlev2}}{a numeric vector for the hostility level of \code{ccode2} in the dispute}
\item{\code{orig1}}{is \code{ccode1} an originator of the dispute?}
\item{\code{orig2}}{is \code{ccode2} an originator of the dispute?}
\item{\code{fatality}}{a numeric vector for the fatality level of the dispute}
\item{\code{hostlev}}{a numeric vector for the hostility level of the MID}
\item{\code{mindur}}{a numeric vector for the minimum duration of the MID}
\item{\code{maxdur}}{a numeric vector for the maximum duration of the MID}
 \item{\code{recip}}{a numeric vector for whether a MID was reciprocated}
 \item{\code{stmon}}{a numeric vector for the start month of the MID}
}
}
\usage{
gml_mid_ddydisps
}
\description{
These are directed dyadic dispute year data derived from the Gibler-Miller-Little (GML) Militarized Interstate
 Dispute (MID) project. Data are from version 2.2.1. These were whittled to where there is no duplicate dyad-years.
 Its primary aim here is merging into a dyad-year data frame.
}
\details{
The process of creating these is described at one of the references below. Importantly, these data are somewhat
"naive." That is: they won't tell you, for example, that Brazil and Japan never directly fought each other during World War II.
Instead, it will tell you that there were two years of overlap for the two on different sides of the conflict and that the highest
action for both was a war. The data are thus similar to what the \code{EUGene} program would create for users back in the day. Use these
data with that limitation in mind.
}
\references{
Miller, Steven V. 2021. "How to (Meticulously) Convert Participant-Level Dispute Data to Dyadic Dispute-Year Data in R."
URL: \url{http://svmiller.com/blog/2021/05/convert-cow-mid-data-to-dispute-year/}

Gibler, Douglas M., Steven V. Miller, and Erin K. Little. 2016. “An Analysis of the Militarized
Interstate Dispute (MID) Dataset, 1816-2001.” International Studies Quarterly 60(4): 719-730.
}
\keyword{datasets}
