% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PatternGen.R
\name{rseg.circ}
\alias{rseg.circ}
\title{Generation of points segregated (in a radial or circular fashion) from a given set of points}
\usage{
rseg.circ(
  n,
  Yp,
  e,
  a1 = min(Yp[, 1]),
  a2 = max(Yp[, 1]),
  b1 = min(Yp[, 2]),
  b2 = max(Yp[, 2])
)
}
\arguments{
\item{n}{A positive integer representing the number of points to be generated.}

\item{Yp}{A set of 2D points representing the reference points. The generated points are segregated
(in a circular or radial fashion) from these points.}

\item{e}{A positive real number representing the radius of the balls centered at \code{Yp} points. These balls
are forbidden for the generated points (i.e., generated points would be in the complement of union of these
balls).}

\item{a1, a2}{Real numbers representing the range of \eqn{x}-coordinates in the region
(default is the range of \eqn{x}-coordinates of the \code{Yp} points).}

\item{b1, b2}{Real numbers representing the range of \eqn{y}-coordinates in the region
(default is the range of \eqn{y}-coordinates of the \code{Yp} points).}
}
\value{
A \code{list} with the elements
\item{type}{The type of the point pattern}
\item{mtitle}{The \code{"main"} title for the plot of the point pattern}
\item{parameters}{Radial (i.e., circular) exclusion parameter of the segregation pattern}
\item{ref.points}{The input set of reference points \code{Yp}, i.e., points from which generated points are
segregated.}
\item{gen.points}{The output set of generated points segregated from \code{Yp} points}
\item{tri.Yp}{Logical output for triangulation based on \code{Yp} points should be implemented or not.
if \code{TRUE} triangulation based on \code{Yp} points is to be implemented (default is set to \code{FALSE}).}
\item{desc.pat}{Description of the point pattern}
\item{num.points}{The \code{vector} of two numbers, which are the number of generated points and
the number of reference (i.e., \code{Yp}) points.}
\item{xlimit,ylimit}{The possible ranges of the \eqn{x}- and \eqn{y}-coordinates of the generated points}
}
\description{
An object of class \code{"Patterns"}.
Generates \code{n} 2D points uniformly in \eqn{(a_1-e,a_1+e) \times (a_1-e,a_1+e) \setminus B(y_i,e)}
(\eqn{a_1} and \eqn{b1} are denoted as \code{a1} and \code{b1} as arguments) where
\eqn{Y_p=(y_1,y_2,\ldots,y_{n_y})} with \eqn{n_y} being number of \code{Yp} points for various values of \code{e}
under the segregation pattern and \eqn{B(y_i,e)} is the ball centered at \eqn{y_i} with radius \code{e}.

Positive values of \code{e} yield realizations from the segregation pattern
and nonpositive values of \code{e} provide a type of complete spatial randomness (CSR),
\code{e} should not be too large to make the support of generated points empty,
\code{a1} is defaulted to the minimum of the \eqn{x}-coordinates of the \code{Yp} points,
\code{a2} is defaulted to the maximum of the \eqn{x}-coordinates of the \code{Yp} points,
\code{b1} is defaulted to the minimum of the \eqn{y}-coordinates of the \code{Yp} points,
\code{b2} is defaulted to the maximum of the \eqn{y}-coordinates of the \code{Yp} points.
}
\examples{
\dontrun{
nx<-100; ny<-4;  #try also nx<-1000; ny<-10
e<-.15;  #try also e<- -.1; #a negative e provides a CSR realization
#with default bounding box (i.e., unit square)
Y<-cbind(runif(ny),runif(ny))

Xdt<-rseg.circ(nx,Y,e)
Xdt
summary(Xdt)
plot(Xdt,asp=1)

#with default bounding box (i.e., unit square)
Y<-cbind(runif(ny),runif(ny))
Xdt<-Xdt$gen.points
Xlim<-range(Xdt[,1],Y[,1]);
Ylim<-range(Xdt[,2],Y[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Y,asp=1,pch=16,col=2,lwd=2, xlab="x",ylab="y",
     main="Circular Segregation of X points from Y Points",
     xlim=Xlim+xd*c(-.01,.01),ylim=Ylim+yd*c(-.01,.01))
points(Xdt)

#with a rectangular bounding box
a1<-0; a2<-10;
b1<-0; b2<-5;
e<-1.5;
Y<-cbind(runif(ny,a1,a2),runif(ny,b1,b2))
#try also Y<-cbind(runif(ny,a1,a2/2),runif(ny,b1,b2/2))

Xdt<-rseg.circ(nx,Y,e,a1,a2,b1,b2)$gen.points
Xlim<-range(Xdt[,1],Y[,1]); Ylim<-range(Xdt[,2],Y[,2])

plot(Y,pch=16,asp=1,col=2,lwd=2, xlab="x",ylab="y",
     main="Circular Segregation of X points from Y Points",
     xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
points(Xdt)
}

}
\seealso{
\code{\link{rasc.circ}}, \code{\link{rseg.std.tri}}, \code{\link{rsegII.std.tri}}, and \code{\link{rsegMT}}
}
\author{
Elvan Ceyhan
}
