% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxDelaunay.R
\name{is.std.eq.tri}
\alias{is.std.eq.tri}
\title{Check whether a triangle is a standard equilateral triangle}
\usage{
is.std.eq.tri(tri)
}
\arguments{
\item{tri}{A \eqn{3 \times 2} matrix with each row representing a vertex of the triangle.}
}
\value{
\code{TRUE} if \code{tri} is a standard equilateral triangle, else \code{FALSE}.
}
\description{
Checks whether the triangle, \code{tri}, is the standard equilateral triangle \eqn{T_e=T((0,0),(1,0),(1/2,\sqrt{3}/2))}
or not.
}
\examples{
\dontrun{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Te<-rbind(A,B,C)  #try adding +10^(-16) to each vertex
is.std.eq.tri(Te)

is.std.eq.tri(rbind(B,C,A))

Tr<-rbind(A,B,-C)
is.std.eq.tri(Tr)

A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
is.std.eq.tri(Tr)
}

}
\author{
Elvan Ceyhan
}
