% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge1D.R
\name{TSArcDensPE1D}
\alias{TSArcDensPE1D}
\title{A test of segregation/association based on arc density of Proportional Edge Proximity Catch Digraph
(PE-PCD) for 1D data}
\usage{
TSArcDensPE1D(
  Xp,
  Yp,
  support.int,
  r,
  c = 0.5,
  end.int.cor = FALSE,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95
)
}
\arguments{
\item{Xp}{A set of 1D points which constitute the vertices of the PE-PCD.}

\item{Yp}{A set of 1D points which constitute the end points of the partition intervals.}

\item{support.int}{Support interval \eqn{(a,b)} with \eqn{a<b}. Uniformity of \code{Xp} points in this interval
is tested.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{c}{A positive real number which serves as the centrality parameter in PE proximity region;
must be in \eqn{(0,1)} (default \code{c=.5}).}

\item{end.int.cor}{A logical argument for end interval correction, default is \code{FALSE},
recommended when both \code{Xp} and \code{Yp} have the same interval support.}

\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}.}

\item{conf.level}{Level of the confidence interval, default is \code{0.95}, for the arc density
PE-PCD whose vertices are the 1D data set \code{Xp}.}
}
\value{
A \code{list} with the elements
\item{statistic}{Test statistic}
\item{p.value}{The \eqn{p}-value for the hypothesis test for the corresponding \code{alternative}.}
\item{conf.int}{Confidence interval for the arc density at the given confidence level \code{conf.level} and
depends on the type of \code{alternative}.}
\item{estimate}{Estimate of the parameter, i.e., arc density}
\item{null.value}{Hypothesized value for the parameter, i.e., the null arc density, which is usually the
mean arc density under uniform distribution.}
\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}}
\item{method}{Description of the hypothesis test}
\item{data.name}{Name of the data set}
}
\description{
An object of class \code{"htest"} (i.e., hypothesis test) function which performs a hypothesis test of complete spatial
randomness (CSR) or uniformity of \code{Xp} points in the range (i.e., range) of \code{Yp} points against the alternatives
of segregation (where \code{Xp} points cluster away from \code{Yp} points) and association (where \code{Xp} points cluster around
\code{Yp} points) based on the normal approximation of the arc density of the PE-PCD for uniform 1D data.

The function yields the test statistic, \eqn{p}-value for the corresponding \code{alternative},
the confidence interval, estimate and null value for the parameter of interest (which is the arc density),
and method and name of the data set used.

Under the null hypothesis of uniformity of \code{Xp} points in the range of \code{Yp} points, arc density
of PE-PCD whose vertices are \code{Xp} points equals to its expected value under the uniform distribution and
\code{alternative} could be two-sided, or left-sided (i.e., data is accumulated around the \code{Yp} points, or association)
or right-sided (i.e., data is accumulated around the centers of the triangles, or segregation).

PE proximity region is constructed with the expansion parameter \eqn{r \ge 1} and centrality parameter \code{c} which yields
\eqn{M}-vertex regions. More precisely, for a middle interval \eqn{(y_{(i)},y_{(i+1)})}, the center is
\eqn{M=y_{(i)}+c(y_{(i+1)}-y_{(i)})} for the centrality parameter \eqn{c \in (0,1)}.

**Caveat:** This test is currently a conditional test, where \code{Xp} points are assumed to be random, while \code{Yp} points are
assumed to be fixed (i.e., the test is conditional on \code{Yp} points).
Furthermore, the test is a large sample test when \code{Xp} points are substantially larger than \code{Yp} points,
say at least 5 times more.
This test is more appropriate when supports of \code{Xp} and \code{Yp} have a substantial overlap.
Currently, the \code{Xp} points outside the range of \code{Yp} points are handled with a range correction (or
end interval correction) factor (see the description below and the function code.)
However, in the special case of no \code{Xp} points in the range of \code{Yp} points, arc density is taken to be 1,
as this is clearly a case of segregation. Removing the conditioning and extending it to the case of non-concurring supports is
an ongoing line of research of the author of the package.

\code{end.int.cor} is for end interval correction, (default is "no end interval correction", i.e., \code{end.int.cor=FALSE}),
recommended when both \code{Xp} and \code{Yp} have the same interval support.

See also (\insertCite{ceyhan:metrika-2012;textual}{pcds}) for more on the uniformity test based on the arc
density of PE-PCDs.
}
\examples{
\dontrun{
r<-2
c<-.4
a<-0; b<-10; int=c(a,b)

#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-100; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
xf<-(int[2]-int[1])*.1

Xp<-runif(nx,a-xf,b+xf)
Yp<-runif(ny,a,b)

TSArcDensPE1D(Xp,Yp,int,r,c)
#try also TSArcDensPE1D(Xp,Yp,int,r,c,alt="l") and TSArcDensPE1D(Xp,Yp,int,r,c,alt="g")

TSArcDensPE1D(Xp,Yp,int,r,c,end.int.cor = TRUE)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{TSArcDensPE}}, \code{\link{TSDomPEBin1D}}, and \code{\link{TSArcDensPEint}}
}
\author{
Elvan Ceyhan
}
