# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS WAF Regional
#'
#' @description
#' This is **AWS WAF Classic Regional** documentation. For more
#' information, see [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' This is the *AWS WAF Regional Classic API Reference* for using AWS WAF
#' Classic with the AWS resources, Elastic Load Balancing (ELB) Application
#' Load Balancers and API Gateway APIs. The AWS WAF Classic actions and
#' data types listed in the reference are available for protecting Elastic
#' Load Balancing (ELB) Application Load Balancers and API Gateway APIs.
#' You can use these actions and data types by means of the endpoints
#' listed in [AWS Regions and
#' Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#waf_region).
#' This guide is for developers who need detailed information about the AWS
#' WAF Classic API actions, data types, and errors. For detailed
#' information about AWS WAF Classic features and an overview of how to use
#' the AWS WAF Classic API, see the [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- wafregional(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- wafregional()
#' # The following example creates an IP match set named MyIPSetFriendlyName.
#' svc$create_ip_set(
#'   ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
#'   Name = "MyIPSetFriendlyName"
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=wafregional_associate_web_acl]{associate_web_acl} \tab This is AWS WAF Classic Regional documentation\cr
#'  \link[=wafregional_create_byte_match_set]{create_byte_match_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_create_geo_match_set]{create_geo_match_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_create_ip_set]{create_ip_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_create_rate_based_rule]{create_rate_based_rule} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_create_regex_match_set]{create_regex_match_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_create_regex_pattern_set]{create_regex_pattern_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_create_rule]{create_rule} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_create_rule_group]{create_rule_group} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_create_size_constraint_set]{create_size_constraint_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_create_sql_injection_match_set]{create_sql_injection_match_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_create_web_acl]{create_web_acl} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_create_web_acl_migration_stack]{create_web_acl_migration_stack} \tab Creates an AWS CloudFormation WAFV2 template for the specified web ACL in the specified Amazon S3 bucket\cr
#'  \link[=wafregional_create_xss_match_set]{create_xss_match_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_delete_byte_match_set]{delete_byte_match_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_delete_geo_match_set]{delete_geo_match_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_delete_ip_set]{delete_ip_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_delete_logging_configuration]{delete_logging_configuration} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_delete_permission_policy]{delete_permission_policy} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_delete_rate_based_rule]{delete_rate_based_rule} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_delete_regex_match_set]{delete_regex_match_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_delete_regex_pattern_set]{delete_regex_pattern_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_delete_rule]{delete_rule} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_delete_rule_group]{delete_rule_group} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_delete_size_constraint_set]{delete_size_constraint_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_delete_sql_injection_match_set]{delete_sql_injection_match_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_delete_web_acl]{delete_web_acl} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_delete_xss_match_set]{delete_xss_match_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_disassociate_web_acl]{disassociate_web_acl} \tab This is AWS WAF Classic Regional documentation\cr
#'  \link[=wafregional_get_byte_match_set]{get_byte_match_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_get_change_token]{get_change_token} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_get_change_token_status]{get_change_token_status} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_get_geo_match_set]{get_geo_match_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_get_ip_set]{get_ip_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_get_logging_configuration]{get_logging_configuration} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_get_permission_policy]{get_permission_policy} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_get_rate_based_rule]{get_rate_based_rule} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_get_rate_based_rule_managed_keys]{get_rate_based_rule_managed_keys} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_get_regex_match_set]{get_regex_match_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_get_regex_pattern_set]{get_regex_pattern_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_get_rule]{get_rule} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_get_rule_group]{get_rule_group} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_get_sampled_requests]{get_sampled_requests} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_get_size_constraint_set]{get_size_constraint_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_get_sql_injection_match_set]{get_sql_injection_match_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_get_web_acl]{get_web_acl} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_get_web_acl_for_resource]{get_web_acl_for_resource} \tab This is AWS WAF Classic Regional documentation\cr
#'  \link[=wafregional_get_xss_match_set]{get_xss_match_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_list_activated_rules_in_rule_group]{list_activated_rules_in_rule_group} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_list_byte_match_sets]{list_byte_match_sets} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_list_geo_match_sets]{list_geo_match_sets} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_list_ip_sets]{list_ip_sets} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_list_logging_configurations]{list_logging_configurations} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_list_rate_based_rules]{list_rate_based_rules} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_list_regex_match_sets]{list_regex_match_sets} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_list_regex_pattern_sets]{list_regex_pattern_sets} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_list_resources_for_web_acl]{list_resources_for_web_acl} \tab This is AWS WAF Classic Regional documentation\cr
#'  \link[=wafregional_list_rule_groups]{list_rule_groups} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_list_rules]{list_rules} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_list_size_constraint_sets]{list_size_constraint_sets} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_list_sql_injection_match_sets]{list_sql_injection_match_sets} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_list_subscribed_rule_groups]{list_subscribed_rule_groups} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_list_tags_for_resource]{list_tags_for_resource} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_list_web_ac_ls]{list_web_ac_ls} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_list_xss_match_sets]{list_xss_match_sets} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_put_logging_configuration]{put_logging_configuration} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_put_permission_policy]{put_permission_policy} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_tag_resource]{tag_resource} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_untag_resource]{untag_resource} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_update_byte_match_set]{update_byte_match_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_update_geo_match_set]{update_geo_match_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_update_ip_set]{update_ip_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_update_rate_based_rule]{update_rate_based_rule} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_update_regex_match_set]{update_regex_match_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_update_regex_pattern_set]{update_regex_pattern_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_update_rule]{update_rule} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_update_rule_group]{update_rule_group} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_update_size_constraint_set]{update_size_constraint_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_update_sql_injection_match_set]{update_sql_injection_match_set} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_update_web_acl]{update_web_acl} \tab This is AWS WAF Classic documentation\cr
#'  \link[=wafregional_update_xss_match_set]{update_xss_match_set} \tab This is AWS WAF Classic documentation
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname wafregional
#' @export
wafregional <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .wafregional$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.wafregional <- list()

.wafregional$operations <- list()

.wafregional$metadata <- list(
  service_name = "waf-regional",
  endpoints = list("*" = list(endpoint = "waf-regional.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "waf-regional.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "waf-regional.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "waf-regional.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "waf-regional.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "waf-regional.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "WAF Regional",
  api_version = "2016-11-28",
  signing_name = "waf-regional",
  json_version = "1.1",
  target_prefix = "AWSWAF_Regional_20161128"
)

.wafregional$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.wafregional$metadata, handlers, config)
}
