% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waf_operations.R
\name{waf_list_xss_match_sets}
\alias{waf_list_xss_match_sets}
\title{Returns an array of XssMatchSet objects}
\usage{
waf_list_xss_match_sets(NextMarker, Limit)
}
\arguments{
\item{NextMarker}{If you specify a value for \code{Limit} and you have more XssMatchSet objects
than the value of \code{Limit}, AWS WAF returns a \code{NextMarker} value in the
response that allows you to list another group of \code{XssMatchSets}. For
the second and subsequent \code{ListXssMatchSets} requests, specify the value
of \code{NextMarker} from the previous response to get information about
another batch of \code{XssMatchSets}.}

\item{Limit}{Specifies the number of XssMatchSet objects that you want AWS WAF to
return for this request. If you have more \code{XssMatchSet} objects than the
number you specify for \code{Limit}, the response includes a \code{NextMarker}
value that you can use to get another batch of \code{Rules}.}
}
\description{
Returns an array of XssMatchSet objects.
}
\section{Request syntax}{
\preformatted{svc$list_xss_match_sets(
  NextMarker = "string",
  Limit = 123
)
}
}

\examples{
# The following example returns an array of up to 100 XSS match sets.
\donttest{svc$list_xss_match_sets(
  Limit = 100L
)}

}
\keyword{internal}
