% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_create_global_replication_group}
\alias{elasticache_create_global_replication_group}
\title{Global Datastore for Redis offers fully managed, fast, reliable and
secure cross-region replication}
\usage{
elasticache_create_global_replication_group(
  GlobalReplicationGroupIdSuffix, GlobalReplicationGroupDescription,
  PrimaryReplicationGroupId)
}
\arguments{
\item{GlobalReplicationGroupIdSuffix}{[required] The suffix name of a Global Datastore. The suffix guarantees uniqueness
of the Global Datastore name across multiple regions.}

\item{GlobalReplicationGroupDescription}{Provides details of the Global Datastore}

\item{PrimaryReplicationGroupId}{[required] The name of the primary cluster that accepts writes and will replicate
updates to the secondary cluster.}
}
\description{
Global Datastore for Redis offers fully managed, fast, reliable and
secure cross-region replication. Using Global Datastore for Redis, you
can create cross-region read replica clusters for ElastiCache for Redis
to enable low-latency reads and disaster recovery across regions. For
more information, see Replication Across Regions Using Global Datastore.
}
\details{
\itemize{
\item The \strong{GlobalReplicationGroupIdSuffix} is the name of the Global
Datastore.
\item The \strong{PrimaryReplicationGroupId} represents the name of the primary
cluster that accepts writes and will replicate updates to the
secondary cluster.
}
}
\section{Request syntax}{
\preformatted{svc$create_global_replication_group(
  GlobalReplicationGroupIdSuffix = "string",
  GlobalReplicationGroupDescription = "string",
  PrimaryReplicationGroupId = "string"
)
}
}

\keyword{internal}
