% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logging.R
\name{paws_config_log}
\alias{paws_config_log}
\title{paws logging system}
\usage{
paws_config_log(
  level = 2L,
  file = "",
  timestamp_fmt = "\%Y-\%m-\%d \%H:\%M:\%OS3"
)
}
\arguments{
\item{level}{(integer) to determine the level logging threshold.
\itemize{
\item \code{4L}: DEBUG
\item \code{3L}: INFO
\item \code{2L}: WARNING
\item \code{1L}: ERROR
}}

\item{file}{(character) path for logs to populate, default output logs to console.}

\item{timestamp_fmt}{(character) for timestamp format, see \code{\link[=format.POSIXct]{format.POSIXct()}}.}
}
\description{
Ability to configure paws logging system, through the use of paws
helper function \code{`paws_config_log`} or \code{R:base} \code{options} function.
Users are able to change logging levels without calling \code{paws.common} by
the use of \code{options} e.g. \code{options("paws.log_level" = 2L)}.
\itemize{
\item \code{paws.log_level} (integer): The minimum log level that should be tracked
\item \code{paws.log_file} (character): path for logs to populate, default output logs to console.
\item \code{paws.log_timestamp_fmt} (character): see \code{\link[=format.POSIXct]{format.POSIXct()}}
}
}
\examples{
# log to a file
temp_file <- tempfile()
paws_config_log(file = temp_file)
unlink(temp_file)

# change log threshold to INFO
paws_config_log(level = 3L)

# reset to default config
paws_config_log()
}
