% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_triggers}
\alias{glue_get_triggers}
\title{Gets all the triggers associated with a job}
\usage{
glue_get_triggers(NextToken, DependentJobName, MaxResults)
}
\arguments{
\item{NextToken}{A continuation token, if this is a continuation call.}

\item{DependentJobName}{The name of the job to retrieve triggers for. The trigger that can start
this job is returned, and if there is no such trigger, all triggers are
returned.}

\item{MaxResults}{The maximum size of the response.}
}
\value{
A list with the following syntax:\preformatted{list(
  Triggers = list(
    list(
      Name = "string",
      WorkflowName = "string",
      Id = "string",
      Type = "SCHEDULED"|"CONDITIONAL"|"ON_DEMAND",
      State = "CREATING"|"CREATED"|"ACTIVATING"|"ACTIVATED"|"DEACTIVATING"|"DEACTIVATED"|"DELETING"|"UPDATING",
      Description = "string",
      Schedule = "string",
      Actions = list(
        list(
          JobName = "string",
          Arguments = list(
            "string"
          ),
          Timeout = 123,
          SecurityConfiguration = "string",
          NotificationProperty = list(
            NotifyDelayAfter = 123
          ),
          CrawlerName = "string"
        )
      ),
      Predicate = list(
        Logical = "AND"|"ANY",
        Conditions = list(
          list(
            LogicalOperator = "EQUALS",
            JobName = "string",
            State = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
            CrawlerName = "string",
            CrawlState = "RUNNING"|"CANCELLING"|"CANCELLED"|"SUCCEEDED"|"FAILED"
          )
        )
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Gets all the triggers associated with a job.
}
\section{Request syntax}{
\preformatted{svc$get_triggers(
  NextToken = "string",
  DependentJobName = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
