% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visu.R
\name{oscar.bs.boxplot}
\alias{oscar.bs.boxplot}
\title{Bootstrap visualization with boxplot, percentage of new additions}
\usage{
oscar.bs.boxplot(bs, ...)
}
\arguments{
\item{bs}{Bootstrapped 3-dimensional array for an oscar object as produced by oscar.bs}

\item{...}{Additional parameters passed on to barplot}
}
\value{
This is a plotting function that does not return anything, but instead draws on a new graphics device.
}
\description{
This function plots as barplots as a function of k-cardinality in what proporties certain coefficients were chosen as non-zero over the bootstrap runs.
}
\examples{
if(interactive()){
  data(ex)
  fit <- oscar(x=ex_X, y=ex_Y, k=ex_K, w=ex_c, family='cox')
  fit_bs <- oscar.bs(fit, bootstrap = 20, seed = 123)
  oscar.bs.boxplot(fit_bs)
}
}
