% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize_project.R
\name{initialize_project}
\alias{initialize_project}
\title{Initializes project}
\usage{
initialize_project(
  env = new.env(),
  home = NULL,
  results = NULL,
  folders_to_be_sourced = "R",
  source_folders_absolute = FALSE,
  encode_from = "UTF-8",
  encode_to = "latin1",
  ...
)
}
\arguments{
\item{env}{The environment that the code will be sourced into (use \code{.GlobalEnv} to source code into the global environment)}

\item{home}{The folder containing 'Run.R' and 'R/'}

\item{results}{A folder inside \code{results} with today's date will be created and it will be accessible via \code{org::project$results_today} (this is where you will store all of your results)}

\item{folders_to_be_sourced}{The names of folders that live inside \code{home} and all .r and .R files inside it will be sourced into the global environment.}

\item{source_folders_absolute}{If \code{TRUE} then \code{folders_to_be_sourced} is an absolute folder reference. If \code{FALSE} then \code{folders_to_be_sourced} is relative and inside \code{home}.}

\item{encode_from}{Folders current encoding (only used on Windows)}

\item{encode_to}{Folders final encoding (only used on Windows)}

\item{...}{Other folders that you would like to reference}
}
\value{
Returns an environment that contains:
\itemize{
\item Folder locations
\item An environment called \code{env} into which the code has been sourced into.
There is also a side effect where \code{org::project} mirrors these values.
}
}
\description{
\code{org::initialize_project} takes in 2+ arguments.
It then saves folder locations in the return value (a new environment) and
in \code{org::project}, which you will use in all of your subsequent code. An additional
folder will be created on the user's file system (org::project$results_today) which
corresponds to \code{results/YYYY-MM-DD}. The sourced folders are saved into org::project$env.
}
\details{
For more details see the help vignette:
\code{vignette("intro", package = "org")}
}
\examples{
\donttest{
org::initialize_project(
  home = paste0(tempdir(), "/git/analyses/2019/analysis3/"),
  results = paste0(tempdir(), "/dropbox/analyses_results/2019/analysis3/"),
  raw = paste0(tempdir(), "/data/analyses/2019/analysis3/")
)
org::project$results_today
org::project$raw
}
}
