% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcPerformance.R
\name{calcPerformance}
\alias{calcPerformance}
\title{Attach portfolio performance and distance to target}
\usage{
calcPerformance(x)
}
\arguments{
\item{x}{An optimized optimLanduse object.}
}
\value{
An optimized optimLanduse object with attached portfolio performance.
}
\description{
The Portfolio performances are calculated and attached to the solved
optimLanduse object. Each performance measure describes the relative
proportion to the maximum achievable (the "target") of the indicator,
given the current land use distribution and the uncertainty scenario set.
The lowest performing scenario of all indicators is the degree of minimal
fulfillment under the worst-possible outcome.
It can thus be interpreted as the guaranteed performance.
At least this proportion will be achieved across all indicators.
}
\details{
For further information and calculation, see the supplement of Gosling et al. (2020),
Formula S5 (in the supplement of the paper) and also the paragraph
optimLanduse functions and workflow - Post-processing in Husmann et al. (2020).
}
\examples{
require(ggplot2)
require(readxl)

dat <- read_xlsx(exampleData("exampleGosling.xlsx"))
init <- initScenario(dat, uValue = 2,
                     optimisticRule = "expectation",
                     fixDistance = 3)
result <- solveScenario(x = init)
performance <- calcPerformance(result)

# Visualize the distance

ggplot(performance$scenarioTable,
       aes(x = indicator,
           y = performance,
           color = indicator)) +
geom_point() +
geom_hline(yintercept =
           min(performance$scenarioTable$performance),
          linetype = "dashed", color = "red") +
ylim(0, 1)
}
\references{
Gosling, E., Reith, E., Knoke T., Gerique, A., Paul, C. (2020): Exploring
farmer perceptions of agroforestry via multi-objective optimisation: a test application
in Eastern Panama. \emph{Agroforestry Systems} \strong{94}. \doi{10.1007/s10457-020-00519-0}

Husmann, K., von Groß, V., Bödeker, K., Fuchs, J. M., Paul, C., & Knoke, T. (2022). optimLanduse: A package for multiobjective land-cover composition optimization under uncertainty. Methods in Ecology and Evolution, 00, 1– 10. https://doi.org/10.1111/2041-210X.14000
}
