% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localtest.R
\name{localtest}
\alias{localtest}
\title{Testing the equality of critical points}
\usage{
localtest(formula, data = data, der, smooth = "kernel", weights = NULL,
  nboot = 500, h0 = -1, h = -1, nh = 30, kernel = "epanech", p = 3,
  kbin = 100, rankl = NULL, ranku = NULL, seed = NULL, cluster = TRUE,
  ncores = NULL, ...)
}
\arguments{
\item{formula}{An object of class \code{formula}: a sympbolic 
description of the model to be fitted. The details of model 
specification are given under 'Details'.}

\item{data}{A data frame or matrix containing the model response variable
and covariates required by the \code{formula}.}

\item{der}{Number which determines any inference process. 
By default \code{der} is \code{NULL}. If this term is \code{0}, 
the testing procedures is applied for the estimate. If it is \code{1} or
\code{2}, it is designed for the first or second derivative, respectively.}

\item{smooth}{Type smoother used: \code{smooth = "kernel"} for local polynomial
kernel smoothers and \code{smooth = "splines"} for splines using the 
\code{mgcv} package.}

\item{weights}{Prior weights on the data.}

\item{nboot}{Number of bootstrap repeats.}

\item{h0}{The kernel bandwidth smoothing parameter for the global effect (see
references for more details at the estimation). Large values of the bandwidth lead
to smoothed estimates; smaller values of the bandwidth lead lo undersmoothed estimates. 
By default, cross validation is used to obtain the bandwidth.}

\item{h}{The kernel bandwidth smoothing parameter for the partial effects.}

\item{nh}{Integer number of equally-spaced bandwidth on which the
\code{h} is discretised, to speed up computation.}

\item{kernel}{A character string specifying the desired kernel. 
Defaults to \code{kernel = "epanech"}, where the Epanechnikov
density function kernel will be used. Also, several types of kernel funcitons 
can be used:  triangular and Gaussian density function, 
with \code{"triang"} and \code{"gaussian"} term, respectively.}

\item{p}{Degree of polynomial to be used. Its value must be the value of
derivative + 1. The default value is 3 due to the function
returns the estimation, first and second derivative.}

\item{kbin}{Number of binning nodes over which the function 
is to be estimated.}

\item{rankl}{Number or vector specifying the minimum value for the
interval at which to search the \code{x} value which maximizes the
estimate, first or second derivative  (for each level). The default
is the minimum data value.}

\item{ranku}{Number or vector specifying the maximum value for the
interval at which to search the \code{x} value which maximizes the
estimate, first or second derivative  (for each level). The default
is the maximum data value.}

\item{seed}{Seed to be used in the bootstrap procedure.}

\item{cluster}{A logical value. If  \code{TRUE} (default), the
bootstrap procedure is  parallelized (only for \code{smooth = "splines"}.
 Note that there are cases 
(e.g., a low number of bootstrap repetitions) that R will gain in
performance through serial computation. R takes time to distribute tasks
across the processors also it will need time for binding them all together
later on. Therefore, if the time for distributing and gathering pieces
together is greater than the time need for single-thread computing, it does
not worth parallelize.}

\item{ncores}{An integer value specifying the number of cores to be used
in the parallelized procedure. If \code{NULL} (default), the number of cores 
to be used is equal to the number of cores of the machine - 1.}

\item{\ldots}{Other options.}
}
\value{
The estimate of \eqn{d} value is returned and its confidence interval 
for a specific-level of confidence, i.e. 95\%. Additionally, it is shown 
the decision, accepted or rejected,  of the local test. Based on the null 
hypothesis is rejected if a zero value is not within the interval.
}
\description{
This function can be used to test the equality of the
\eqn{M} critical points estimated from the respective level-specific curves.
}
\details{
\code{localtest} can be used to test the equality of the 
\eqn{M} critical points estimated from the respective level-specific curves. 
Note that, even if the curves and/or their derivatives are different, it is 
possible for these points to be equal. 

For instance, taking the maxima of the first derivatives into account, 
interest lies in testing the following null hypothesis

\deqn{H_0: x_{01} = \ldots = x_{0M}}

versus the general  alternative  

\deqn{H_1: x_{0i} \ne x_{0j}  \quad {\rm{for}} \quad {\rm{some}} \quad 
\emph{i}, \emph{j} \in \{ 1, \ldots, M\}.}

The above hypothesis is true if \eqn{d=x_{0j}-x_{0k}=0} where 
\deqn{ (j,k)= argmax \quad (l,m) \quad \{1 \leq l<m \leq M\} \quad |x_{0l}-x_{0m}|, }

otherwise  \eqn{H_0} is false. It is important to highlight that, in practice,
the true \eqn{x_{0j}} are not known, and consequently neither is \eqn{d}, 
so an estimate \eqn{\hat d = \hat x_{0j}-\hat x_{0k}} is used, where, 
in general, \eqn{\hat x_{0l}} are the estimates of \eqn{x_{0l}} based on the 
estimated curves \eqn{\hat m_l} with \eqn{l = 1, \ldots , M}. 

Needless to say, 
since \eqn{\hat d} is only an estimate of the true \eqn{d}, the sampling 
uncertainty of these estimates needs to be acknowledged. Hence, a confidence 
interval \eqn{(a,b)} is created for \eqn{d} for a specific level of 
confidence (95\%).  Based on this, the null hypothesis is rejected if  
zero is not contained in the interval.

Note that if this hypothesis is rejected (and the factor has more than 
two levels), one option could be to use the \code{maxp.diff} function in 
order to obtain the differences between each pair of factor's levels.

Note that the models fitted by \code{localtest} function are specified 
in a compact symbolic form. The \~ operator is basic in the formation 
of such models. An expression of the form \code{y ~ model}  is interpreted as 
a specification that the response \code{y} is modelled by a predictor 
specified symbolically by \code{model}. The possible terms consist of a 
variable name or a variable name and a factor name separated by : operator. 
Such a term is interpreted as the interaction of the continuous variable and 
the factor. However, if \code{smooth = "splines"}, the formula is based on the function
formula.gam of the mgcv package.
}
\examples{
library(npregfast)
data(barnacle)
localtest(DW ~ RC : F, data = barnacle, der = 1, seed = 130853, nboot = 100)

}
\author{
Marta Sestelo, Nora M. Villanueva and Javier Roca-Pardinas.
}
\references{
Sestelo, M. (2013). Development and computational implementation of 
estimation and inference methods in flexible regression models. 
Applications in Biology, Engineering and Environment. PhD Thesis, Department
of Statistics and O.R. University of Vigo.
}

