% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ESPNCoach.R
\name{get_espn_coaches}
\alias{get_espn_coaches}
\title{Get ESPN coaches by season}
\usage{
get_espn_coaches(season = get_season_now()$seasonId\%\%10000)
}
\arguments{
\item{season}{integer in YYYY}
}
\value{
tibble with one row per coach
}
\description{
\code{get_espn_coaches()} retrieves ESPN hyperlinks for each coach for a given \code{season}; the hyperlinks are formatted in \verb{base/seasons/\{ESPN Season ID\}/coaches/\{ESPN Coach ID\}?query}. Access \code{get_seasons()} for \code{season} reference. May soon be reworked to only return the ESPN Coach IDs.
}
\examples{
ESPN_coaches_20242025 <- get_espn_coaches(2025)
}
