% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trio_consistency.R
\name{validate_trio_consistency}
\alias{validate_trio_consistency}
\title{Validate pedigree trio information consistency}
\usage{
validate_trio_consistency(id, fid, mid, sex = NULL)
}
\arguments{
\item{id}{Numeric. The id of the individual. These values should be unique}

\item{fid}{Numeric. The father id. NA or 0 are used for missing.}

\item{mid}{Numeric. The mother id. NA or 0 are used for missing.}

\item{sex}{An optional numeric vector with the sex of the individual. Only four values should be present 1 (male), 2 (female), 0 or NA (missing)}
}
\value{
Throws an error if an inconsistency is found. Otherwise returns TRUE.
}
\description{
Simple tests to chech the consistency of the pedigree trio family data. 
Currently the following checks are undertaken:
1) that no duplicates ids are found;
2) that the primary id is not missing for anyone;
3) that founders have both the father and mother id missing;
4) that individuals are not both classified as male (fathers and mothers);
}
\details{
There are no checks of persons being both mother and father, nor being its
own parent and incest checks are not performed. In other words, the
\code{obj} is assumed to be sane, but possibly immoral.
}
\examples{

library("data.table")
id <- 1:12
fid <- c(NA,  0, 1, 1, NA, 23, 45, 5, 5, 7, 10, 10)
mid <- c(NA, NA, 2, 2,  0, 56, 46, 6, 6, 6, 9, 11)

validate_trio_consistency(id, fid, mid)

}
\author{
Claus Thorn Ekstrøm, \email{ekstrom@sund.ku.dk}
}
\keyword{manip}
