% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_netmhc2pan.R
\name{install_netmhc2pan}
\alias{install_netmhc2pan}
\title{Install NetMHCIIpan}
\usage{
install_netmhc2pan(
  netmhc2pan_bin_url = get_netmhc2pan_bin_url(),
  netmhc2pan_data_url = get_netmhc2pan_data_url(),
  verbose = FALSE,
  netmhc2pan_archive_filename = get_netmhc2pan_archive_filename(),
  netmhc2pan_folder_name = get_default_netmhc2pan_folder(),
  temp_local_file = tempfile(pattern = "netmhc2pan_install_netmhc2pan_")
)
}
\arguments{
\item{netmhc2pan_bin_url}{URL to download the
NetMHCIIpan binary tarball file from,
similar to, for example,
\code{https://www.cbs.dtu.dk/download/12345678-1234-1234-1234-123456789ABC}.
Use \link{get_netmhc2pan_bin_url} to get the default URL.}

\item{netmhc2pan_data_url}{URL to download the
NetMHCIIpan data tarball file from,
similar to, for example,
\url{https://www.cbs.dtu.dk/services/NetMHCIIpan-3.2/data.Linux.tar.gz}.
Use \link{get_netmhc2pan_data_url} to get the default URL.}

\item{verbose}{set to TRUE for more output}

\item{netmhc2pan_archive_filename}{the NetMHC2pan archive
filename, for example \code{netMHCIIpan-3.2.Linux.tar.gz},
which is used in installation of NetMHC2pan.
Use \link{get_netmhc2pan_archive_filename} to get this filename.}

\item{netmhc2pan_folder_name}{the folder (to be) used by NetMHCIIpan.
From this location, a subfolder for NetMHCIIpan is created.
Use \link{get_default_netmhc2pan_folder} to see the location
of the default NetMHCIIpan folder.
Use \link{get_default_netmhc2pan_subfolder} to see the location
of the default NetMHCIIpan subfolder.}

\item{temp_local_file}{path to the temporary file to store the URL to.
This file will be deleted afterwards.}
}
\value{
Nothing
}
\description{
Install NetMHCIIpan to a local folder, by downloading the binary and
data files. Use \link{install_netmhc2pan_from_files} to install
NetMHCIIpan from files that are already downloaded.
}
\details{
These are three steps:

\itemize{
  \item Install the NetMHCIIpan binary, using \link{install_netmhc2pan_bin}
  \item Install the NetMHCIIpan data, using \link{install_netmhc2pan_data}
  \item Set up NetMHCIIpan, using \link{set_up_netmhc2pan}
}
}
\examples{
\donttest{
  install_netmhc2pan()
}
}
\author{
Richèl J.C. Bilderbeek
}
