% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{mc_calc_cumsum}
\alias{mc_calc_cumsum}
\title{Cumulative sum}
\usage{
mc_calc_cumsum(data, sensors, output_suffix = "_cumsum", localities = NULL)
}
\arguments{
\item{data}{cleaned myClim object see \link{myClim-package}}

\item{sensors}{names of sensors on which to calculate cumulative sum}

\item{output_suffix}{name suffix for virtual sensor names (default "_cumsum") e.g. TMS_T3_cumsum}

\item{localities}{list of locality_ids for calculation; if NULL then all (default NULL)}
}
\value{
The same myClim object as input but with added cumsum sensors.
}
\description{
This function creates a new virtual sensor on locality within the myClim data object.
The virtual sensor represents the cumulative sum of the values on the input sensor.
Names of new sensors are original sensor name + \code{outpus_suffix}.
}
\details{
If value type of sensor is logical, then output type is integer. (TRUE, TRUE, FALSE -> 2)
}
\examples{
cumsum_data <- mc_calc_cumsum(mc_data_example_agg, c("TMS_T1", "TMS_T2"))
}
