% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.minLambda.R
\name{plot.minLambda}
\alias{plot.minLambda}
\title{Plot of objective function for finding appropriate smoothing parameters.}
\usage{
\method{plot}{minLambda}(x, ...)
}
\arguments{
\item{x}{Output of function \code{\link{MinLambda}}.}

\item{...}{Further graphical parameters can be passed.}
}
\value{
Plot of \eqn{G} on a grid.
}
\description{
The objective function \eqn{G} is plotted on a grid. The minimum is 
indicated with a white point.
}
\details{
When minimizing over 2 \eqn{\lambda}'s, one plot is generated: (\eqn{\lambda_2} vs \eqn{\lambda_3}).
With 3 \eqn{\lambda}'s, 3 plots are generated: \eqn{\lambda_2} vs. \eqn{\lambda_3}, 
\eqn{\lambda_2} vs. \eqn{\lambda_4} and \eqn{\lambda_3} vs. \eqn{\lambda_4}.
}
\examples{
set.seed(987)
sampleData <- matrix(stats::rnorm(100), nrow = 10)
sampleData[4:6, 6:8] <- sampleData[4:6, 6:8] + 5

# Minimization of two lambdas on a 20-by-20-grid
minLamOut <- MinLambda(Xmu = c(sampleData), mm = 10, nn = 10, 
                        nGrid = 20, nLambda = 3)

# Plot of the objective function
plot(x = minLamOut)

}
