% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quality_control.R
\name{qc_summary}
\alias{qc_summary}
\title{Summary of Filtering}
\usage{
qc_summary(mpactr_object)
}
\arguments{
\item{mpactr_object}{an \code{mpactr_object}.}
}
\value{
a \code{data.table} reporting the number of high quality ions
("Passed") or the filter in which they were removed.
}
\description{
Parses an mpactr object and extracts a summary of all applied filters.
Specifically, the fate of each input ion is reported as ion status. Status
options are: Passed, mispicked, group, replicability, and insouce. A status
of Passed ions is returned for ions that passed all applied filters and
therefore are expected to be high quality ions. Ions tagged as group,
mispicked, replicability, or ionsource were removed during the corresponding
filter.
}
\examples{
data <- import_data(
  example_path("coculture_peak_table.csv"),
  example_path("metadata.csv"),
  format = "Progenesis"
)

data_filter <- filter_mispicked_ions(data,
  ringwin = 0.5,
  isowin = 0.01,
  trwin = 0.005,
  max_iso_shift = 3,
  merge_peaks = TRUE
)

summary <- qc_summary(data_filter)
summary
}
