% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudoRes.R
\name{pseudoRes}
\alias{pseudoRes}
\title{Pseudo-residuals}
\usage{
pseudoRes(m)
}
\arguments{
\item{m}{A \code{moveHMM} object.}
}
\value{
A list of:
\item{stepRes}{The pseudo-residuals for the step lengths}
\item{angleRes}{The pseudo-residuals for the turning angles}
}
\description{
The pseudo-residuals of a moveHMM model, as described in Zucchini and McDonad (2009).
}
\details{
If some turning angles in the data are equal to pi, the corresponding pseudo-residuals
will not be included. Indeed, given that the turning angles are defined on (-pi,pi], an angle of pi
results in a pseudo-residual of +Inf (check Section 6.2 of reference for more information on the
computation of pseudo-residuals).
}
\examples{
# m is a moveHMM object (as returned by fitHMM), automatically loaded with the package
m <- example$m
res <- pseudoRes(m)
qqnorm(res$stepRes)
qqnorm(res$angleRes)

}
\references{
Zucchini, W. and MacDonald, I.L. 2009.
Hidden Markov Models for Time Series: An Introduction Using R.
Chapman & Hall (London).
}
