% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code.R
\name{add_prob}
\alias{add_prob}
\title{Add Class Probability}
\usage{
add_prob(addTo, x, y, outChar, predTag = NULL)
}
\arguments{
\item{addTo}{Summary list that will contain all model fit results.}

\item{x}{A dataframe of input variables.}

\item{y}{A vector or a dataframe of output variable.}

\item{outChar}{A charactor value of output class name.}

\item{predTag}{A charactor value of tag that to be added to the pred result.}
}
\value{
Results of each model fitting are added to the summary list.
}
\description{
\code{add_prob} Adds class probability results with given dataset (x, y)
to the summary list for the all model fits exists in it. Like
\code{\link{add_model}}, it also ensures to conduct prediction for the
model and data supports classification.
}
\examples{
\dontrun{
library(mlbench)
data(PimaIndiansDiabetes)
index <- sample(seq_len(nrow(PimaIndiansDiabetes)), 500)
trainingSet <- PimaIndiansDiabetes[index, ]
testSet <- PimaIndiansDiabetes[-index, ]
x <- trainingSet[, -9]
y <- trainingSet[, 9]
x_test <- testSet[, -9]
y_test <- testSet[, 9]

sSummary <- list()
sSummary <- add_model(sSummary, x, y)
sSummary <- add_model(sSummary, x, y, model = c("C5.0Cost", "glmnet"), modelTag = "others")
sSummary <- add_prob(sSummary, x_test, y_test, outChar = "pos")
sSummary$glm$pred_test

# vignette("modeval") #check a vignette for further details
}
}
