% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dev-parse_index.R
\name{parse_index}
\alias{parse_index}
\alias{parse_index_from_data}
\alias{parse_period_from_index}
\title{Developer Tools for parsing date and date-time information}
\usage{
parse_index_from_data(data)

parse_period_from_index(data, period)
}
\arguments{
\item{data}{A data frame}

\item{period}{A period to calculate from the time index. Numeric values are returned as-is.
"auto" guesses a numeric value from the index. A time-based phrase (e.g. "7 days") calculates
the number of timestamps that typically occur within the time-based phrase.}
}
\value{
\itemize{
\item parse_index_from_data(): Returns a tibble containing the date or date-time column.
\item parse_period_from_index(): Returns the numeric period from a tibble containing the index.
}
}
\description{
These functions are designed to assist developers in extending the \code{modeltime}
package.
}
\examples{
library(dplyr)
library(timetk)

predictors <- m4_monthly \%>\%
    filter(id == "M750") \%>\%
    select(-value)

index_tbl <- parse_index_from_data(predictors)
index_tbl

period <- parse_period_from_index(index_tbl, period = "1 year")
period

}
