% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers-modeltime_table.R
\name{drop_modeltime_model}
\alias{drop_modeltime_model}
\title{Drop a Model from a Modeltime Table}
\usage{
drop_modeltime_model(object, .model_id)
}
\arguments{
\item{object}{A Modeltime Table (class \code{mdl_time_tbl})}

\item{.model_id}{A numeric value matching the .model_id that you want to drop}
}
\description{
Drop a Model from a Modeltime Table
}
\examples{
\donttest{
library(tidymodels)


m750_models \%>\%
    drop_modeltime_model(.model_id = c(2,3))
}

}
\seealso{
\itemize{
\item \code{\link[=combine_modeltime_tables]{combine_modeltime_tables()}}: Combine 2 or more Modeltime Tables together
\item \code{\link[=add_modeltime_model]{add_modeltime_model()}}: Adds a new row with a new model to a Modeltime Table
\item \code{\link[=drop_modeltime_model]{drop_modeltime_model()}}: Drop one or more models from a Modeltime Table
\item \code{\link[=update_modeltime_description]{update_modeltime_description()}}: Updates a description for a model inside a Modeltime Table
\item \code{\link[=update_modeltime_model]{update_modeltime_model()}}: Updates a model inside a Modeltime Table
\item \code{\link[=pull_modeltime_model]{pull_modeltime_model()}}: Extracts a model from a Modeltime Table
}
}
