% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BvLTDep.R
\name{Bv.LT.Dep}
\alias{Bv.LT.Dep}
\title{Fits bivariate joint tail model}
\usage{
Bv.LT.Dep(
  data,
  mod.thresh.u,
  crit.lev.u,
  sig.lev = 0.05,
  ci.meth = "se",
  marg.inf = F
)
}
\arguments{
\item{data}{Two column data frame with values given on uniform margins}

\item{mod.thresh.u}{Modelling threshold on uniform margin}

\item{crit.lev.u}{Critical level on uniform margin}

\item{sig.lev}{Significance level for confidence intervals (\code{default} 0.05 for 95\code{\%} confidence interval)}

\item{ci.meth}{Method to use to obtain confidence intervals, '\code{se}' for standard error confidence intervals and '\code{pl}' for profile likelihood confidence intervals}

\item{marg.inf}{Is additional marginal information from points that are extreme in only one variable used? \code{FALSE} gives Ledford and Tawn (1997) result, \code{TRUE} gives results using Section 2.4.2 from Hugo Winter's thesis.}
}
\value{
Estimates of two dependence parameters with confidence intervals:
\itemize{
\item  threshold dependent extremal dependence measure
\item  threshold dependent coefficient of tail dependence
}
}
\description{
Take data on uniform margins and fit the Ledford and Tawn (1997) joint tail model. Also contains the method where additional information from values that are extreme in at most one variable is used.
}
