% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_helpers.R
\name{gt_mlb_column_labels}
\alias{gt_mlb_column_labels}
\title{Replace Team Abbreviations/Player IDs With Images In Column Labels}
\usage{
gt_mlb_column_labels(
  value,
  type = c("mlb_logo", "scoreboard_logo", "headshot"),
  height = 30,
  na_headshot_to_logo = TRUE
)
}
\arguments{
\item{value}{What team abbreviation/player id should be replaced with an image?}

\item{type}{What type of image is replacing the value?}

\item{height}{The absolute height (px) of the image}

\item{na_headshot_to_logo}{should NA/non player id matches return the MLB logo instead
of a grayed out blank headshot? Defaults to \code{TRUE}}
}
\value{
HTML tag for image
}
\description{
\code{gt_column_example} takes in a value of a team abbreviation or player id and
converts the designated column to the corresponding image.
}
\examples{
library(gt)
library(mlbplotR)

df <- data.frame(BAL = 1,
                 TEX = 1,
                 "Mike_Trout" = 1,
                 "Shohei_Ohtani" = 1
                 )

gt_column_example <- df \%>\%
  gt::gt() \%>\%
  gt::cols_label(BAL = gt_mlb_column_labels("BAL", "mlb_logo"),
                 TEX = gt_mlb_column_labels("TEX", "scoreboard_logo"),
                 "Mike_Trout" = gt_mlb_column_labels(545361, "headshot"),
                 "Shohei_Ohtani" = gt_mlb_column_labels(660271, "headshot"))
}
