% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.rbind.R
\name{df.rbind}
\alias{df.rbind}
\title{Combine Data Frames by Rows, Filling in Missing Columns}
\usage{
df.rbind(...)
}
\arguments{
\item{...}{a sequence of data frame to be row bind together. This argument can be a
list of data frames, in which case all other arguments are ignored.
Any \code{NULL} inputs are silently dropped. If all inputs are \code{NULL},
the output is also \code{NULL}.}
}
\value{
Returns a single data frame
}
\description{
This function takes a sequence of data frames and combines them by rows, while filling in missing
columns with \code{NA}s.
}
\details{
This is an enhancement to \code{\link{rbind}} that adds in columns that are not present in all inputs,
accepts a sequence of data frames, and operates substantially faster.

Column names and types in the output will appear in the order in which they were encountered.

Unordered factor columns will have their levels unified and character data bound with factors will
be converted to character. POSIXct data will be converted to be in the same time zone.
Array and matrix columns must have identical dimensions after the row count. Aside from these there
are no general checks that each column is of consistent data type.
}
\note{
This function is a copy of the \code{rbind.fill()} function in the \pkg{plyr}
package by Hadley Wickham.
}
\examples{
adat <- data.frame(id = c(1, 2, 3),
                   a = c(7, 3, 8),
                   b = c(4, 2, 7))

bdat <- data.frame(id = c(4, 5, 6),
                   a = c(2, 4, 6),
                   c = c(4, 2, 7))

cdat <- data.frame(id = c(7, 8, 9),
                   a = c(1, 4, 6),
                   d = c(9, 5, 4))

# Example 1
df.rbind(adat, bdat, cdat)
}
\references{
Wickham, H. (2011). The split-apply-combine strategy for data analysis.
\emph{Journal of Statistical Software, 40}, 1-29. https://doi.org/10.18637/jss.v040.i01

Wickham, H. (2019). plyr: Tools for Splitting, Applying and Combining Data. R package
version 1.8.5.
}
\seealso{
\code{\link{df.duplicated}}, \code{\link{df.merge}},
\code{\link{df.move}},
\code{\link{df.rename}}, \code{\link{df.sort}},
\code{\link{df.subset}}
}
\author{
Hadley Wickham
}
