library(mirai)

nanotest <- function(x) invisible(x || stop("is not TRUE when expected to be TRUE"))
nanotestn <- function(x) invisible(is.null(x) || stop("is not NULL when expected to be NULL"))
nanotestz <- function(x) invisible(x == 0L || stop("does not equal 0L as expected"))
nanotesto <- function(x) invisible(x == 1L || stop("does not equal 1L as expected"))
nanotestp <- function(x) invisible(is.character(capture.output(print(x))) || stop("print output of expression cannot be captured as a character value"))
nanotesterr <- function(x, e = "")
  invisible(grepl(e, tryCatch(x, error = identity)[["message"]], fixed = TRUE) || stop("expected error message '", e, "' not generated"))

nanotest(is.list(status()))
nanotestn(nextstream())
nanotestn(nextget("pid"))
nanotestz(status()[["connections"]])
nanotestz(status()[["daemons"]])
nanotesterr(launch_remote("ws://[::1]:5555", remote = remote_config(command = "echo", args = "invalid")), "must be an element")
nanotesterr(launch_remote(c("tcp://localhost:5555", "tcp://localhost:6666", "tcp://localhost:7777"), remote = remote_config(command = "echo", args = list(c("test", "."), c("test", ".")))), "length of 'args'")
nanotesterr(launch_local(1L), "requires daemons to be set")
nanotesto(daemons(1L, dispatcher = FALSE))
me <- mirai(mirai::mirai(), .timeout = 2000L)
nanotest(is_mirai_error(call_mirai(me)$data) || is_error_value(me$data))
nanotest(!is_mirai_interrupt(me$data))
nanotest(is_error_value(me[["data"]]))
nanotestp(me$data)
df <- data.frame(a = 1, b = 2)
dm <- mirai(as.matrix(df), .args = list(df), .timeout = 2000L)
nanotest(is_mirai(call_mirai(dm)))
nanotest(!unresolved(dm))
nanotest(is.matrix(dm$data) || is_error_value(dm$data))
nanotesto(status()[["connections"]])
nanotest(is.character(status()[["daemons"]]))
nanotestz(daemons(0L))
nanotesterr(daemons(url = "URL"), "Invalid argument")
nanotesterr(daemons(-1), "zero or greater")
nanotesterr(daemons(n = 0, url = "ws://localhost:0"), "1 or greater")
nanotesterr(daemons(raw(0L)), "must be numeric")
nanotesterr(daemon("URL"), "Invalid argument")
nanotesterr(dispatcher(client = "URL"), "at least one")
nanotest(is_mirai_interrupt(r <- mirai:::mk_interrupt_error()))
nanotestp(r)
nanotestz(daemons(0L))
nanotestz(status()[["connections"]])
nanotestz(status()[["daemons"]])
Sys.sleep(1L)
n <- 3L
m <- mirai({
  Sys.sleep(0.1)
  q <- m + n + 1L
  q / m
}, m = 2L, .args = list(n), .timeout = 2000L)
b <- .(m %>>% rnorm() %>>% as.character)
b2 <- .(m$data %>>% as.character())
nanotestp(b)
nanotest(inherits(call_mirai(m), "mirai"))
nanotest(m$data == 3L || is_error_value(m$data))
nanotest(identical(call_mirai(m), m))
nanotest(is_mirai(m))
nanotest(!unresolved(b))
nanotest(!unresolved(b2$data))
nanotest(is.environment(b) && is.character(b$data))
nanotest(is.environment(b2) && is.character(b2$data))
Sys.sleep(2.5)
nanotestp(m)
nanotestp(b)
`lang obj` <- quote(m + n + 2L)
args <- list(m = 2L, n = 4L)
m <- mirai(.expr = `lang obj`, .args = args, .timeout = 2000L)
nanotest(call_mirai(m)$data == 8L || is_error_value(m$data))
Sys.sleep(2.5)
nanotest(daemons(url = value <- mirai:::auto_tokenized_url(), dispatcher = FALSE) == value)
nanotest(grepl("://", launch_remote(status()$daemons), fixed = TRUE))
nanotestz(daemons(0L))
Sys.sleep(1L)
nanotesto(daemons(1L, dispatcher = FALSE, idletime = 500L, timerstart = 1L, cleanup = 0L, seed = 1546, .compute = "new"))
nanotest(is.character(nextget("urls", .compute = "new")))
nanotest(is.integer(nextstream(.compute = "new")))
Sys.sleep(1.5)
mn <- mirai("test1", .compute = "new")
mp <- mirai("test2", .compute = "new")
Sys.sleep(1L)
nanotest(mn$data == "test1" || unresolved(mn$data))
nanotest(mp$data == "test2" || unresolved(mp$data))
Sys.sleep(1L)
nanotestz(status(.compute = "new")[["connections"]])
nanotestz(daemons(0L, .compute = "new"))
nanotesterr(daemons(n = 1, maxtasks = "100"), "'...' arguments")
Sys.sleep(1L)
nanotest(is.list(ssh_config("ssh://remotehost")))
nanotesterr(ssh_config("ssh://remotehost", tunnel = TRUE), "must be called in the correct context")
if (.Platform[["OS.type"]] != "windows") {
  mlc <- launch_remote("ws://[::1]:5555")
  nanotest(is.character(mlc))
  nanotest(inherits(mlc, "miraiLaunchCmd"))
  nanotestp(mlc)
  nanotest(is_mirai(m <- mirai(TRUE)))
  nanotest(is.character(launch_remote("ws://[::1]:5555", remote = remote_config(command = "echo", args = list(c("Test out:", ".", ">/dev/null")), rscript = "/usr/lib/R/bin/Rscript"))))
  nanotest(is.character(launch_remote("tcp://localhost:5555", remote = ssh_config(remotes = c("ssh://remotehost", "ssh://remotenode"), tunnel = TRUE, command = "echo"))))
  Sys.sleep(2.5)
  nanotestn(launch_local(mirai:::auto_tokenized_url(), .compute = "test"))
  Sys.sleep(1L)
  nanotest(daemons(n = 2L, url = value <- "ws://:0", dispatcher = FALSE, remote = remote_config()) != value)
  nanotestz(daemons(0L))
  Sys.sleep(1L)
  nanotesto(daemons(url = "ws://:0", token = TRUE))
  nanotestz(daemons(0L))
  Sys.sleep(1L)
  nanotesto(daemons(url = "tcp://:0", token = TRUE))
  nanotestz(daemons(0L))
  Sys.sleep(1L)
  nanotest(daemons(n = 2, "ws://:0", lock = TRUE) == 2L)
  nanotest(is.integer(nextget("pid")))
  nanotest(length(nextget("urls")) == 2L)
  Sys.sleep(1L)
  status <- status()[["daemons"]]
  nanotest(is.matrix(status) || is_error_value(status))
  if (is.matrix(status)) {
    nanotest(is.character(dn1 <- dimnames(status)[[1L]]))
    nanotest(is.character(parse1 <- nanonext::parse_url(dn1[1L])))
    nanotest(is.character(parse2 <- nanonext::parse_url(dn1[2L])))
    nanotest((port <- as.integer(parse1[["port"]])) > 0L)
    nanotest(as.integer(parse2[["port"]]) == port)
    nanotest(parse1[["path"]] == "/1")
    nanotest(parse2[["path"]] == "/2")
    nanotestz(sum(status[, "online"]))
    nanotestz(sum(status[, "instance"]))
    nanotestz(sum(status[, "assigned"]))
    nanotestz(sum(status[, "complete"]))
  }
  nanotest(is.character(saisei(i = 1L)))
  nanotestn(saisei(i = 0L))
  nanotest(is.character(saisei(i = 1L, force = TRUE)))
  nanotestn(saisei(i = 10L))
  Sys.sleep(0.5)
  nanotestz(daemons(0))
  Sys.sleep(1L)
  nanotest(daemons(n = 2, "tcp://:0") == 2L)
  Sys.sleep(1L)
  nanotestn(launch_local(mirai:::..[["default"]][["urls"]][1L], maxtasks = 1L))
  Sys.sleep(1L)
  tstatus <- status()[["daemons"]]
  nanotest(is.matrix(tstatus) || is_error_value(tstatus))
  if (is.matrix(tstatus)) {
    nanotest(is.character(tdn1 <- dimnames(tstatus)[[1L]]))
    nanotest(is.character(tparse1 <- nanonext::parse_url(tdn1[1L])))
    nanotest(is.character(tparse2 <- nanonext::parse_url(tdn1[2L])))
    nanotest((tport <- as.integer(tparse1[["port"]])) > 0L)
    nanotest(as.integer(tparse2[["port"]]) != tport)
    nanotestz(sum(tstatus[, "online"]))
    nanotestz(sum(tstatus[, "instance"]))
    nanotestz(sum(tstatus[, "assigned"]))
    nanotestz(sum(tstatus[, "complete"]))
  }
  nanotestz(daemons(0))
  Sys.sleep(1L)
  cl <- make_cluster(1)
  nanotest(inherits(cl, "miraiCluster"))
  nanotest(inherits(cl, "cluster"))
  nanotest(length(cl) == 1L)
  nanotest(is.character(launch_remote(cl)))
  nanotest(is.character(launch_remote(cl[[1L]])))
  nanotest(is.list(status(cl)))
  nanotestn(stop_cluster(cl))
  Sys.sleep(1L)
}
if (Sys.getenv("NOT_CRAN") == "true" && .Platform[["OS.type"]] != "windows") {
  nanotesto(daemons(url = "wss://127.0.0.1:0", token = TRUE, pass = "test"))
  nanotestn(launch_local(1L))
  Sys.sleep(1L)
  nanotest(grepl("CERTIFICATE", launch_remote(1L), fixed = TRUE))
  nanotesterr(launch_local(0:1), "out of bounds")
  nanotesterr(launch_remote(1:2), "out of bounds")
  nanotestz(daemons(0L))
  Sys.sleep(1L)
  option <- 15L
  nanotesto(daemons(1, dispatcher = TRUE, maxtasks = 10L, timerstart = 1L, walltime = 1000L, seed = 1546, token = TRUE, lock = TRUE, cleanup = option))
  Sys.sleep(1L)
  mq <- mirai("daemon", .timeout = 1000)
  nanotestn(saisei(i = 1L))
  nanotest(call_mirai(mq)$data == "daemon" || is_error_value(mq$data))
  mq <- mirai(Sys.sleep(1.5), .timeout = 500)
  dstatus <- status()[["daemons"]]
  nanotest(is.matrix(dstatus) || is_error_value(dstatus))
  Sys.sleep(2L)
  nanotestz(daemons(0))
  Sys.sleep(1L)
}
Sys.sleep(1L)
