% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCorrelations.R
\name{plotCorrelations}
\alias{plotCorrelations}
\title{plotCorrelations}
\usage{
plotCorrelations(
  miceObj,
  vars = names(miceObj$callParams$vars),
  factCorrMetric = "CramerV",
  numbCorrMetric = "pearson",
  ...
)
}
\arguments{
\item{miceObj}{an object of class miceDefs, created by the miceRanger function.}

\item{vars}{the variables you want to plot. Default is to plot all variables. Can be a vector of
variable names, or one of 'allNumeric' or 'allCategorical'}

\item{factCorrMetric}{The correlation metric for categorical variables. Can be one of:
\itemize{
  \item {\code{"CramerV"}} Cramer's V correlation metric.
  \item {\code{"Chisq"}} Chi Square test statistic.
  \item {\code{"TschuprowT"}} Tschuprow's T correlation metric.
  \item {\code{"Phi"}} (Binary Variables Only) Phi coefficient.
  \item {\code{"YuleY"}} (Binary Variables Only) Yule's Y, also known as coefficient of colligation
  \item {\code{"YuleQ"}} (Binary Variables Only) Yule's Q, related to Yule's Y by Q=2Y/(1+Y^2)
}}

\item{numbCorrMetric}{The correlation metric for numeric variables. Can be one of:
\itemize{
  \item {\code{"pearson"}} Pearson's Correlation Coefficient
  \item {\code{"spearman"}} Spearman's Rank Correlation Coefficient
  \item {\code{"kendall"}} Kendall's Rank Correlation Coefficient
  \item {\code{"Rsquared"}} R-squared
}}

\item{...}{Other arguments to pass to ggarrange()}
}
\value{
an object of class \code{ggarrange}.
}
\description{
Plot the correlation of imputed values between every combination of datasets for each variable.
}
\examples{
data("sampleMiceDefs")
plotCorrelations(sampleMiceDefs)
}
