% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infotheo.R
\name{mf.infotheo}
\alias{mf.infotheo}
\alias{mf.infotheo.default}
\alias{mf.infotheo.formula}
\title{Information-theoretic meta-features}
\usage{
mf.infotheo(...)

\method{mf.infotheo}{default}(x, y, features = "all", summary = c("mean",
  "sd"), ...)

\method{mf.infotheo}{formula}(formula, data, features = "all",
  summary = c("mean", "sd"), ...)
}
\arguments{
\item{...}{Optional arguments to the summary methods.}

\item{x}{A data.frame contained only the input attributes}

\item{y}{a factor response vector with one label for each row/component of x.}

\item{features}{A list of features names or \code{"all"} to include all them.}

\item{summary}{A list of methods to summarize the results as post-processing
functions. See \link{post.processing} method to more information. (Default:
\code{c("mean", "sd")})}

\item{formula}{A formula to define the class column.}

\item{data}{A data.frame dataset contained the input attributes and class
The details section describes the valid values for this group.}
}
\value{
A list named by the requested meta-features.
}
\description{
Information-theoretic meta-features are particularly appropriate to describe
discrete (categorical) attributes, but they also fit continuous ones.
}
\details{
TODO describe discretization method
 The following features are allowed for this method:
 \describe{
   \item{"attributes.concentration"}{Represents the association between the
     nominal attributes. It is the Goodman and Kruskal's tau measure
     otherwise known as the concentration coefficient.}
   \item{"attribute.entropy"}{Represents the normalized entropy (a measure of
     randomness) of each attributes in the dataset.}
   \item{"class.concentration"}{Represents the association between the
     nominal attributes and the class. It is the Goodman and Kruskal's tau
     measure otherwise known as the concentration coefficient.}
   \item{"class.entropy"}{Represents the normalized entropy of the class that
     describes how much information is necessary to specify one class in
     the dataset.}
   \item{"equivalent.attributes"}{Represents the the number of attributes
     suitable to optimally solve the classification task using the dataset.}
   \item{"joint.entropy"}{Represents the total entropy of each attribute and
     the classe in the dataset.}
   \item{"mutual.information"}{Represents the common information shared
     between each attribute and the class in the dataset.}
   \item{"noise.signal"}{Represents the amount of irrelevant information
     contained in the dataset.}
 }
 Each one of these meta-features generate multiple values (by attribute
 and/or class value) and then it is post processed by the summary methods.
 See the \link{post.processing} method for more details about it.
}
\examples{
## Extract all metafeatures
mf.infotheo(Species ~ ., iris)

## Extract some metafeatures
mf.infotheo(iris[1:4], iris[5], c("class.entropy", "joint.entropy"))

## Use another summary methods
mf.infotheo(Species ~ ., iris, summary=c("min", "median", "max"))
}
\references{
Michie, E. D., Spiegelhalter, D. J., & Taylor, C. C. (1994).
   Machine Learning , Neural and Statistical Classification.
   Technometrics, 37(4), 459.

 Kalousis, A., & Hilario, M. (2001). MODEL SELECTION VIA META-LEARNING: A
   COMPARATIVE STUDY. International Journal on Artificial Intelligence Tools,
   10(4), 525-554.

 Castiello, C., Castellano, G., & Fanelli, A. M. (2005). Meta-data:
   Characterization of Input Features for Meta-learning. In Proceedings of
   the 2nd International Conference on Modeling Decisions for Artificial
   Intelligence (Vol. 3558, pp. 457-468).
}
\seealso{
Other meta.features: \code{\link{mf.discriminant}},
  \code{\link{mf.general}}, \code{\link{mf.landmarking}},
  \code{\link{mf.model.based}},
  \code{\link{mf.statistical}}
}

