% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesOverall.R
\name{sesOverall}
\alias{sesOverall}
\title{Overall per simulation-null-metric SES test}
\usage{
sesOverall(simulation.list, test, direction)
}
\arguments{
\item{simulation.list}{A summarized results list such as one output from
reduceResults(). See examples.}

\item{test}{Either "ttest" or "wilcotest", depending on whether the user wants to run
a two-sided t-test or a Wilcoxon signed rank test.}

\item{direction}{Character vector that needs to be provided if spatial simulations
beyond the standard "random", "filtering", and "competition" simulations are run.
The character vector must be the same length as the number of spatial simulations that
were run, and can take the possible values of "two.sided" (for a two-tailed test when
the SES scores are expected to be centered around 0), "less" (for when the observed SES
scores are expected to be less than 0), and "greater" (for when the observed SES scores
are expected to be greater than 0). For instance, habitat filtering would be set to
"less". The relevant simulation to which these directional tests will be applied can be
determined by calling names(simulation.list).}
}
\value{
A data frame summarizing the mean, overall standardized effect sizes and the
significance of those deviations from expectations for each simulation, null, metric
combination. This test works across all iterations, and looks for overall shifts in
SES from expectations (see details for for expectations).
}
\description{
This function provides one of many ways of summarizing and considering simulation
results.
}
\details{
This function provides one way of summarizing and considering simulation
results. It takes as input a vector of all standardized effect sizes for all plots
from a given simulation-null-metric combination, and calculates the mean of the vector
and whether it differs significantly from a mean of zero. It does this either with a
simple two-sided t-test, or with a Wilcoxon signed rank test. If the latter, and if
there are three different spatial simulations with names random, filtering and
competition, the test is two-sided, less and greater, respectively. If additional
spatial simulations are included, requiring modified expectations, these can be passed
along with the "direction" argument.
}
\examples{
#not run
#results <- readIn()
#summ <- reduceResults(results)
#examp <- sesOverall(summ$ses, test="wilcotest")
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2016. Phylogenetic community
structure metrics and null models: a review with new methods and software.
Ecography DOI: 10.1111/ecog.02070
}
