% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpcorr.R
\name{print.lpcor}
\alias{print.lpcor}
\title{Print the partial correlation coefficients}
\usage{
\method{print}{lpcor}(x, export = FALSE, file.name = NULL, digits = 3, ...)
}
\arguments{
\item{x}{An object of class \code{lpcor} or \code{lpcor_group}.}

\item{export}{A logical argument. If \code{TRUE}, a *.txt file is exported
to the working directory}

\item{file.name}{The name of the file if \code{export = TRUE}}

\item{digits}{The significant digits to be shown.}

\item{...}{Options used by the tibble package to format the output. See
\code{\link[tibble:formatting]{tibble::print()}} for more details.}
}
\description{
Print an object of class \code{lpcor} or or \code{lpcor_group} in two ways.
By default, the results are shown in the R console. The results can also be
exported to the directory.
}
\examples{
\donttest{
library(metan)
pcor <- lpcor(data_ge2, NR, NKR, NKE)
print(pcor)

# Compute the correlations for each level of the factor ENV
lpc2 <- lpcor(data_ge2,
              NR, NKR, NKE,
              by = ENV)
print(lpc2)
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
