% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gytb.R
\name{gytb}
\alias{gytb}
\title{Genotype by yield*trait biplot}
\usage{
gytb(
  .data,
  gen,
  yield,
  traits = everything(),
  ideotype = NULL,
  weight = NULL,
  prefix = "Y",
  centering = "trait",
  scaling = "sd",
  svp = "trait"
)
}
\arguments{
\item{.data}{The dataset containing the columns related to Genotypes, Yield,
and Traits.}

\item{gen}{The name of the column that contains the levels of the genotypes.}

\item{yield}{The column containing the yield values.}

\item{traits}{The column(s) with the \emph{traits} values. Defaults to
\emph{NULL}. In this case, all numeric traits in \code{.data}, except that
in \code{yield} are selected. To select specific traits from \code{.data},
use a list of unquoted comma-separated variable names (e.g. \emph{traits =
c(var1, var2, var3)}), an specific range of variables, (e.g. \emph{traits =
c(var1:var3)}), or even a select helper like \code{starts_with("N")}.}

\item{ideotype}{A vector of \code{"h"} or \code{"l"} with the same length of
\code{traits} to define which trait is desired to increase or decrease. By
default (\code{ideotype = NULL}) for all numeric traits in \code{traits}
are assumed that high values is desirable. Following the order of the
traits selected in \code{traits}, use \code{"h"} to indicate the traits in
which higher values are desired or \code{"l"} to indicate the variables in
which lower values are desired. Then, \code{yield } will be multiplied by
traits with \code{"h"} and divided by traits with \code{"l"} to generate
the Genotype by yield*trait table. For example, \code{ideotype = c("h, h,
  l")} will assume that the ideotype has higher values for the first two
traits and lower values for the last trait.}

\item{weight}{The weight assumed for each trait. Similar to \code{ideotype}
argument, provide a numeric vector of the same length of \code{traits}.
Suggested values are between 0 and 2.}

\item{prefix}{The prefix used in the biplot for the yield*trait combinations.
Defaults to \code{"Y"}.}

\item{centering}{The centering method. Must be one of the \code{'none | 0'},
for no centering; \code{'global | 1'}, for global centered (T+G+GYT);
\code{'trait | 2'} (default), for trait-centered (G+GYT); or \code{'double |
  3'}, for double centered (GYT). A biplot cannot be produced with models
produced without centering.}

\item{scaling}{The scaling method. Must be one of the \code{'none | 0'}, for
no scaling; or \code{'sd | 1'} (default), so that the mean for each trait
or yield-trait combination becomes 0 and the variance becomes unit.}

\item{svp}{The method for singular value partitioning. Must be one of the
\code{'genotype | 1'}, (The singular value is entirely partitioned into the
genotype eigenvectors, also called row metric preserving); \code{'trait |
  2'}, default, (The singular value is entirely partitioned into the trait
eigenvectors, also called column metric preserving); or \code{'symmetrical
  | 3'} (The singular value is symmetrically partitioned into the genotype
and the trait eigenvectors This SVP is most often used in AMMI analysis and
other biplot analysis, but it is not ideal for visualizing either the
relationship among genotypes or that among the traits).}
}
\value{
The function returns a list of class \code{gge} that is compatible with the function \code{plot()} used in \code{\link{gge}()}.
\itemize{
\item \strong{data} The Genotype by yield\*trait (GYT) data.
\item \strong{ge_mat} The Genotype by yield\*trait (GYT) data  (scaled and centered).
\item \strong{coordgen} The coordinates for genotypes for all components.
\item \strong{coordenv} The coordinates for traits for all components.
\item \strong{eigenvalues} The vector of eigenvalues.
\item \strong{totalvar} The overall variance.
\item \strong{labelgen} The name of the genotypes.
\item \strong{labelenv} The names of the traits.
\item \strong{labelaxes} The axes labels.
\item \strong{centering} The centering method.
\item \strong{scaling} The scaling method.
\item \strong{svp} The singular value partitioning method.
\item \strong{d} The factor used to generate in which the ranges of genotypes
and traits are comparable when singular value partitioning is set to
'genotype' or 'trait'.
\item \strong{grand_mean} The grand mean of the trial.
\item \strong{mean_gen} A vector with the means of the genotypes.
\item \strong{mean_env} A vector with the means of the traits.
\item \strong{scale_var} The scaling vector when the scaling method is \code{'sd'}.
}
}
\description{
Produces a Genotype by Yield*Trait biplot (GTY) proposed by Yan and
Fregeau-Reid (2018).
}
\examples{
\donttest{
library(metan)
# GYT biplot for all numeric traits of 'data_g'
# KW (kernel weight) considered as 'yield',
mod <- gytb(data_g, GEN, KW)
plot(mod)

}
}
\references{
Yan, W., & Fregeau-Reid, J. (2018). Genotype by Yield\*Trait (GYT) Biplot: a
Novel Approach for Genotype Selection based on Multiple Traits. Scientific
Reports, 8(1), 1-10. \doi{10.1038/s41598-018-26688-8}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
