% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamem.R
\name{gamem}
\alias{gamem}
\title{Genotype analysis by mixed-effect models}
\usage{
gamem(
  .data,
  gen,
  rep,
  resp,
  block = NULL,
  by = NULL,
  prob = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{.data}{The dataset containing the columns related to, Genotypes,
replication/block and response variable(s).}

\item{gen}{The name of the column that contains the levels of the genotypes,
that will be treated as random effect.}

\item{rep}{The name of the column that contains the levels of the
replications (assumed to be fixed).}

\item{resp}{The response variable(s). To analyze multiple variables in a
single procedure a vector of variables may be used. For example \code{resp =
c(var1, var2, var3)}. Select helpers are also allowed.}

\item{block}{Defaults to \code{NULL}. In this case, a randomized complete
block design is considered. If block is informed, then an alpha-lattice
design is employed considering block as random to make use of inter-block
information, whereas the complete replicate effect is always taken as
fixed, as no inter-replicate information was to be recovered (Mohring et
al., 2015).}

\item{by}{One variable (factor) to compute the function by. It is a shortcut
to \code{\link[dplyr]{group_by}()}.This is especially useful, for example,
when the researcher want to fit a mixed-effect model for each environment.
In this case, an object of class gamem_grouped is returned.
\code{\link{mgidi}} can then be used to compute the mgidi index within each
environment.}

\item{prob}{The probability for estimating confidence interval for BLUP's
prediction.}

\item{verbose}{Logical argument. If \code{verbose = FALSE} the code are run
silently.}
}
\value{
An object of class \code{gamem} or \code{gamem_grouped}, which is a
list with the following items for each element (variable):
\itemize{
\item \strong{fixed:} Test for fixed effects.
\item \strong{random:} Variance components for random effects.
\item \strong{LRT:} The Likelihood Ratio Test for the random effects.
\item \strong{BLUPgen:} The estimated BLUPS for genotypes
\item \strong{ranef:} The random effects of the model
\item \strong{Details:} A tibble with the following data: \code{Ngen}, the
number of genotypes; \code{OVmean}, the grand mean; \code{Min}, the minimum
observed (returning the genotype and replication/block); \code{Max} the
maximum observed, \code{MinGEN} the winner genotype, \code{MaxGEN}, the
loser genotype.
\item \strong{ESTIMATES:} A tibble with the values:
\itemize{
\item \code{Gen_var}, the genotypic variance and ;
\item \code{rep:block_var} block-within-replicate variance (if
an alpha-lattice design is used by informing the block in \code{block});
\item \code{Res_var}, the residual variance;
\item \code{Gen (\%), rep:block (\%), and Res (\%)} the respective contribution
of variance components to the phenotypic variance;
\item \code{H2}, broad-sense heritability;
\item \code{h2mg}, heritability on the entry-mean basis;
\item \code{Accuracy}, the accuracy of selection (square root of
\code{h2mg});
\item \code{CVg}, genotypic coefficient of variation;
\item \code{CVr}, residual coefficient of variation;
\item \code{CV ratio}, the ratio between genotypic and residual coefficient of
variation.
}
\item \strong{residuals:} The residuals of the model.
\item \strong{formula} The formula used to fit the model.
}
}
\description{
Analysis of genotypes in single experiments using mixed-effect models with
estimation of genetic parameters.
}
\details{
\code{gamem} analyses data from a one-way genotype testing experiment.
By default, a randomized complete block design is used according to the following model:
\loadmathjax
\mjsdeqn{Y_{ij} = m + g_i + r_j + e_{ij}}
where \mjseqn{Y_{ij}} is the response variable of the ith genotype in the \emph{j}th block;
\emph{m} is the grand mean (fixed); \mjseqn{g_i} is the effect of the \emph{i}th genotype
(assumed to be random); \mjseqn{r_j} is the effect of the \emph{j}th replicate (assumed to be fixed);
and \mjseqn{e_{ij}} is the random error.

When \code{block} is informed, then a resolvable alpha design is implemented, according to the following model:

\mjsdeqn{Y_{ijk} = m + g_i + r_j + b_{jk} + e_{ijk}}
where where \mjseqn{y_{ijk}} is the response variable of the \emph{i}th genotype in the
\emph{k}th block of the \emph{j}th replicate; \emph{m} is the intercept, \mjseqn{t_i} is
the effect for the \emph{i}th genotype \mjseqn{r_j} is the effect of the \emph{j}th
replicate, \mjseqn{b_{jk}} is the effect of the \emph{k}th incomplete block of
the \emph{j}th replicate, and \mjseqn{e_{ijk}} is the plot error effect
corresponding to \mjseqn{y_{ijk}}.
}
\examples{
\donttest{
library(metan)

# fitting the model considering an RCBD
# Genotype as random effects

rcbd <- gamem(data_g,
             gen = GEN,
             rep = REP,
             resp = c(PH, ED, EL, CL, CW, KW, NR, TKW, NKE))

# Likelihood ratio test for random effects
get_model_data(rcbd, "lrt")


# Variance components
get_model_data(rcbd, "vcomp")

# Genetic parameters
get_model_data(rcbd, "genpar")

# random effects
get_model_data(rcbd, "ranef")

# Predicted values
predict(rcbd)

# fitting the model considering an alpha-lattice design
# Genotype and block-within-replicate as random effects
# Note that block effect was now informed.

alpha <- gamem(data_alpha,
               gen = GEN,
               rep = REP,
               block = BLOCK,
               resp = YIELD)
# Genetic parameters
get_model_data(alpha, "genpar")

# Random effects
get_model_data(alpha, "ranef")
}

}
\references{
Mohring, J., E. Williams, and H.-P. Piepho. 2015. Inter-block information:
to recover or not to recover it? TAG. Theor. Appl. Genet. 128:1541-54.
\doi{10.1007/s00122-015-2530-0}
}
\seealso{
\code{\link{get_model_data}} \code{\link{waasb}}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
