% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/can_cor.R
\name{can_corr}
\alias{can_corr}
\title{Canonical correlation analysis}
\usage{
can_corr(
  .data,
  FG,
  SG,
  by = NULL,
  use = "cor",
  test = "Bartlett",
  prob = 0.05,
  center = TRUE,
  stdscores = FALSE,
  verbose = TRUE,
  collinearity = TRUE
)
}
\arguments{
\item{.data}{The data to be analyzed. It can be a data frame (possible with
grouped data passed from \code{\link[dplyr]{group_by}()}.}

\item{FG, SG}{A comma-separated list of unquoted variable names that will
compose the first (smallest) and second (highest) group of the correlation
analysis, respectively. Select helpers are also allowed.}

\item{by}{One variable (factor) to compute the function by. It is a shortcut
to \code{\link[dplyr]{group_by}()}. To compute the statistics by more than
one grouping variable use that function.}

\item{use}{The matrix to be used. Must be one of 'cor' for analysis using the
correlation matrix (default) or 'cov' for analysis using the covariance
matrix.}

\item{test}{The test of significance of the relationship between the FG and
SG. Must be one of the 'Bartlett' (default) or 'Rao'.}

\item{prob}{The probability of error assumed. Set to 0.05.}

\item{center}{Should the data be centered to compute the scores?}

\item{stdscores}{Rescale scores to produce scores of unit variance?}

\item{verbose}{Logical argument. If \code{TRUE} (default) then the results
are shown in the console.}

\item{collinearity}{Logical argument. If \code{TRUE} (default) then a
collinearity diagnostic is performed for each group of variables according
to Olivoto et al.(2017).}
}
\value{
If \code{.data} is a grouped data passed from
\code{\link[dplyr]{group_by}()} then the results will be returned into a
list-column of data frames.
\itemize{
\item \strong{Matrix} The correlation (or covariance) matrix of the variables
\item \strong{MFG, MSG} The correlation (or covariance) matrix for the variables of
the first group or second group, respectively.
\item \strong{MFG_SG} The correlation (or covariance) matrix for the variables of the
first group with the second group.
\item \strong{Coef_FG, Coef_SG} Matrix of the canonical coefficients of the first
group or second group, respectively.
\item Loads_FG, Loads_SG Matrix of the canonical loadings of the first group
or second group, respectively.
\item \strong{Score_FG, Score_SG} Canonical scores for the variables in FG and SG,
respectively.
\item \strong{Crossload_FG, Crossload_FG} Canonical cross-loadings for FG variables
on the SG scores, and cross-loadings for SG variables on the FG scores,
respectively.
\item \strong{SigTest} A dataframe with the correlation of the canonical pairs and
hypothesis testing results.
\item \strong{collinearity} A list with the collinearity diagnostic for each group of
variables.
}
}
\description{
Performs canonical correlation analysis with collinearity diagnostic,
estimation of canonical loads, canonical scores, and hypothesis testing for
correlation pairs.
}
\examples{
\donttest{
library(metan)

cc1 <- can_corr(data_ge2,
               FG = c(PH, EH, EP),
               SG = c(EL, ED, CL, CD, CW, KW, NR))


# Canonical correlations for each environment
cc3 <- data_ge2 \%>\%
       can_corr(FG = c(PH, EH, EP),
                SG = c(EL, ED, CL, CD, CW, KW, NR),
                by = ENV,
                verbose = FALSE)

}
}
\references{
Olivoto, T., V.Q. Souza, M. Nardino, I.R. Carvalho, M. Ferrari, A.J.
Pelegrin, V.J. Szareski, and D. Schmidt. 2017. Multicollinearity in path
analysis: a simple method to reduce its effects. Agron. J. 109:131-142.
\doi{10.2134/agronj2016.04.0196}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
