% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_convert.R
\name{es_convert}
\alias{es_convert}
\title{Effect Size Converter}
\usage{
es_convert(x, from = c("d", "or", "r"), to = c("d", "or", "r"))
}
\arguments{
\item{x}{numeric value}

\item{from}{(character) current effect size of \code{x}}

\item{to}{(character) effect size measure to convert to}
}
\description{
Converts between equivalent effect size measures: \emph{d}, \emph{r}, odds ratio.
}
\details{
Refer to vignette for further information.
}
\examples{
# Odds ratio to Cohen's d
es_convert(1.25, from = "or", to = "d")
}
\references{
Rosenthal R. (1994). Parametric measures of effect size. In H. Cooper & LV. Hedges (Eds.), \emph{The Handbook of Research Synthesis}. New York, NY: Sage.

Borenstein M, Hedges LV, Higgins JPT & Rothstein HR. (2009). \emph{Introduction to Meta-Analysis}. Chichester, West Sussex, UK: Wiley.
}
