% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{getrownames_byname}
\alias{getrownames_byname}
\title{Gets row names}
\usage{
getrownames_byname(a)
}
\arguments{
\item{a}{The matrix or data frame on which row names are to be retrieved}
}
\value{
row names of \code{a}
}
\description{
Gets row names in a way that is amenable to use in chaining operations in a functional programming way
}
\examples{
m <- matrix(c(1:6), nrow = 2, dimnames = list(paste0("i", 1:2), paste0("c", 1:3))) \%>\%
  setrowtype("Industries") \%>\% setcoltype("Commodities")
getrownames_byname(m)
# This also works for lists
getrownames_byname(list(m,m))
DF <- data.frame(m = I(list()))
DF[[1,"m"]] <- m
DF[[2,"m"]] <- m
getrownames_byname(DF$m)
}
