% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unary.R
\name{vectorize_byname}
\alias{vectorize_byname}
\title{Vectorize a matrix}
\usage{
vectorize_byname(a, sep = " -> ")
}
\arguments{
\item{a}{the matrix to be vectorized}

\item{sep}{a string to separate row names and col names in the resulting column vector.
Default is " -> " (an arrow indicating from row to column).}
}
\value{
a column vector containing all elements of \code{a}, with row names assigned as "rowname \code{sep} colname".
}
\description{
Converts a matrix into a column vector.
Each element of the matrix becomes an entry in the column vector,
with rows named as "rowname \code{sep} colname" of the matrix entry.
If "colname \code{sep} rowname" is desired,
transpose the matrix first with \code{\link[=transpose_byname]{transpose_byname()}}.
}
\details{
\code{rowtype} and \code{coltype} attributes are retained in the event that
the resulting vector is re-matricized with the \code{\link[=matricize_byname]{matricize_byname()}} function later.
}
\examples{
m <- matrix(c(1, 5,
              4, 5),
            nrow = 2, ncol = 2, byrow = TRUE, 
            dimnames = list(c("p1", "p2"), c("i1", "i2"))) \%>\% 
  setrowtype("Products") \%>\% setcoltype("Industries")
m
vectorize_byname(m, sep = " -> ")
# If a single number is provided, the number will be returned as a 1x1 column vector 
# with some additional attributes.
vectorize_byname(42)
attributes(vectorize_byname(42))
# If called with `NULL`, get `NULL` back
vectorize_byname(NULL)
}
