% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unary.R
\name{matricize_byname}
\alias{matricize_byname}
\title{Matricize a vector}
\usage{
matricize_byname(a, sep = " -> ")
}
\arguments{
\item{a}{a row (column) vector to be converted to a matrix based on its row (column) names}

\item{sep}{a string that separates prefixes (outgoing matrix rownames) and suffixes (outgoing matrix colnames)
in the names of the vector's
rows (for a column vector) or
columns (for a row vector).
Default is " -> " (an arrow).}
}
\value{
a matrix converted from vector \code{a}
}
\description{
Matricize a vector
}
\examples{
v <- matrix(c(1,
              2,
              3, 
              4), 
            nrow = 4, ncol = 1, dimnames = list(c("p1 -> i1", 
                                                  "p2 -> i1", 
                                                  "p1 -> i2", 
                                                  "p2 -> i2"))) \%>\% 
  setrowtype("Products") \%>\% setcoltype("Industries")
# Default separator is " -> ".
matricize_byname(v)
}
