/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.search.checker;

import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.integer.AbstractIntSConstraint;
import choco.kernel.solver.search.checker.AbstractSolutionCheckerEngine;
import choco.kernel.solver.search.checker.SolutionCheckerException;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.logging.Level;

public class SolutionCheckerEngine
extends AbstractSolutionCheckerEngine {
    public boolean enableConsistency = true;
    private String reuseLabel;

    public final boolean isConsistencyEnabled() {
        return this.enableConsistency;
    }

    public final void setEnableConsistency(boolean enableConsistency) {
        this.enableConsistency = enableConsistency;
    }

    @Override
    public boolean inspectVariable(Var var) {
        if (!var.isInstantiated()) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "  FAILURE Not Instantiated: {0}", var.pretty());
            }
            return false;
        }
        return true;
    }

    @Override
    public void checkVariable(Var var) throws SolutionCheckerException {
        if (!var.isInstantiated()) {
            throw new SolutionCheckerException("FAILURE Not Instantiated: " + var.pretty());
        }
    }

    public void checkConstraint(SConstraint c) throws SolutionCheckerException {
        if (!this.isSatisfied(c)) {
            throw new SolutionCheckerException("FAILURE " + this.reuseLabel + ": " + c.pretty());
        }
    }

    @Override
    public boolean inspectConstraint(SConstraint<?> c) {
        if (this.isSatisfied(c)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "  {0}: {1}", new Object[]{this.reuseLabel, c.pretty()});
            }
            return true;
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "  FAILURE {0}: {1}({2})", new Object[]{this.reuseLabel, c.pretty(), c.getClass().getSimpleName()});
        }
        return false;
    }

    protected boolean isSatisfied(SConstraint<?> c) {
        boolean isOk;
        if (c instanceof AbstractIntSConstraint) {
            try {
                isOk = this.isSatisfied((AbstractIntSConstraint)c);
            }
            catch (UnsupportedOperationException e) {
                LOGGER.log(Level.WARNING, "- Check solution: isSatisified(int[]) is not implemented: {0}", c);
                this.reuseLabel = "is isSatisified()";
                isOk = c.isSatisfied();
            }
        } else {
            this.reuseLabel = "is isSatisified()";
            isOk = c.isSatisfied();
        }
        return isOk;
    }

    protected boolean isSatisfied(AbstractIntSConstraint ic) throws UnsupportedOperationException {
        int[] tuple = new int[ic.getNbVars()];
        int[] tupleL = new int[ic.getNbVars()];
        int[] tupleU = new int[ic.getNbVars()];
        boolean fullInstantiated = true;
        for (int i = 0; i < ic.getNbVars(); ++i) {
            IntDomainVar v = (IntDomainVar)ic.getVar(i);
            if (v.isInstantiated()) {
                tuple[i] = v.getVal();
                tupleL[i] = tuple[i];
                tupleU[i] = tuple[i];
                continue;
            }
            fullInstantiated = false;
            tupleL[i] = v.getInf();
            tupleU[i] = v.getSup();
        }
        boolean isOk = true;
        if (fullInstantiated) {
            this.reuseLabel = "Fully Instantiated isSatisified(int[])";
            isOk = ic.isSatisfied(tuple);
        } else if (this.enableConsistency) {
            this.reuseLabel = "Consistency isSatisfied(int[])";
            isOk = ic.isSatisfied(tupleL) && ic.isSatisfied(tupleU);
        } else {
            this.reuseLabel = "No Consistency Test";
        }
        return isOk;
    }
}

