/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.opres.graph;

import choco.kernel.common.opres.graph.IBinaryNode;
import choco.kernel.common.opres.graph.INodeLabel;

abstract class AbstractBinaryNode
implements IBinaryNode {
    public final int id;
    protected IBinaryNode father;
    public final INodeLabel status;

    public AbstractBinaryNode(int id, INodeLabel status) {
        this.id = id;
        this.status = status;
    }

    @Override
    public final IBinaryNode getFather() {
        return this.father;
    }

    @Override
    public final int getID() {
        return this.id;
    }

    @Override
    public final INodeLabel getNodeStatus() {
        return this.status;
    }

    @Override
    public final boolean hasFather() {
        return this.father != null;
    }

    @Override
    public final void setFather(IBinaryNode father) {
        this.father = father;
    }

    @Override
    public void clear() {
        this.father = null;
    }

    @Override
    public void fireStatusChanged() {
        if (this.hasFather()) {
            this.getFather().getNodeStatus().updateInternalNode(this.getFather());
            this.getFather().fireStatusChanged();
        }
    }

    private final void childToDotty(StringBuilder buffer, IBinaryNode child) {
        buffer.append(this.getID()).append("->").append(child.getID()).append('\n');
        buffer.append(child.toDotty());
    }

    @Override
    public String toDotty() {
        String str;
        StringBuilder b = new StringBuilder();
        if (this.getNodeStatus() != null && !(str = this.getNodeStatus().toDotty()).isEmpty()) {
            b.append(this.getID()).append('[').append(str).append("]\n");
        }
        if (this.hasLeftChild()) {
            this.childToDotty(b, this.getLeftChild());
        }
        if (this.hasRightChild()) {
            this.childToDotty(b, this.getRightChild());
        }
        return new String(b);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getID());
        if (!this.isLeaf()) {
            b.append(" (");
            if (this.hasLeftChild()) {
                b.append(this.getLeftChild().getID());
            } else {
                b.append('-');
            }
            b.append(", ");
            if (this.hasRightChild()) {
                b.append(this.getRightChild().getID());
            } else {
                b.append('-');
            }
            b.append(')');
        }
        return new String(b);
    }
}

