/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.set;

import choco.cp.solver.variables.set.BitSetEnumeratedDomain;
import choco.cp.solver.variables.set.SetDomainIterator;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.propagation.PropagationEngine;
import choco.kernel.solver.variables.set.SetDomain;
import choco.kernel.solver.variables.set.SetSubDomain;
import choco.kernel.solver.variables.set.SetVar;
import java.util.Arrays;

public final class SetDomainImpl
implements SetDomain {
    private final PropagationEngine propagationEngine;
    private final SetVar variable;
    private final BitSetEnumeratedDomain kernel;
    private final BitSetEnumeratedDomain enveloppe;
    private SetDomainIterator _kiterator;
    private SetDomainIterator _eiterator;
    protected SetOpenDomainIterator _oiterator;

    public SetDomainImpl(SetVar v, int a, int b, IEnvironment environment, PropagationEngine propagationEngine) {
        this.variable = v;
        this.kernel = new BitSetEnumeratedDomain(v, a, b, false, environment);
        this.enveloppe = new BitSetEnumeratedDomain(v, a, b, true, environment);
        this.propagationEngine = propagationEngine;
    }

    public SetDomainImpl(SetVar v, int[] sortedValues, IEnvironment environment, PropagationEngine propagationEngine) {
        this.variable = v;
        this.kernel = new BitSetEnumeratedDomain(v, sortedValues, false, environment);
        this.enveloppe = new BitSetEnumeratedDomain(v, sortedValues, true, environment);
        this.propagationEngine = propagationEngine;
    }

    public SetDomainImpl(SetVar v, int[] sortedValues, boolean constant, IEnvironment environment, PropagationEngine propagationEngine) {
        this.variable = v;
        if (sortedValues.length > 0) {
            this.kernel = new BitSetEnumeratedDomain(v, sortedValues, constant, environment);
            this.enveloppe = new BitSetEnumeratedDomain(v, sortedValues, true, environment);
        } else {
            this.kernel = BitSetEnumeratedDomain.empty(v, environment);
            this.enveloppe = BitSetEnumeratedDomain.empty(v, environment);
        }
        this.propagationEngine = propagationEngine;
    }

    @Override
    public SetSubDomain getKernelDomain() {
        return this.kernel;
    }

    @Override
    public SetSubDomain getEnveloppeDomain() {
        return this.enveloppe;
    }

    public boolean addToKernel(int x) {
        this.kernel.add(x);
        return true;
    }

    @Override
    public boolean isInstantiated() {
        return this.kernel.getSize() == this.enveloppe.getSize();
    }

    boolean isInstantiatedTo(int[] setVal) {
        if (setVal.length == this.kernel.getSize() && setVal.length == this.enveloppe.getSize()) {
            for (int i = 0; i < setVal.length; ++i) {
                if (this.kernel.contains(setVal[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    boolean canBeInstantiatedTo(int[] setVal) {
        if (this.kernel.getSize() <= setVal.length && this.enveloppe.getSize() >= setVal.length) {
            int i;
            Arrays.sort(setVal);
            for (i = 0; i < setVal.length; ++i) {
                if (this.enveloppe.contains(setVal[i])) continue;
                return false;
            }
            i = this.kernel.getFirstVal();
            while (i >= 0) {
                if (Arrays.binarySearch(setVal, i) < 0) {
                    return false;
                }
                i = this.kernel.getNextValue(i);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        int val;
        StringBuilder buf = new StringBuilder("{Env[");
        int count = 0;
        DisposableIntIterator it = this.getEnveloppeIterator();
        while (it.hasNext()) {
            val = it.next();
            if (++count > 1) {
                buf.append(',');
            }
            buf.append(val);
        }
        it.dispose();
        buf.append("], Ker[");
        count = 0;
        it = this.getKernelIterator();
        while (it.hasNext()) {
            val = it.next();
            if (++count > 1) {
                buf.append(',');
            }
            buf.append(val);
        }
        it.dispose();
        buf.append("]}");
        return buf.toString();
    }

    @Override
    public String pretty() {
        return this.toString();
    }

    @Override
    public boolean remFromEnveloppe(int x, SConstraint cause, boolean forceAwake) throws ContradictionException {
        if (this._remFromEnveloppe(x, cause)) {
            if (this.isInstantiated()) {
                this.propagationEngine.postInstSet(this.variable, cause, forceAwake);
            } else {
                this.propagationEngine.postRemEnv(this.variable, cause, forceAwake);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addToKernel(int x, SConstraint cause, boolean forceAwake) throws ContradictionException {
        if (this._addToKernel(x, cause)) {
            if (this.isInstantiated()) {
                this.propagationEngine.postInstSet(this.variable, cause, forceAwake);
            } else {
                this.propagationEngine.postAddKer(this.variable, cause, forceAwake);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean instantiate(int[] x, SConstraint cause, boolean forceAwake) throws ContradictionException {
        if (this._instantiate(x, cause)) {
            this.propagationEngine.postInstSet(this.variable, cause, forceAwake);
            return true;
        }
        return false;
    }

    boolean _remFromEnveloppe(int x, SConstraint cause) throws ContradictionException {
        if (this.kernel.contains(x)) {
            this.propagationEngine.raiseContradiction(cause);
            return true;
        }
        if (this.enveloppe.contains(x)) {
            this.enveloppe.remove(x);
            return true;
        }
        return false;
    }

    boolean _addToKernel(int x, SConstraint cause) throws ContradictionException {
        if (!this.enveloppe.contains(x)) {
            this.propagationEngine.raiseContradiction(cause);
            return true;
        }
        if (!this.kernel.contains(x)) {
            this.kernel.add(x);
            return true;
        }
        return false;
    }

    boolean _instantiate(int[] values, SConstraint cause) throws ContradictionException {
        int i;
        if (this.isInstantiated()) {
            if (!this.isInstantiatedTo(values)) {
                this.propagationEngine.raiseContradiction(cause);
                return true;
            }
            return false;
        }
        if (!this.canBeInstantiatedTo(values)) {
            this.propagationEngine.raiseContradiction(cause);
            return true;
        }
        for (i = 0; i < values.length; ++i) {
            this.kernel.add(values[i]);
        }
        i = this.enveloppe.getFirstVal();
        while (i >= 0) {
            if (!this.kernel.contains(i)) {
                this.enveloppe.remove(i);
            }
            i = this.enveloppe.getNextValue(i);
        }
        return true;
    }

    @Override
    public DisposableIntIterator getKernelIterator() {
        if (this._kiterator == null) {
            this._kiterator = new SetDomainIterator();
        } else if (!this._kiterator.reusable()) {
            this._kiterator = new SetDomainIterator();
        }
        this._kiterator.init(this.kernel);
        return this._kiterator;
    }

    @Override
    public DisposableIntIterator getEnveloppeIterator() {
        if (this._eiterator == null) {
            this._eiterator = new SetDomainIterator();
        } else if (!this._eiterator.reusable()) {
            this._eiterator = new SetDomainIterator();
        }
        this._eiterator.init(this.enveloppe);
        return this._eiterator;
    }

    @Override
    public DisposableIntIterator getOpenDomainIterator() {
        if (this._oiterator == null) {
            this._oiterator = new SetOpenDomainIterator();
        } else if (!this._oiterator.reusable()) {
            this._oiterator = new SetOpenDomainIterator();
        }
        this._oiterator.init(this.enveloppe, this.kernel);
        return this._oiterator;
    }

    protected static final class SetOpenDomainIterator
    extends DisposableIntIterator {
        private BitSetEnumeratedDomain envdomain;
        private BitSetEnumeratedDomain kerdomain;
        private int currentValue = Integer.MIN_VALUE;
        private int nbValueToBeIterated = Integer.MAX_VALUE;

        private SetOpenDomainIterator() {
        }

        public void init(BitSetEnumeratedDomain dom1, BitSetEnumeratedDomain dom2) {
            super.init();
            this.envdomain = dom1;
            this.kerdomain = dom2;
            this.currentValue = Integer.MIN_VALUE;
            this.nbValueToBeIterated = dom1.getSize() - dom2.getSize();
        }

        @Override
        public boolean hasNext() {
            return this.nbValueToBeIterated > 0;
        }

        @Override
        public int next() {
            int i;
            int n = i = this.currentValue == Integer.MIN_VALUE ? this.envdomain.getFirstVal() : this.envdomain.getNextValue(this.currentValue);
            while (i >= 0) {
                if (!this.kerdomain.contains(i)) {
                    this.currentValue = i;
                    break;
                }
                i = this.envdomain.getNextValue(i);
            }
            --this.nbValueToBeIterated;
            return this.currentValue;
        }

        @Override
        public void remove() {
            if (this.currentValue == Integer.MIN_VALUE) {
                throw new IllegalStateException();
            }
            throw new UnsupportedOperationException();
        }
    }
}

