/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.integer;

import choco.cp.solver.variables.integer.AbstractBijectiveVar;
import choco.kernel.common.util.tools.MathUtils;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class IntDomainVarTimePosCste
extends AbstractBijectiveVar {
    final int constante;

    public IntDomainVarTimePosCste(Solver solver, String name, IntDomainVar variable, int constante) {
        super(solver, name, variable);
        if (constante < 0) {
            throw new SolverException("IntDomainVarTimePosCste: constante should be positive (" + constante + ")");
        }
        this.constante = constante;
    }

    @Override
    public void remVal(int x) throws ContradictionException {
        if (x % 0 != 0) {
            this.variable.remVal(x / this.constante);
        }
    }

    @Override
    public void setInf(int x) throws ContradictionException {
        this.variable.setInf(MathUtils.divCeil(x, this.constante));
    }

    @Override
    @Deprecated
    public void setMin(int x) throws ContradictionException {
        this.variable.setInf(x);
    }

    @Override
    public void setSup(int x) throws ContradictionException {
        this.variable.setSup(MathUtils.divFloor(x, this.constante));
    }

    @Override
    @Deprecated
    public void setMax(int x) throws ContradictionException {
        this.variable.setSup(x);
    }

    @Override
    public boolean canBeInstantiatedTo(int x) {
        return this.variable.canBeInstantiatedTo(x / this.constante);
    }

    @Override
    public boolean fastCanBeInstantiatedTo(int x) {
        return this.variable.fastCanBeInstantiatedTo(x / this.constante);
    }

    @Override
    public int getRandomDomainValue() {
        return this.variable.getRandomDomainValue() * this.constante;
    }

    @Override
    public int getNextDomainValue(int i) {
        return this.variable.getNextDomainValue(i / this.constante);
    }

    @Override
    public int getPrevDomainValue(int i) {
        return this.variable.getPrevDomainValue(i / this.constante);
    }

    @Override
    public int getInf() {
        return this.variable.getInf() * this.constante;
    }

    @Override
    public int getSup() {
        return this.variable.getSup() * this.constante;
    }

    @Override
    public int getValue() {
        return this.variable.getValue() * this.constante;
    }

    @Override
    public boolean updateInf(int x, SConstraint cause, boolean forceAwake) throws ContradictionException {
        return this.variable.updateInf(MathUtils.divCeil(x, this.constante), cause, forceAwake);
    }

    @Override
    public boolean updateInf(int x, int idx) throws ContradictionException {
        return this.variable.updateInf(MathUtils.divCeil(x, this.constante), idx);
    }

    @Override
    public boolean updateSup(int x, SConstraint cause, boolean forceAwake) throws ContradictionException {
        return this.variable.updateSup(MathUtils.divFloor(x, this.constante), cause, forceAwake);
    }

    @Override
    public boolean updateSup(int x, int idx) throws ContradictionException {
        return this.variable.updateSup(MathUtils.divFloor(x, this.constante), idx);
    }

    @Override
    public boolean removeVal(int x, SConstraint cause, boolean forceAwake) throws ContradictionException {
        return x % this.constante == 0 && this.variable.removeVal(x / this.constante, cause, forceAwake);
    }

    @Override
    public boolean removeVal(int x, int idx) throws ContradictionException {
        return x % this.constante == 0 && this.variable.removeVal(x / this.constante, idx);
    }

    @Override
    public boolean removeInterval(int a, int b, SConstraint cause, boolean forceAwake) throws ContradictionException {
        return this.variable.removeInterval(MathUtils.divCeil(a, this.constante), MathUtils.divFloor(b, this.constante), cause, forceAwake);
    }

    @Override
    public boolean removeInterval(int a, int b, int idx) throws ContradictionException {
        return this.variable.removeInterval(MathUtils.divCeil(a, this.constante), MathUtils.divFloor(b, this.constante), idx);
    }

    @Override
    public boolean instantiate(int x, SConstraint cause, boolean forceAwake) throws ContradictionException {
        return x % this.constante == 0 && this.variable.instantiate(x / this.constante, cause, forceAwake);
    }

    @Override
    public boolean instantiate(int x, int idx) throws ContradictionException {
        return x % this.constante == 0 && this.variable.instantiate(x / this.constante, idx);
    }

    @Override
    public void setVal(int x) throws ContradictionException {
        if (x % this.constante == 0) {
            this.variable.setVal(x / this.constante);
        }
    }

    @Override
    public int getVal() {
        return this.variable.getVal() * this.constante;
    }

    @Override
    public boolean isInstantiatedTo(int x) {
        return this.variable.isInstantiatedTo(x * this.constante);
    }

    @Override
    public String pretty() {
        return String.format("(%s * %d)", this.variable.getName(), this.constante);
    }
}

