/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.reified.leaves.arithm;

import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.constraints.reified.ArithmNode;
import choco.kernel.solver.constraints.reified.INode;
import choco.kernel.solver.constraints.reified.NodeType;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.Arrays;

public final class ScalarNode
extends INode
implements ArithmNode {
    protected int[] coeffs;

    public ScalarNode(INode[] subt) {
        super(subt, NodeType.SCALAR);
        this.coeffs = new int[subt.length];
        Arrays.fill(this.coeffs, 1);
    }

    public ScalarNode(INode[] subt, int[] coeffs) {
        super(subt, NodeType.SCALAR);
        this.coeffs = coeffs;
        assert (subt.length == coeffs.length);
    }

    @Override
    public int eval(int[] tuple) {
        int sum = 0;
        int i = 0;
        for (INode t : this.subtrees) {
            sum += this.coeffs[i++] * ((ArithmNode)((Object)t)).eval(tuple);
        }
        return sum;
    }

    @Override
    public IntDomainVar extractResult(Solver s) {
        IntDomainVar[] vars = new IntDomainVar[this.subtrees.length];
        int lb = 0;
        int ub = 0;
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = this.subtrees[i].extractResult(s);
            lb += this.coeffs[i] >= 0 ? vars[i].getInf() * this.coeffs[i] : vars[i].getSup() * this.coeffs[i];
            ub += this.coeffs[i] >= 0 ? vars[i].getSup() * this.coeffs[i] : vars[i].getInf() * this.coeffs[i];
        }
        IntDomainVar sum = s.createBoundIntVar(StringUtils.randomName(), lb, ub);
        s.post(s.eq((IntExp)sum, s.scalar(this.coeffs, vars)));
        return sum;
    }

    @Override
    public String pretty() {
        StringBuffer st = new StringBuffer("(");
        int i = 0;
        for (INode t : this.subtrees) {
            st.append(t.pretty());
            if (++i >= this.subtrees.length) continue;
            st.append("+");
        }
        st.append(")");
        return st.toString();
    }

    @Override
    public boolean isALinearTerm() {
        for (INode subtree : this.subtrees) {
            if (subtree.isALinearTerm()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int[] computeLinearExpr(int scope) {
        int[] cToRet = new int[scope + 1];
        for (int i = 0; i < this.coeffs.length; ++i) {
            int[] c = this.subtrees[i].computeLinearExpr(scope);
            for (int j = 0; j < c.length; ++j) {
                int n = j;
                cToRet[n] = cToRet[n] + this.coeffs[i] * c[j];
            }
        }
        return cToRet;
    }
}

