/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.deduction;

import choco.cp.solver.constraints.global.tree.deduction.IncompGraphDeduction;
import choco.cp.solver.constraints.global.tree.deduction.OrderedGraphDeduction;
import choco.cp.solver.constraints.global.tree.structure.inputStructure.TreeParameters;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.StructuresAdvisor;
import choco.kernel.solver.Solver;

public class DeductionsAdvisor {
    protected boolean affiche;
    protected boolean update;
    protected boolean compatible;
    protected Solver solver;
    protected TreeParameters tree;
    protected StructuresAdvisor struct;
    protected OrderedGraphDeduction precs;
    protected IncompGraphDeduction incomp;

    public DeductionsAdvisor(Solver solver, TreeParameters tree, StructuresAdvisor struct, boolean affiche) {
        this.solver = solver;
        this.tree = tree;
        this.struct = struct;
        this.affiche = affiche;
        this.update = false;
        this.compatible = true;
        Object[] params = new Object[]{this.solver, this.tree, this.struct, this.update, this.compatible, this.affiche};
        this.precs = new OrderedGraphDeduction(params);
        this.incomp = new IncompGraphDeduction(params);
    }

    public boolean applyDeduction() {
        boolean update;
        do {
            this.struct.getDoms().updateDominators();
            this.precs.updateOrderedGraphWithDeductions();
            this.incomp.updateIncompGraphWithDeductions();
            this.compatible = this.precs.isCompatible() && this.incomp.isCompatible();
            boolean bl = update = this.precs.isUpdate() || this.incomp.isUpdate() || this.struct.getDoms().isUpdate();
        } while (update && this.compatible);
        return update;
    }

    public boolean isCompatible() {
        return this.compatible;
    }
}

