/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling.trees.status;

import choco.cp.solver.constraints.global.scheduling.trees.IVilimTree;
import choco.cp.solver.constraints.global.scheduling.trees.status.ThetaStatus;

public class ThetaLambdaStatus
extends ThetaStatus {
    protected int grayTime;
    protected int grayDuration;
    protected Object respGrayTime;
    protected Object respGrayDuration;

    public final int getGrayTime() {
        return this.grayTime;
    }

    public final void setGrayTime(int grayTime) {
        this.grayTime = grayTime;
    }

    public final int getGrayDuration() {
        return this.grayDuration;
    }

    public final void setGrayDuration(int grayDuration) {
        this.grayDuration = grayDuration;
    }

    public final Object getRespGrayTime() {
        return this.respGrayTime;
    }

    public final Object getRespGrayDuration() {
        return this.respGrayDuration;
    }

    public final void setRespGrayTime(Object respGrayTime) {
        this.respGrayTime = respGrayTime;
    }

    public final void setRespGrayDuration(Object respGrayDuration) {
        this.respGrayDuration = respGrayDuration;
    }

    protected void updateGrayDuration(ThetaLambdaStatus left, ThetaLambdaStatus right) {
        int r;
        int l = left.getGrayDuration() + right.getDuration();
        if (l >= (r = left.getDuration() + right.getGrayDuration())) {
            this.setRespGrayDuration(left.getRespGrayDuration());
            this.setGrayDuration(l);
        } else {
            this.setRespGrayDuration(right.getRespGrayDuration());
            this.setGrayDuration(r);
        }
    }

    public void updateGrayECT(ThetaLambdaStatus left, ThetaLambdaStatus right) {
        int l = right.getGrayTime();
        int m = left.getTime() + right.getGrayDuration();
        int r = left.getGrayTime() + right.getDuration();
        if (l >= m && l >= r) {
            this.setRespGrayTime(right.getRespGrayTime());
            this.setGrayTime(l);
        } else if (m >= r) {
            this.setRespGrayTime(right.getRespGrayDuration());
            this.setGrayTime(m);
        } else {
            this.setRespGrayTime(left.getRespGrayTime());
            this.setGrayTime(r);
        }
    }

    public void updateGrayLST(ThetaLambdaStatus left, ThetaLambdaStatus right) {
        int l = left.getGrayTime();
        int m = right.getTime() - left.getGrayDuration();
        int r = right.getGrayTime() - left.getDuration();
        if (l <= m && l <= r) {
            this.setRespGrayTime(left.getRespGrayTime());
            this.setGrayTime(l);
        } else if (m <= r) {
            this.setRespGrayTime(left.getRespGrayDuration());
            this.setGrayTime(m);
        } else {
            this.setRespGrayTime(right.getRespGrayTime());
            this.setGrayTime(r);
        }
    }

    public void update(IVilimTree.TreeMode mode, ThetaLambdaStatus left, ThetaLambdaStatus right) {
        super.update(mode, left, right);
        switch (mode) {
            case ECT: {
                this.updateGrayECT(left, right);
                this.updateGrayDuration(left, right);
                break;
            }
            case LST: {
                this.updateGrayLST(left, right);
                this.updateGrayDuration(left, right);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unknown tree mode.");
            }
        }
    }
}

