/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling.trees;

import choco.cp.solver.constraints.global.scheduling.trees.AbstractThetaTree;
import choco.cp.solver.constraints.global.scheduling.trees.AbstractVilimStatus;
import choco.cp.solver.constraints.global.scheduling.trees.AbstractVilimTree;
import choco.cp.solver.constraints.global.scheduling.trees.IThetaLambdaTree;
import choco.cp.solver.constraints.global.scheduling.trees.IThetaOmegaTree;
import choco.cp.solver.constraints.global.scheduling.trees.IVilimTree;
import choco.cp.solver.constraints.global.scheduling.trees.ThetaTreeLeaf;
import choco.cp.solver.constraints.global.scheduling.trees.status.ThetaOmegaStatus;
import choco.kernel.common.opres.graph.IBinaryNode;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.variables.scheduling.IRTask;
import choco.kernel.solver.variables.scheduling.ITask;
import java.util.List;

public class AltDisjTreeTLTO
extends AbstractThetaTree
implements IThetaLambdaTree,
IThetaOmegaTree {
    private int nbOmegaTasks = 0;

    public AltDisjTreeTLTO(List<? extends ITask> tasks) {
        super(tasks);
    }

    @Override
    public void insert(ITask task) {
        this.insertTask(task, new AltDisjStatusTLTO(AbstractVilimTree.NodeType.NIL), new AltDisjStatusTLTO(AbstractVilimTree.NodeType.INTERNAL));
    }

    public int getTaskType(IRTask rtask) {
        IBinaryNode leaf = this.getLeaf(rtask.getHTask());
        AltDisjStatusTLTO status = (AltDisjStatusTLTO)leaf.getNodeStatus();
        switch (status.getType()) {
            case THETA: {
                return 1;
            }
            case OMEGA: {
                return 2;
            }
            case LAMBDA: {
                return 3;
            }
            case NIL: {
                return 4;
            }
        }
        throw new SolverException("Leaf node has an invalid node type");
    }

    public void initializeEdgeFinding(IVilimTree.TreeMode mode, Iterable<IRTask> rtasks) {
        this.setMode(mode);
        this.nbOmegaTasks = 0;
        for (IRTask rtask : rtasks) {
            AltDisjStatusTLTO status;
            IBinaryNode leaf;
            if (rtask.isRegular()) {
                leaf = this.getLeaf(rtask.getHTask());
                status = (AltDisjStatusTLTO)leaf.getNodeStatus();
                if (status.getType() == AbstractVilimTree.NodeType.NIL) {
                    status.insertInTheta();
                    continue;
                }
                throw new SolverException("can't initialize Theta Node in Alternative Edge Finding TLTO Tree");
            }
            if (!rtask.isOptional()) continue;
            leaf = this.getLeaf(rtask.getHTask());
            status = (AltDisjStatusTLTO)leaf.getNodeStatus();
            if (status.getType() == AbstractVilimTree.NodeType.NIL) {
                status.insertInOmega(rtask);
                ++this.nbOmegaTasks;
                continue;
            }
            throw new SolverException("can't initialize Omega Node in Alternative Edge Finding TLTO Tree");
        }
        this.fireTreeChanged();
    }

    protected ThetaOmegaStatus getRootStatus() {
        return (ThetaOmegaStatus)this.getNodeStatus(this.getRoot()).getStatus();
    }

    protected final AltDisjStatusTLTO getNodeStatus(IBinaryNode node) {
        return (AltDisjStatusTLTO)node.getNodeStatus();
    }

    @Override
    public int getTime() {
        return this.getRootStatus().getTime();
    }

    @Override
    public int getGrayTime() {
        return this.getRootStatus().getGrayTime();
    }

    @Override
    public Object getResponsibleTask() {
        return this.getRootStatus().getRespGrayTime();
    }

    @Override
    public int getTOTime() {
        return this.getRootStatus().getTOTime();
    }

    @Override
    public Object getResponsibleTOTask() {
        return this.getRootStatus().getRespTOTime();
    }

    @Override
    public boolean insertInLambda(IRTask rtask) {
        IBinaryNode leaf = this.getLeaf(rtask.getHTask());
        AltDisjStatusTLTO status = this.getNodeStatus(leaf);
        if (status.getType() == AbstractVilimTree.NodeType.NIL) {
            status.insertInLambda(rtask);
            leaf.fireStatusChanged();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeFromLambda(ITask task) {
        IBinaryNode leaf = this.getLeaf(task);
        AltDisjStatusTLTO status = this.getNodeStatus(leaf);
        if (status.getType() == AbstractVilimTree.NodeType.LAMBDA) {
            status.removeFromLambda();
            leaf.fireStatusChanged();
            return true;
        }
        return false;
    }

    private boolean removeFromThetaAndInsertInLambda(ITask task, Object resp) {
        IBinaryNode leaf = this.getLeaf(task);
        AltDisjStatusTLTO status = this.getNodeStatus(leaf);
        if (status.getType() == AbstractVilimTree.NodeType.THETA) {
            status.insertInLambda(resp);
            leaf.fireStatusChanged();
            return true;
        }
        return false;
    }

    private boolean removeFromOmegaAndInsertInLambda(IRTask task, Object resp) {
        IBinaryNode leaf = this.getLeaf(task.getHTask());
        AltDisjStatusTLTO status = this.getNodeStatus(leaf);
        if (status.getType() == AbstractVilimTree.NodeType.OMEGA) {
            status.removeFromOmega();
            --this.nbOmegaTasks;
            status.insertInLambda(resp);
            leaf.fireStatusChanged();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeFromThetaAndInsertInLambda(ITask task) {
        return this.removeFromThetaAndInsertInLambda(task, task);
    }

    @Override
    public boolean removeFromThetaAndInsertInLambda(IRTask task) {
        return this.removeFromThetaAndInsertInLambda(task.getHTask(), task);
    }

    @Override
    public boolean insertInOmega(IRTask rtask) {
        IBinaryNode leaf = this.getLeaf(rtask.getHTask());
        AltDisjStatusTLTO status = this.getNodeStatus(leaf);
        if (status.getType() == AbstractVilimTree.NodeType.NIL) {
            status.insertInOmega(rtask);
            ++this.nbOmegaTasks;
            leaf.fireStatusChanged();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeFromOmega(IRTask task) {
        IBinaryNode leaf = this.getLeaf(task.getHTask());
        AltDisjStatusTLTO status = this.getNodeStatus(leaf);
        if (status.getType() == AbstractVilimTree.NodeType.OMEGA) {
            status.removeFromOmega();
            --this.nbOmegaTasks;
            leaf.fireStatusChanged();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeFromOmegaAndInsertInLambda(IRTask task) {
        return this.removeFromOmegaAndInsertInLambda(task, task);
    }

    public int getNbOmegaTasks() {
        return this.nbOmegaTasks;
    }

    protected class AltDisjStatusTLTO
    extends AbstractVilimStatus<ThetaOmegaStatus>
    implements ThetaTreeLeaf {
        public AltDisjStatusTLTO(AbstractVilimTree.NodeType type) {
            super(type, new ThetaOmegaStatus());
        }

        protected final int getLeafTime() {
            return AltDisjTreeTLTO.this.getMode().value() ? this.task.getEST() + this.task.getMinDuration() : this.task.getLCT() - this.task.getMinDuration();
        }

        @Override
        public void reset() {
            this.removeFromTheta();
            ((ThetaOmegaStatus)this.status).setRespGrayTime(null);
            ((ThetaOmegaStatus)this.status).setRespGrayDuration(null);
            ((ThetaOmegaStatus)this.status).setRespTOTime(null);
            ((ThetaOmegaStatus)this.status).setRespTODuration(null);
        }

        @Override
        protected void writeDotStatus(StringBuilder buffer) {
            this.writeRow(buffer, AltDisjTreeTLTO.this.getMode().label(), this.format(((ThetaOmegaStatus)this.status).getTime()), "P", String.valueOf(((ThetaOmegaStatus)this.status).getDuration()));
            buffer.append('|');
            this.writeRow(buffer, "Gr" + AltDisjTreeTLTO.this.getMode().label(), this.format(((ThetaOmegaStatus)this.status).getGrayTime()), "GrP", String.valueOf(((ThetaOmegaStatus)this.status).getGrayDuration()));
            buffer.append('|');
            this.writeRow(buffer, "Om" + AltDisjTreeTLTO.this.getMode().label(), this.format(((ThetaOmegaStatus)this.status).getTOTime()), "OmP", String.valueOf(((ThetaOmegaStatus)this.status).getTODuration()));
            if (this.getType() == AbstractVilimTree.NodeType.INTERNAL) {
                buffer.append('|');
                String t1 = ((ThetaOmegaStatus)this.status).getRespGrayTime() == null ? "?" : ((ThetaOmegaStatus)this.status).getRespGrayTime().toString();
                String t2 = ((ThetaOmegaStatus)this.status).getRespGrayDuration() == null ? "?" : ((ThetaOmegaStatus)this.status).getRespGrayDuration().toString();
                this.writeRow(buffer, "Gr" + AltDisjTreeTLTO.this.getMode().label(), t1, "GrP", t2);
                buffer.append('|');
                String o1 = ((ThetaOmegaStatus)this.status).getRespTOTime() == null ? "?" : ((ThetaOmegaStatus)this.status).getRespTOTime().toString();
                String o2 = ((ThetaOmegaStatus)this.status).getRespTODuration() == null ? "?" : ((ThetaOmegaStatus)this.status).getRespTODuration().toString();
                this.writeRow(buffer, "Om" + AltDisjTreeTLTO.this.getMode().label(), o1, "OmP", o2);
            }
        }

        @Override
        public void insertInTheta() {
            this.setType(AbstractVilimTree.NodeType.THETA);
            ((ThetaOmegaStatus)this.status).setTime(this.getLeafTime());
            ((ThetaOmegaStatus)this.status).setDuration(this.task.getMinDuration());
            ((ThetaOmegaStatus)this.status).setGrayTime(((ThetaOmegaStatus)this.getStatus()).getTime());
            ((ThetaOmegaStatus)this.status).setGrayDuration(((ThetaOmegaStatus)this.getStatus()).getDuration());
            ((ThetaOmegaStatus)this.status).setTOTime(((ThetaOmegaStatus)this.getStatus()).getTime());
            ((ThetaOmegaStatus)this.status).setTODuration(((ThetaOmegaStatus)this.getStatus()).getDuration());
        }

        @Override
        public void insertInTheta(IRTask rtask) {
            this.insertInTheta();
        }

        public void insertInOmega(Object resp) {
            this.setType(AbstractVilimTree.NodeType.OMEGA);
            ((ThetaOmegaStatus)this.status).setTime(this.getResetIntValue(AltDisjTreeTLTO.this.getMode()));
            ((ThetaOmegaStatus)this.status).setDuration(0);
            ((ThetaOmegaStatus)this.status).setTOTime(this.getLeafTime());
            ((ThetaOmegaStatus)this.status).setTODuration(this.task.getMinDuration());
            ((ThetaOmegaStatus)this.status).setRespTOTime(resp);
            ((ThetaOmegaStatus)this.status).setRespTODuration(resp);
            ((ThetaOmegaStatus)this.status).setGrayTime(this.getResetIntValue(AltDisjTreeTLTO.this.getMode()));
            ((ThetaOmegaStatus)this.status).setDuration(0);
        }

        public void removeFromOmega() {
            this.setType(AbstractVilimTree.NodeType.NIL);
            ((ThetaOmegaStatus)this.status).setTOTime(this.getResetIntValue(AltDisjTreeTLTO.this.getMode()));
            ((ThetaOmegaStatus)this.status).setTODuration(0);
            ((ThetaOmegaStatus)this.status).setRespTOTime(null);
            ((ThetaOmegaStatus)this.status).setRespTODuration(null);
        }

        public void insertInLambda(Object resp) {
            this.setType(AbstractVilimTree.NodeType.LAMBDA);
            ((ThetaOmegaStatus)this.status).setTime(this.getResetIntValue(AltDisjTreeTLTO.this.getMode()));
            ((ThetaOmegaStatus)this.status).setDuration(0);
            ((ThetaOmegaStatus)this.status).setGrayTime(this.getLeafTime());
            ((ThetaOmegaStatus)this.status).setGrayDuration(this.task.getMinDuration());
            ((ThetaOmegaStatus)this.status).setRespGrayTime(resp);
            ((ThetaOmegaStatus)this.status).setRespGrayDuration(resp);
            ((ThetaOmegaStatus)this.status).setTOTime(this.getResetIntValue(AltDisjTreeTLTO.this.getMode()));
            ((ThetaOmegaStatus)this.status).setTODuration(0);
        }

        public void removeFromLambda() {
            this.setType(AbstractVilimTree.NodeType.NIL);
            ((ThetaOmegaStatus)this.status).setGrayTime(this.getResetIntValue(AltDisjTreeTLTO.this.getMode()));
            ((ThetaOmegaStatus)this.status).setGrayDuration(0);
            ((ThetaOmegaStatus)this.status).setRespGrayTime(null);
            ((ThetaOmegaStatus)this.status).setRespGrayDuration(null);
        }

        @Override
        public void removeFromTheta() {
            this.setType(AbstractVilimTree.NodeType.NIL);
            ((ThetaOmegaStatus)this.status).setTime(this.getResetIntValue(AltDisjTreeTLTO.this.getMode()));
            ((ThetaOmegaStatus)this.status).setDuration(0);
            ((ThetaOmegaStatus)this.status).setGrayTime(this.getResetIntValue(AltDisjTreeTLTO.this.getMode()));
            ((ThetaOmegaStatus)this.status).setGrayDuration(0);
            ((ThetaOmegaStatus)this.status).setTOTime(this.getResetIntValue(AltDisjTreeTLTO.this.getMode()));
            ((ThetaOmegaStatus)this.status).setTODuration(0);
        }

        @Override
        public void updateInternalNode(IBinaryNode node) {
            if (node.getLeftChild().getNodeStatus() instanceof AltDisjStatusTLTO) {
                ThetaOmegaStatus left = (ThetaOmegaStatus)((AltDisjStatusTLTO)node.getLeftChild().getNodeStatus()).getStatus();
                if (node.getRightChild().getNodeStatus() instanceof AltDisjStatusTLTO) {
                    ThetaOmegaStatus right = (ThetaOmegaStatus)((AltDisjStatusTLTO)node.getRightChild().getNodeStatus()).getStatus();
                    ((ThetaOmegaStatus)this.status).update(AltDisjTreeTLTO.this.getMode(), left, right);
                    return;
                }
            }
            throw new SolverException("cant update node");
        }
    }
}

