/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost.layers;

import choco.cp.solver.constraints.global.Geost_Constraint;
import choco.cp.solver.constraints.global.geost.Constants;
import choco.cp.solver.constraints.global.geost.Setup;
import choco.cp.solver.constraints.global.geost.externalConstraints.DistGeq;
import choco.cp.solver.constraints.global.geost.externalConstraints.DistLeq;
import choco.cp.solver.constraints.global.geost.externalConstraints.DistLinear;
import choco.cp.solver.constraints.global.geost.externalConstraints.ExternalConstraint;
import choco.cp.solver.constraints.global.geost.externalConstraints.NonOverlapping;
import choco.cp.solver.constraints.global.geost.frames.ForbiddenRegionFrame;
import choco.cp.solver.constraints.global.geost.geometricPrim.Obj;
import choco.cp.solver.constraints.global.geost.geometricPrim.Point;
import choco.cp.solver.constraints.global.geost.geometricPrim.Region;
import choco.cp.solver.constraints.global.geost.internalConstraints.DistGeqIC;
import choco.cp.solver.constraints.global.geost.internalConstraints.DistLeqIC;
import choco.cp.solver.constraints.global.geost.internalConstraints.DistLinearIC;
import choco.cp.solver.constraints.global.geost.internalConstraints.ForbiddenRegion;
import choco.cp.solver.constraints.global.geost.internalConstraints.InternalConstraint;
import choco.cp.solver.constraints.global.geost.internalConstraints.Outbox;
import choco.cp.solver.constraints.global.geost.layers.ExternalLayer;
import choco.cp.solver.constraints.global.geost.layers.GeostNumeric;
import choco.cp.solver.constraints.global.geost.layers.IntermediateLayer;
import choco.cp.solver.constraints.global.geost.layers.MemoStore;
import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.memory.IStateInt;
import choco.kernel.model.constraints.geost.GeostOptions;
import choco.kernel.model.variables.geost.ShiftedBox;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.variables.integer.IntDomainVar;
import com.sun.tools.javac.util.Pair;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public final class GeometricKernel {
    private static final Logger LOGGER = ChocoLogging.getEngineLogger();
    private static final int ONE_MILLION = 1000000;
    private final Constants cst;
    private final Setup stp;
    private final ExternalLayer externalLayer;
    private final IntermediateLayer intermediateLayer;
    private final MemoStore memo;
    private final Map<Pair<Integer, Integer>, Boolean> included;
    private int get_fr_ptr_a = 0;
    private int get_fr_ptr_b = 0;
    private IntDomainVar[] E = null;
    private IntDomainVar[] D = null;
    private GeostNumeric engine = null;
    private final Solver solver;
    private final Geost_Constraint constraint;

    public GeometricKernel(Constants c, Setup s, ExternalLayer extrL, IntermediateLayer intermL, boolean memo_, Map<Pair<Integer, Integer>, Boolean> included_, Solver aSolver, Geost_Constraint aConstraint) {
        this.cst = c;
        this.stp = s;
        this.externalLayer = extrL;
        this.intermediateLayer = intermL;
        this.memo = new MemoStore();
        this.memo.p = 1;
        this.memo.active = memo_;
        this.memo.listObj = new ArrayList<List<Obj>>(0);
        this.memo.m = new HashMap<int[], Integer>(16);
        this.included = included_;
        this.solver = aSolver;
        this.constraint = aConstraint;
        LOGGER.info("memo_active=" + memo_);
    }

    List getFR(int d, int k, Obj o, Point c, Point jump, List<InternalConstraint> ACTRS, boolean increase) {
        GeostOptions cfr_ignored_0 = this.stp.opt;
        ++GeostOptions.GetFRCalled;
        ArrayList<Serializable> result = new ArrayList<Serializable>(2);
        if (increase) {
            for (int rr = this.get_fr_ptr_a; rr < ACTRS.size() + this.get_fr_ptr_a; ++rr) {
                int i = rr % ACTRS.size();
                long tmpTime = System.nanoTime() / 1000000L;
                List v = this.intermediateLayer.isFeasible(ACTRS.get(i), true, d, k, o, c, jump);
                GeostOptions cfr_ignored_1 = this.stp.opt;
                GeostOptions.timeIsFeasible += System.nanoTime() / 1000000L - tmpTime;
                if (((Boolean)v.get(0)).booleanValue()) continue;
                this.get_fr_ptr_a = i;
                result.clear();
                result.add(0, Boolean.valueOf(true));
                result.add(1, (Serializable)v.get(1));
                return result;
            }
            this.get_fr_ptr_a = 0;
            result.clear();
            result.add(0, Boolean.valueOf(false));
            result.add(1, new Region(this.cst.getDIM(), -1));
            return result;
        }
        for (int rr = this.get_fr_ptr_b; rr < ACTRS.size() + this.get_fr_ptr_b; ++rr) {
            int i = rr % ACTRS.size();
            long tmpTime = System.nanoTime() / 1000000L;
            List v = this.intermediateLayer.isFeasible(ACTRS.get(i), false, d, k, o, c, jump);
            GeostOptions cfr_ignored_2 = this.stp.opt;
            GeostOptions.timeIsFeasible += System.nanoTime() / 1000000L - tmpTime;
            if (((Boolean)v.get(0)).booleanValue()) continue;
            this.get_fr_ptr_b = i;
            result.clear();
            result.add(0, Boolean.valueOf(true));
            result.add(1, (Serializable)v.get(1));
            return result;
        }
        this.get_fr_ptr_b = 0;
        result.clear();
        result.add(0, Boolean.valueOf(false));
        result.add(1, new Region(this.cst.getDIM(), -1));
        return result;
    }

    public boolean filterCtrs(int k, int[] oIDs, List<ExternalConstraint> ectrs) throws ContradictionException {
        ForbiddenRegion ic;
        this.stp.opt.propag_failed = true;
        GeostOptions cfr_ignored_0 = this.stp.opt;
        if (GeostOptions.serial != null) {
            try {
                GeostOptions cfr_ignored_1 = this.stp.opt;
                GeostOptions.serial.writeObject(Arrays.asList(new int[][]{oIDs}));
            }
            catch (Exception e) {
                throw new SolverException("Prune:unable to serialize parameters");
            }
        }
        GeostOptions cfr_ignored_2 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("FilterCtrs:");
        }
        boolean nonFix = true;
        for (ExternalConstraint ectr : ectrs) {
            ForbiddenRegionFrame f;
            if (ectr instanceof DistLeq) {
                DistLeq dl = (DistLeq)ectr;
                f = (ForbiddenRegionFrame)this.externalLayer.InitFrameExternalConstraint(ectr, oIDs);
                ic = new DistLeqIC(this.stp, f.q, f.D, f.s1, f.s2, f.o1, f.o2, dl.getDistanceVar());
                nonFix &= ((DistLeqIC)ic).updateDistance(k);
            }
            if (!(ectr instanceof DistGeq)) continue;
            DistGeq dg = (DistGeq)ectr;
            f = (ForbiddenRegionFrame)this.externalLayer.InitFrameExternalConstraint(ectr, oIDs);
            ic = new DistGeqIC(this.stp, f.q, f.D, f.s1, f.s2, f.o1, f.o2, dg.getDistanceVar());
            nonFix &= ((DistGeqIC)ic).updateDistance(k);
        }
        while (nonFix) {
            int i;
            nonFix = false;
            for (ExternalConstraint ectr : ectrs) {
                ForbiddenRegionFrame f;
                if (ectr instanceof DistLeq) {
                    DistLeq dl = (DistLeq)ectr;
                    f = (ForbiddenRegionFrame)this.externalLayer.InitFrameExternalConstraint(ectr, oIDs);
                    ic = new DistLeqIC(this.stp, f.q, f.D, f.s1, f.s2, f.o1, f.o2, dl.getDistanceVar());
                    boolean bl = nonFix = nonFix || ((DistLeqIC)ic).updateDistance(k);
                }
                if (!(ectr instanceof DistGeq)) continue;
                DistGeq dg = (DistGeq)ectr;
                f = (ForbiddenRegionFrame)this.externalLayer.InitFrameExternalConstraint(ectr, oIDs);
                ic = new DistGeqIC(this.stp, f.q, f.D, f.s1, f.s2, f.o1, f.o2, dg.getDistanceVar());
                nonFix = nonFix || ((DistGeqIC)ic).updateDistance(k);
            }
            for (i = 0; i < ectrs.size(); ++i) {
                ectrs.get(i).setFrame(this.externalLayer.InitFrameExternalConstraint(ectrs.get(i), oIDs));
            }
            for (i = 0; i < oIDs.length; ++i) {
                Obj o = this.stp.getObject(oIDs[i]);
                GeostOptions cfr_ignored_3 = this.stp.opt;
                if (GeostOptions.debug) {
                    LOGGER.info(String.format("Considering object %d %s --> ", oIDs[i], o));
                }
                int domainsSize = o.calculateDomainSize();
                if (!this.filterObjWP(k, oIDs[i])) {
                    GeostOptions cfr_ignored_4 = this.stp.opt;
                    if (GeostOptions.debug) {
                        LOGGER.info("Returning false;");
                    }
                    return false;
                }
                if (domainsSize != o.calculateDomainSize()) {
                    for (int j = 0; j < o.getRelatedExternalConstraints().size(); ++j) {
                        if (o.getRelatedExternalConstraints().get(j) instanceof DistLeq || o.getRelatedExternalConstraints().get(j) instanceof DistGeq || o.getRelatedExternalConstraints().get(j) instanceof DistLinear) continue;
                        o.getRelatedExternalConstraints().get(j).getFrame().getRelForbidRegions().remove(o.getObjectId());
                        int[] oIDi = new int[]{oIDs[i]};
                        o.getRelatedExternalConstraints().get(j).getFrame().getRelForbidRegions().put(o.getObjectId(), this.externalLayer.InitFrameExternalConstraint(o.getRelatedExternalConstraints().get(j), oIDi).getRelForbidRegions(oIDs[i]));
                    }
                    nonFix = true;
                }
                GeostOptions cfr_ignored_5 = this.stp.opt;
                if (!GeostOptions.debug) continue;
                LOGGER.info(String.format("***Result of FilterCstrs:%s", o));
            }
            for (ExternalConstraint ectr : ectrs) {
                ForbiddenRegionFrame f;
                if (ectr instanceof DistLeq) {
                    DistLeq dl = (DistLeq)ectr;
                    f = (ForbiddenRegionFrame)this.externalLayer.InitFrameExternalConstraint(ectr, oIDs);
                    ic = new DistLeqIC(this.stp, f.q, f.D, f.s1, f.s2, f.o1, f.o2, dl.getDistanceVar());
                    boolean bl = nonFix = nonFix || ((DistLeqIC)ic).updateDistance(k);
                }
                if (!(ectr instanceof DistGeq)) continue;
                DistGeq dg = (DistGeq)ectr;
                f = (ForbiddenRegionFrame)this.externalLayer.InitFrameExternalConstraint(ectr, oIDs);
                ic = new DistGeqIC(this.stp, f.q, f.D, f.s1, f.s2, f.o1, f.o2, dg.getDistanceVar());
                nonFix = nonFix || ((DistGeqIC)ic).updateDistance(k);
            }
        }
        this.stp.opt.propag_failed = false;
        if (this.stp.opt.try_propagation) {
            this.stp.propagationEngine.raiseContradiction(null);
        }
        return true;
    }

    boolean filterObjWP(int k, int oid) throws ContradictionException {
        int d;
        Obj o = this.stp.getObject(oid);
        if (o.getShapeId().isInstantiated()) {
            return this.filterObj(k, oid);
        }
        int[] minG = new int[k];
        int[] maxG = new int[k];
        for (d = 0; d < k; ++d) {
            minG[d] = o.getCoord(d).getSup() + 1;
            maxG[d] = o.getCoord(d).getInf() - 1;
        }
        int sid = o.getShapeId().getInf();
        while (sid <= o.getShapeId().getSup()) {
            int d2;
            int[] max = new int[k];
            int[] min = new int[k];
            boolean b = false;
            this.solver.worldPushDuringPropagation();
            o.getShapeId().instantiate(sid, this.constraint, true);
            b = this.filterObj(k, oid);
            if (b) {
                for (d2 = 0; d2 < k; ++d2) {
                    max[d2] = o.getCoord(d2).getSup();
                    min[d2] = o.getCoord(d2).getInf();
                }
            }
            this.solver.worldPopDuringPropagation();
            if (!b) {
                o.getShapeId().removeVal(sid, this.constraint, true);
            } else {
                for (d2 = 0; d2 < k; ++d2) {
                    minG[d2] = Math.min(min[d2], minG[d2]);
                    maxG[d2] = Math.max(max[d2], maxG[d2]);
                }
            }
            sid = o.getShapeId().getNextDomainValue(sid);
        }
        for (d = 0; d < k; ++d) {
            o.getCoord(d).updateInf(minG[d], this.constraint, true);
            o.getCoord(d).updateSup(maxG[d], this.constraint, true);
        }
        return true;
    }

    boolean filterObj(int k, int oid) throws ContradictionException {
        GeostOptions cfr_ignored_0 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("GeometricKernel:FilterObj()");
        }
        Obj o = this.stp.getObject(oid);
        o.getRelatedInternalConstraints().clear();
        for (int i = 0; i < o.getRelatedExternalConstraints().size(); ++i) {
            List<InternalConstraint> v = this.externalLayer.genInternalCtrs(o.getRelatedExternalConstraints().get(i), o);
            for (int j = 0; j < v.size(); ++j) {
                o.addRelatedInternalConstraint(v.get(j));
            }
        }
        GeostOptions cfr_ignored_1 = this.stp.opt;
        if (GeostOptions.processing) {
            GeostOptions cfr_ignored_2 = this.stp.opt;
            LOGGER.info("\n/*Processing*/endchunk();\n/*Processing*/break;case " + GeostOptions.phase++ + ":\n/*Processing*/beginchunk();");
            LOGGER.info(String.format("\n/*Processing*/domain(%d,%d,%d,%d,%d);", o.getObjectId(), o.getCoord(0).getInf(), o.getCoord(0).getSup(), o.getCoord(1).getInf(), o.getCoord(1).getSup()));
            for (Integer i : this.stp.getObjectKeySet()) {
                Obj tmp = this.stp.getObject(i);
                if (!tmp.coordInstantiated() || !tmp.isSphere()) continue;
                LOGGER.info(String.format("\n/*Processing*/sphere_object(%d,%d,%d,%d);", tmp.getCoord(0).getSup(), tmp.getCoord(1).getSup(), tmp.getRadius(), tmp.getObjectId()));
            }
        }
        if (this.stp.opt.useNumericEngine) {
            if (this.engine == null) {
                LOGGER.info("engine==null");
                this.engine = new GeostNumeric(this.stp, 100);
            }
            this.engine.prune(o, k, o.getRelatedInternalConstraints());
        }
        for (int d = 0; d < k; ++d) {
            if (o.getRelatedInternalConstraints().isEmpty()) continue;
            GeostOptions cfr_ignored_3 = this.stp.opt;
            if (GeostOptions.boxModeOnly) {
                if (this.pruneMin(o, d, k, o.getRelatedInternalConstraints()) && this.pruneMax(o, d, k, o.getRelatedInternalConstraints())) continue;
                return false;
            }
            GeostOptions cfr_ignored_4 = this.stp.opt;
            if (GeostOptions.propModeOnly) {
                if (this.newPruneMin(o, d, k, o.getRelatedInternalConstraints()) && this.newPruneMax(o, d, k, o.getRelatedInternalConstraints())) continue;
                return false;
            }
            GeostOptions cfr_ignored_5 = this.stp.opt;
            if (!GeostOptions.deltaModeOnly || this.newDeltaPruneMin(o, d, k, o.getRelatedInternalConstraints()) && this.newDeltaPruneMax(o, d, k, o.getRelatedInternalConstraints())) continue;
            return false;
        }
        return true;
    }

    boolean pruneMin(Obj o, int d, int k, List<InternalConstraint> ictrs) throws ContradictionException {
        GeostOptions cfr_ignored_0 = this.stp.opt;
        if (GeostOptions.serial != null) {
            try {
                GeostOptions cfr_ignored_1 = this.stp.opt;
                GeostOptions.serial.writeObject(o);
                GeostOptions cfr_ignored_2 = this.stp.opt;
                GeostOptions.serial.writeObject(d);
                GeostOptions cfr_ignored_3 = this.stp.opt;
                GeostOptions.serial.writeObject(k);
                GeostOptions cfr_ignored_4 = this.stp.opt;
                GeostOptions.serial.writeObject(ictrs);
            }
            catch (Exception e) {
                throw new SolverException("Prune:unable to serialize parameters param in");
            }
        }
        boolean b = true;
        Point c = new Point(k);
        Point n = new Point(k);
        for (int i = 0; i < o.getCoordinates().length; ++i) {
            c.setCoord(i, o.getCoord(i).getInf());
            n.setCoord(i, o.getCoord(i).getSup() + 1);
        }
        List forbidRegion = this.getFR(d, k, o, c, n, ictrs, true);
        boolean infeasible = (Boolean)forbidRegion.get(0);
        Region f = (Region)forbidRegion.get(1);
        GeostOptions cfr_ignored_5 = this.stp.opt;
        if (GeostOptions.serial != null) {
            try {
                GeostOptions cfr_ignored_6 = this.stp.opt;
                GeostOptions.serial.writeObject(c);
                GeostOptions cfr_ignored_7 = this.stp.opt;
                GeostOptions.serial.writeObject(n);
                GeostOptions cfr_ignored_8 = this.stp.opt;
                GeostOptions.serial.writeObject(b);
                GeostOptions cfr_ignored_9 = this.stp.opt;
                GeostOptions.serial.writeObject(infeasible);
                GeostOptions cfr_ignored_10 = this.stp.opt;
                GeostOptions.serial.writeObject(f);
            }
            catch (Exception e) {
                throw new SolverException("Prune:unable to serialize parameters first iter");
            }
        }
        while (b && infeasible) {
            for (int i = 0; i < k; ++i) {
                n.setCoord(i, Math.min(n.getCoord(i), f.getMaximumBoundary(i) + 1));
            }
            List adjUp = GeometricKernel.adjustUp(c, n, o, d, k);
            c = (Point)adjUp.get(0);
            n = (Point)adjUp.get(1);
            b = (Boolean)adjUp.get(2);
            forbidRegion = this.getFR(d, k, o, c, n, ictrs, true);
            infeasible = (Boolean)forbidRegion.get(0);
            f = (Region)forbidRegion.get(1);
            GeostOptions cfr_ignored_11 = this.stp.opt;
            if (GeostOptions.serial == null) continue;
            try {
                GeostOptions cfr_ignored_12 = this.stp.opt;
                GeostOptions.serial.writeObject(c);
                GeostOptions cfr_ignored_13 = this.stp.opt;
                GeostOptions.serial.writeObject(n);
                GeostOptions cfr_ignored_14 = this.stp.opt;
                GeostOptions.serial.writeObject(b);
                GeostOptions cfr_ignored_15 = this.stp.opt;
                GeostOptions.serial.writeObject(infeasible);
                GeostOptions cfr_ignored_16 = this.stp.opt;
                GeostOptions.serial.writeObject(f);
            }
            catch (Exception e) {
                throw new SolverException("Prune:unable to serialize parameters second iter");
            }
        }
        if (b) {
            o.getCoord(d).updateInf(c.getCoord(d), this.constraint, true);
        }
        GeostOptions cfr_ignored_17 = this.stp.opt;
        if (GeostOptions.serial != null) {
            try {
                GeostOptions cfr_ignored_18 = this.stp.opt;
                GeostOptions.serial.writeObject(o);
                GeostOptions cfr_ignored_19 = this.stp.opt;
                GeostOptions.serial.writeObject(b);
            }
            catch (Exception e) {
                throw new SolverException("Prune:unable to serialize parameters param out");
            }
        }
        return b;
    }

    static List adjustUp(Point c, Point n, Obj o, int d, int k) {
        ArrayList<Serializable> result = new ArrayList<Serializable>(3);
        int jPrime = 0;
        for (int j = k - 1; j >= 0; --j) {
            jPrime = (j + d) % k;
            c.setCoord(jPrime, n.getCoord(jPrime));
            n.setCoord(jPrime, o.getCoord(jPrime).getSup() + 1);
            if (c.getCoord(jPrime) <= o.getCoord(jPrime).getSup()) {
                result.clear();
                result.add(0, c);
                result.add(1, n);
                result.add(2, Boolean.valueOf(true));
                return result;
            }
            c.setCoord(jPrime, o.getCoord(jPrime).getInf());
        }
        result.clear();
        result.add(0, c);
        result.add(1, n);
        result.add(2, Boolean.valueOf(false));
        return result;
    }

    boolean pruneMax(Obj o, int d, int k, List<InternalConstraint> ictrs) throws ContradictionException {
        boolean b = true;
        Point c = new Point(k);
        Point n = new Point(k);
        for (int i = 0; i < o.getCoordinates().length; ++i) {
            c.setCoord(i, o.getCoord(i).getSup());
            n.setCoord(i, o.getCoord(i).getInf() - 1);
        }
        List forbidRegion = this.getFR(d, k, o, c, n, ictrs, false);
        boolean infeasible = (Boolean)forbidRegion.get(0);
        Region f = (Region)forbidRegion.get(1);
        while (b && infeasible) {
            for (int i = 0; i < k; ++i) {
                n.setCoord(i, Math.max(n.getCoord(i), f.getMinimumBoundary(i) - 1));
            }
            List adjDown = GeometricKernel.adjustDown(c, n, o, d, k);
            c = (Point)adjDown.get(0);
            n = (Point)adjDown.get(1);
            b = (Boolean)adjDown.get(2);
            forbidRegion = this.getFR(d, k, o, c, n, ictrs, false);
            infeasible = (Boolean)forbidRegion.get(0);
            f = (Region)forbidRegion.get(1);
        }
        if (b) {
            o.getCoord(d).updateSup(c.getCoord(d), this.constraint, true);
            ++this.cst.nbOfUpdates;
        }
        return b;
    }

    static List adjustDown(Point c, Point n, Obj o, int d, int k) {
        ArrayList<Serializable> result = new ArrayList<Serializable>(3);
        int jPrime = 0;
        for (int j = k - 1; j >= 0; --j) {
            jPrime = (j + d) % k;
            c.setCoord(jPrime, n.getCoord(jPrime));
            n.setCoord(jPrime, o.getCoord(jPrime).getInf() - 1);
            if (c.getCoord(jPrime) >= o.getCoord(jPrime).getInf()) {
                result.clear();
                result.add(0, c);
                result.add(1, n);
                result.add(2, Boolean.valueOf(true));
                return result;
            }
            c.setCoord(jPrime, o.getCoord(jPrime).getSup());
        }
        result.clear();
        result.add(0, c);
        result.add(1, n);
        result.add(2, Boolean.valueOf(false));
        return result;
    }

    public boolean fixAllObjs(int k, int[] oIDs, List<ExternalConstraint> ectrs, List<int[]> ctrlVs, IStateInt idxLastFreeObject) throws ContradictionException {
        for (int i = 0; i < ectrs.size(); ++i) {
            ectrs.get(i).setFrame(this.externalLayer.InitFrameExternalConstraint(ectrs.get(i), oIDs));
        }
        int nbOfCtrlV = ctrlVs.size();
        int lastIdx = idxLastFreeObject.get();
        for (int i = 0; i < lastIdx; ++i) {
            Obj o = this.stp.getObject(oIDs[i]);
            int m = i % nbOfCtrlV;
            boolean b = this.fixObj(k, oIDs[i], ctrlVs.get(m));
            if (!b) {
                return false;
            }
            for (int j = 0; j < o.getRelatedExternalConstraints().size(); ++j) {
                if (o.getRelatedExternalConstraints().get(j) instanceof DistLeq || o.getRelatedExternalConstraints().get(j) instanceof DistGeq || o.getRelatedExternalConstraints().get(j) instanceof DistLinear) continue;
                int[] oIDi = new int[]{oIDs[i]};
                o.getRelatedExternalConstraints().get(j).getFrame().getRelForbidRegions().remove(o.getObjectId());
                o.getRelatedExternalConstraints().get(j).getFrame().getRelForbidRegions().put(o.getObjectId(), this.externalLayer.InitFrameExternalConstraint(o.getRelatedExternalConstraints().get(j), oIDi).getRelForbidRegions(oIDs[i]));
            }
            int tmp = oIDs[i];
            oIDs[i--] = oIDs[--lastIdx];
            oIDs[lastIdx] = tmp;
            idxLastFreeObject.add(-1);
        }
        return true;
    }

    void relForbReg(Obj o) {
        int oID = o.getObjectId();
        int[] oIDi = new int[]{oID};
        for (int j = 0; j < o.getRelatedExternalConstraints().size(); ++j) {
            o.getRelatedExternalConstraints().get(j).getFrame().getRelForbidRegions().remove(o.getObjectId());
            o.getRelatedExternalConstraints().get(j).getFrame().getRelForbidRegions().put(o.getObjectId(), this.externalLayer.InitFrameExternalConstraint(o.getRelatedExternalConstraints().get(j), oIDi).getRelForbidRegions(oID));
        }
    }

    List<InternalConstraint> absForbReg(Obj o) {
        int oID = o.getObjectId();
        int[] oIDs = new int[]{oID, oID + 1};
        ArrayList<InternalConstraint> added = new ArrayList<InternalConstraint>(16);
        for (int ic = 0; ic < o.getRelatedExternalConstraints().size(); ++ic) {
            ExternalConstraint ectr = o.getRelatedExternalConstraints().get(ic);
            NonOverlapping ectr_copy = new NonOverlapping(3, ectr.getDim(), oIDs);
            ectr_copy.getFrame().addForbidRegions(oID + 1, ectr.getFrame().getRelForbidRegions(oID));
            List<InternalConstraint> v = this.externalLayer.genInternalCtrs(ectr_copy, o);
            for (int j = 0; j < v.size(); ++j) {
                added.add(v.get(j));
            }
        }
        return added;
    }

    private static boolean same_domain(int[][] old_domain, Obj o) {
        for (int i = 0; i < old_domain.length; ++i) {
            if (old_domain[i][0] != o.getCoord(i).getDomainSize()) {
                return false;
            }
            if (old_domain[i][1] != o.getCoord(i).getInf()) {
                return false;
            }
            if (old_domain[i][2] == o.getCoord(i).getSup()) continue;
            return false;
        }
        return true;
    }

    public boolean fixAllObjs_incr(int k, int[] oIDs, List<ExternalConstraint> ectrs, List<int[]> ctrlVs, IStateInt idxLastFreeObject) throws ContradictionException {
        Integer sid_prime = null;
        int[][] domain_prime = null;
        List<InternalConstraint> ICTRS = Collections.emptyList();
        for (int i = 0; i < ectrs.size(); ++i) {
            ectrs.get(i).setFrame(this.externalLayer.InitFrameExternalConstraint(ectrs.get(i), oIDs));
        }
        int nbOfCtrlV = ctrlVs.size();
        int lastIdx = idxLastFreeObject.get();
        for (int i = 0; i < lastIdx; ++i) {
            boolean has_same_domain;
            Obj o = this.stp.getObject(oIDs[i]);
            int m = i % nbOfCtrlV;
            int[] ctrlV = ctrlVs.get(m);
            if (ctrlV[0] < 0) {
                o.getShapeId().instantiate(o.getShapeId().getInf(), this.constraint, true);
            } else {
                o.getShapeId().instantiate(o.getShapeId().getSup(), this.constraint, true);
            }
            boolean has_same_sid = sid_prime != null && o.getShapeId().getVal() == sid_prime.intValue();
            boolean bl = has_same_domain = domain_prime != null && GeometricKernel.same_domain(domain_prime, o);
            if (!has_same_sid || !has_same_domain) {
                o.getRelatedInternalConstraints().clear();
                for (int ic = 0; ic < o.getRelatedExternalConstraints().size(); ++ic) {
                    List<InternalConstraint> v = this.externalLayer.genInternalCtrs(o.getRelatedExternalConstraints().get(ic), o);
                    for (int j = 0; j < v.size(); ++j) {
                        o.addRelatedInternalConstraint(v.get(j));
                    }
                }
                sid_prime = o.getShapeId().getVal();
                if (domain_prime == null) {
                    domain_prime = new int[o.getCoordinates().length][3];
                }
                for (int l = 0; l < o.getCoordinates().length; ++l) {
                    domain_prime[l][0] = o.getCoord(l).getDomainSize();
                    domain_prime[l][1] = o.getCoord(l).getInf();
                    domain_prime[l][2] = o.getCoord(l).getSup();
                }
                ICTRS = o.getRelatedInternalConstraints();
            }
            long tmpTimePruneFix = System.nanoTime() / 1000000L;
            boolean b = this.pruneFix(o, k, ctrlV, ICTRS);
            GeostOptions cfr_ignored_0 = this.stp.opt;
            GeostOptions.timePruneFix += System.nanoTime() / 1000000L - tmpTimePruneFix;
            if (!b) {
                return false;
            }
            this.relForbReg(o);
            List<InternalConstraint> incr_ICTRS = this.absForbReg(o);
            if (!ICTRS.isEmpty() && !incr_ICTRS.isEmpty()) {
                try {
                    Outbox old_ob = (Outbox)ICTRS.get(ICTRS.size() - 1);
                    Outbox new_ob = (Outbox)incr_ICTRS.get(0);
                    Pair<Outbox, Boolean> result = this.externalLayer.mergeAdjacent(new_ob, old_ob);
                    if (((Boolean)result.snd).booleanValue()) {
                        new_ob = (Outbox)result.fst;
                        incr_ICTRS.remove(0);
                        incr_ICTRS.add(0, new_ob);
                        ICTRS.remove(ICTRS.size() - 1);
                    }
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
            }
            ICTRS.addAll(incr_ICTRS);
            int tmp = oIDs[i];
            oIDs[i--] = oIDs[--lastIdx];
            oIDs[lastIdx] = tmp;
            idxLastFreeObject.add(-1);
        }
        return true;
    }

    boolean fixObj(int k, int oid, int[] ctrlV) throws ContradictionException {
        Obj o = this.stp.getObject(oid);
        if (ctrlV[0] < 0) {
            o.getShapeId().instantiate(o.getShapeId().getInf(), this.constraint, true);
        } else {
            o.getShapeId().instantiate(o.getShapeId().getSup(), this.constraint, true);
        }
        o.getRelatedInternalConstraints().clear();
        for (int i = 0; i < o.getRelatedExternalConstraints().size(); ++i) {
            List<InternalConstraint> v = this.externalLayer.genInternalCtrs(o.getRelatedExternalConstraints().get(i), o);
            for (int j = 0; j < v.size(); ++j) {
                o.addRelatedInternalConstraint(v.get(j));
            }
        }
        return this.pruneFix(o, k, ctrlV, o.getRelatedInternalConstraints());
    }

    boolean dominates(int k, int[] ctrlV, Point c, Obj o1, Obj o2) {
        Point old_c = new Point(k);
        for (int dim = 0; dim < k; ++dim) {
            old_c.setCoord(dim, o1.getCoord(dim).getVal());
        }
        int x = o2.getShapeId().getDomain().getSup();
        int y = o1.getShapeId().getDomain().getSup();
        GeostOptions cfr_ignored_0 = this.stp.opt;
        return GeostOptions.memo_objects[o1.getObjectId()][o2.getObjectId()] && this.included.get(new Pair<Integer, Integer>(x, y)) != false && old_c.lexGreaterThan(c, ctrlV);
    }

    Point getPreviousIteration(int k, int[] d, Obj o, Point c, List<Obj> memo) {
        if (!memo.isEmpty()) {
            for (int i = 0; i < memo.size(); ++i) {
                boolean b = this.dominates(k, d, c, memo.get(i), o);
                if (!b) continue;
                Point new_sweep_point = new Point(k);
                for (int dim = 0; dim < k; ++dim) {
                    new_sweep_point.setCoord(dim, memo.get(i).getCoord(dim).getVal());
                }
                return new_sweep_point;
            }
        }
        return c;
    }

    boolean pruneFix(Obj o, int k, int[] ctrlV, List<InternalConstraint> ictrs) throws ContradictionException {
        int d;
        GeostOptions cfr_ignored_0 = this.stp.opt;
        ++GeostOptions.PruneFixCalled;
        boolean printit = false;
        if (printit) {
            LOGGER.info("-- Entering PruneFix() for object " + o.getObjectId());
            o.print();
        }
        Point c = new Point(k);
        Point n = new Point(k);
        int dPrime = 0;
        for (int d2 = k - 1; d2 > -1; --d2) {
            dPrime = Math.abs(ctrlV[d2 + 1]) - 2;
            if (ctrlV[d2 + 1] < 0) {
                c.setCoord(dPrime, o.getCoord(dPrime).getInf());
                n.setCoord(dPrime, o.getCoord(dPrime).getSup() + 1);
                continue;
            }
            c.setCoord(dPrime, o.getCoord(dPrime).getSup());
            n.setCoord(dPrime, o.getCoord(dPrime).getInf() - 1);
        }
        if (this.memo.active && this.memo.m.get(ctrlV) != null) {
            c = this.getPreviousIteration(k, ctrlV, o, c, this.memo.listObj.get(this.memo.m.get(ctrlV)));
        }
        long tmpTimeGetFr = System.nanoTime() / 1000000L;
        List forbidRegion = this.getFR(Math.abs(ctrlV[1]) - 2, k, o, c, n, ictrs, true);
        GeostOptions cfr_ignored_1 = this.stp.opt;
        GeostOptions.timeGetFR += System.nanoTime() / 1000000L - tmpTimeGetFr;
        boolean infeasible = (Boolean)forbidRegion.get(0);
        Region f = (Region)forbidRegion.get(1);
        if (printit) {
            LOGGER.info("getFR region:" + f.toString());
        }
        while (infeasible) {
            block23: {
                if (printit) {
                    LOGGER.info("Full n: ");
                    n.print();
                }
                if (printit) {
                    LOGGER.info("while infeasible");
                }
                for (d = k - 1; d > -1; --d) {
                    dPrime = Math.abs(ctrlV[d + 1]) - 2;
                    if (ctrlV[d + 1] < 0) {
                        n.setCoord(dPrime, Math.min(n.getCoord(dPrime), f.getMaximumBoundary(dPrime) + 1));
                        continue;
                    }
                    n.setCoord(dPrime, Math.max(n.getCoord(dPrime), f.getMinimumBoundary(dPrime) - 1));
                }
                if (printit) {
                    LOGGER.info("New n: ");
                    n.print();
                }
                for (d = k - 1; d > -1; --d) {
                    dPrime = Math.abs(ctrlV[d + 1]) - 2;
                    c.setCoord(dPrime, n.getCoord(dPrime));
                    if (ctrlV[d + 1] < 0) {
                        n.setCoord(dPrime, o.getCoord(dPrime).getSup() + 1);
                        if (c.getCoord(dPrime) >= n.getCoord(dPrime)) {
                            c.setCoord(dPrime, o.getCoord(dPrime).getInf());
                            continue;
                        }
                    } else {
                        n.setCoord(dPrime, o.getCoord(dPrime).getInf() - 1);
                        if (c.getCoord(dPrime) <= n.getCoord(dPrime)) {
                            c.setCoord(dPrime, o.getCoord(dPrime).getSup());
                            continue;
                        }
                    }
                    break block23;
                }
                LOGGER.info("NO NEXT CANDIDATE WAS FOUND");
                return false;
            }
            if (this.memo.active && this.memo.m.get(ctrlV) != null) {
                c = this.getPreviousIteration(k, ctrlV, o, c, this.memo.listObj.get(this.memo.m.get(ctrlV)));
            }
            if (printit) {
                LOGGER.info("Next jump: ");
                c.print();
            }
            tmpTimeGetFr = System.nanoTime() / 1000000L;
            forbidRegion = this.getFR(Math.abs(ctrlV[1]) - 2, k, o, c, n, ictrs, true);
            GeostOptions cfr_ignored_2 = this.stp.opt;
            GeostOptions.timeGetFR += System.nanoTime() / 1000000L - tmpTimeGetFr;
            infeasible = (Boolean)forbidRegion.get(0);
            f = (Region)forbidRegion.get(1);
            if (!printit) continue;
            LOGGER.info("region:" + f.toString());
        }
        for (d = 0; d < k; ++d) {
            o.getCoord(d).instantiate(c.getCoord(d), this.constraint, true);
        }
        if (this.memo.active) {
            List<Obj> currentList;
            if (this.memo.m.get(ctrlV) == null) {
                this.memo.m.put(ctrlV, this.memo.listObj.size());
                this.memo.listObj.add(new ArrayList(0));
            }
            if ((currentList = this.memo.listObj.get(this.memo.m.get(ctrlV))).size() == this.memo.p) {
                currentList.remove(currentList.size() - 1);
                currentList.add(0, o);
            } else {
                currentList.add(0, o);
            }
        }
        return true;
    }

    static Region lexMore(Region box, Region best_box, int d, int k, boolean increase) {
        if (box == null) {
            return best_box;
        }
        if (best_box == null) {
            return box;
        }
        for (int i = 0; i < k; ++i) {
            int j = (d - i) % k;
            if (j < 0) {
                j += k;
            }
            if (increase) {
                if (best_box.getMaximumBoundary(j) > box.getMaximumBoundary(j)) {
                    return best_box;
                }
                if (best_box.getMaximumBoundary(j) >= box.getMaximumBoundary(j)) continue;
                return box;
            }
            if (best_box.getMinimumBoundary(j) > box.getMinimumBoundary(j)) {
                return box;
            }
            if (best_box.getMinimumBoundary(j) >= box.getMinimumBoundary(j)) continue;
            return best_box;
        }
        return box;
    }

    static Region largestLexBox(int d, int k, boolean increase, Region box1, Region box2) {
        return GeometricKernel.lexMore_normal(box1, box2, d, k, increase);
    }

    static Region lexMore_normal(Region box, Region best_box, int d, int k, boolean increase) {
        if (box == null) {
            return best_box;
        }
        if (best_box == null) {
            return box;
        }
        for (int i = k - 1; i >= 0; --i) {
            int j = (d + i) % k;
            if (increase) {
                if (best_box.getMaximumBoundary(j) > box.getMaximumBoundary(j)) {
                    return best_box;
                }
                if (best_box.getMaximumBoundary(j) >= box.getMaximumBoundary(j)) continue;
                return box;
            }
            if (best_box.getMinimumBoundary(j) > box.getMinimumBoundary(j)) {
                return box;
            }
            if (best_box.getMinimumBoundary(j) >= box.getMinimumBoundary(j)) continue;
            return best_box;
        }
        return box;
    }

    static Region lexMore_volume(Region candidate, Region B, int d, int k, boolean increase) {
        if (candidate == null) {
            return B;
        }
        if (B == null) {
            return candidate;
        }
        int volumec = 1;
        int volumeB = 1;
        for (int i = 0; i < k; ++i) {
            volumec *= Math.abs(candidate.getMaximumBoundary(i) - candidate.getMinimumBoundary(i));
            volumeB *= Math.abs(B.getMaximumBoundary(i) - B.getMinimumBoundary(i));
        }
        if (volumec > volumeB) {
            return candidate;
        }
        if (volumec == volumeB) {
            return GeometricKernel.lexMore_normal(candidate, B, d, k, increase);
        }
        return B;
    }

    static Region proportionalFBox(InternalConstraint ictr, int d, int k, Obj o, Point c, Point jump, boolean increase, double prop) {
        double[] prop_ = new double[]{prop};
        return GeometricKernel.proportionalFBox(ictr, d, k, o, c, jump, increase, prop_);
    }

    static Region proportionalFBox(InternalConstraint ictr, int d, int k, Obj o, Point c, Point jump, boolean increase, double[] prop) {
        int i;
        if (!(ictr instanceof ForbiddenRegion)) {
            throw new SolverException("proportionalFBox():ictr is not a distance internal constraint (not a subclass of Forbidden Region for MaximizeSizeOfFBox.");
        }
        ForbiddenRegion fr = (ForbiddenRegion)ictr;
        Region f = new Region(k, o.getObjectId());
        for (i = 0; i < k; ++i) {
            int v = c.getCoord(i);
            f.setMinimumBoundary(i, v);
            f.setMaximumBoundary(i, v);
        }
        i = k - 1;
        int m = 0;
        while (i >= 0) {
            int end;
            int size;
            int j = (d + i) % k;
            double localProp = i == 0 ? 1.0 : prop[m];
            if (increase) {
                size = Math.abs(f.getMinimumBoundary(j) - fr.maximizeSizeOfFBox(true, j, k, f));
                size = (int)((double)size * localProp);
                end = f.getMinimumBoundary(j) + size;
                f.setMaximumBoundary(j, Math.min(jump.getCoord(j) - 1, end));
            } else {
                size = Math.abs(f.getMaximumBoundary(j) - fr.maximizeSizeOfFBox(false, j, k, f));
                size = (int)((double)size * localProp);
                end = f.getMaximumBoundary(j) - size;
                f.setMinimumBoundary(j, Math.max(jump.getCoord(j) + 1, end));
            }
            --i;
            ++m;
        }
        return f;
    }

    List getBestFR(int d, int k, Obj o, Point c, Point n, List<InternalConstraint> ictrs, boolean increase, boolean mode, double prop) {
        double[][] prop_ = new double[1][1];
        prop_[0][0] = prop;
        return this.getBestFR(d, k, o, c, n, ictrs, increase, mode, prop_);
    }

    List getBestFR(int d, int k, Obj o, Point c, Point n, List<InternalConstraint> ictrs, boolean increase, boolean mode, double[] prop) {
        double[][] prop_ = new double[1][prop.length];
        prop_[0] = prop;
        return this.getBestFR(d, k, o, c, n, ictrs, increase, mode, prop_);
    }

    List getBestFR(int d, int k, Obj o, Point c, Point n, List<InternalConstraint> ictrs, boolean increase, boolean mode, double[][] prop) {
        boolean trace = false;
        if (!mode) {
            return this.getFR(d, k, o, c, n, ictrs, increase);
        }
        Region candidate = null;
        ArrayList<ForbiddenRegion> list = new ArrayList<ForbiddenRegion>(16);
        for (InternalConstraint ictr : ictrs) {
            if (!(ictr instanceof ForbiddenRegion)) {
                throw new SolverException("GetBestFR():not a ForviddenRegion constraint.");
            }
            ForbiddenRegion fr = (ForbiddenRegion)ictr;
            if (!fr.insideForbidden(c)) continue;
            list.add(fr);
        }
        if (trace) {
            LOGGER.info("list of cstrs:");
            for (ForbiddenRegion fr : list) {
                LOGGER.info(fr.getIctrID() + " ");
            }
        }
        int maxVolume = 0;
        ArrayList<Region> maxVolumeList = new ArrayList<Region>(16);
        for (ForbiddenRegion fr : list) {
            Region f = null;
            List r = fr.isFeasible(increase, d, k, o, c, n);
            if (trace) {
                LOGGER.info("\\item IsFeasible$(ictr,increase=" + increase + ",d=" + d + ",k=" + k + ",o=o3" + ",c=" + c + ",n=" + n + ")$ ");
            }
            f = (Region)r.get(1);
            if (trace) {
                LOGGER.info(String.format("returns $f=%s$ ", f));
                LOGGER.info(String.format("\\item ProportionalFBox$(ictr,d=%d,k=%d,o=o3,c=%s,n=%s,increase=%s,prop=%s)$ ", new Object[]{d, k, c, n, increase, prop}));
            }
            if ((double)f.volume() > (double)maxVolume * 1.2) {
                maxVolumeList.clear();
                maxVolume = f.volume();
                maxVolumeList.add(f);
            } else if ((double)f.volume() <= (double)maxVolume * 1.2 && (double)f.volume() >= (double)maxVolume * 0.8) {
                maxVolumeList.add(f);
            }
            boolean firstTime = true;
            for (int p = 0; p < prop.length; ++p) {
                Region B = GeometricKernel.proportionalFBox((InternalConstraint)fr, d, k, o, c, n, increase, prop[p]);
                if (trace) {
                    LOGGER.info("returns $B=" + B + "$ ");
                }
                if ((double)B.volume() > (double)maxVolume * 1.2) {
                    maxVolumeList.clear();
                    maxVolume = B.volume();
                    maxVolumeList.add(B);
                } else if ((double)B.volume() <= (double)maxVolume * 1.2 && (double)B.volume() >= (double)maxVolume * 0.8) {
                    maxVolumeList.add(B);
                }
                if (trace) {
                    LOGGER.info("fr(" + f.getMinimumBoundary(0) + ',' + f.getMinimumBoundary(1) + ',' + f.getMaximumBoundary(0) + ',' + f.getMaximumBoundary(1) + ");");
                }
                if (trace) {
                    LOGGER.info("fr(" + B.getMinimumBoundary(0) + ',' + B.getMinimumBoundary(1) + ',' + B.getMaximumBoundary(0) + ',' + B.getMaximumBoundary(1) + ");");
                }
                if (trace) {
                    LOGGER.info("\\item lexMore$(B=" + B + ",f=" + f + ",d=" + d + ",k=" + k + ",increase=" + increase + ")$ ");
                }
                if (firstTime) {
                    B = GeometricKernel.lexMore_volume(B, f, d, k, increase);
                    firstTime = false;
                }
                if (trace) {
                    LOGGER.info("\\item $B \\gets " + B + "$ ");
                }
                if (trace) {
                    LOGGER.info("\\item lexMore$(candidate=" + candidate + ",B=" + B + ",d=" + d + ",k=" + k + ",increase=" + increase + ")$ ");
                }
                candidate = GeometricKernel.lexMore_volume(candidate, B, d, k, increase);
            }
            if (!trace) continue;
            LOGGER.info("\\item $candidate \\gets " + candidate + " $");
        }
        list = null;
        candidate = !maxVolumeList.isEmpty() ? (Region)maxVolumeList.get(0) : null;
        for (int i = 1; i < maxVolumeList.size(); ++i) {
            candidate = GeometricKernel.lexMore(candidate, (Region)maxVolumeList.get(i), d, k, increase);
        }
        ArrayList<Serializable> result = new ArrayList<Serializable>(2);
        result.add(Boolean.valueOf(candidate != null));
        result.add(candidate);
        return result;
    }

    static List adjustDown(Point c, Point n, Obj o, int d, int k, boolean mode) {
        int cd = c.getCoord(d);
        ArrayList<Serializable> result = new ArrayList<Serializable>(4);
        int jPrime = 0;
        for (int j = k - 1; j >= 0; --j) {
            jPrime = (j + d) % k;
            c.setCoord(jPrime, n.getCoord(jPrime));
            n.setCoord(jPrime, o.getCoord(jPrime).getInf() - 1);
            if (c.getCoord(jPrime) >= o.getCoord(jPrime).getInf()) {
                if (cd == c.getCoord(d) + 1) {
                    mode = true;
                }
                result.clear();
                result.add(0, c);
                result.add(1, n);
                result.add(2, Boolean.valueOf(true));
                result.add(3, Boolean.valueOf(mode));
                return result;
            }
            c.setCoord(jPrime, o.getCoord(jPrime).getSup());
        }
        result.clear();
        result.add(0, c);
        result.add(1, n);
        result.add(2, Boolean.valueOf(false));
        result.add(3, Boolean.valueOf(mode));
        return result;
    }

    static List adjustUp(Point c, Point n, Obj o, int d, int k, boolean mode) {
        int cd = c.getCoord(d);
        ArrayList<Serializable> result = new ArrayList<Serializable>(4);
        int jPrime = 0;
        for (int j = k - 1; j >= 0; --j) {
            jPrime = (j + d) % k;
            c.setCoord(jPrime, n.getCoord(jPrime));
            n.setCoord(jPrime, o.getCoord(jPrime).getSup() + 1);
            if (c.getCoord(jPrime) <= o.getCoord(jPrime).getSup()) {
                if (cd == c.getCoord(d) - 1) {
                    mode = true;
                }
                result.clear();
                result.add(0, c);
                result.add(1, n);
                result.add(2, Boolean.valueOf(true));
                result.add(3, Boolean.valueOf(mode));
                return result;
            }
            c.setCoord(jPrime, o.getCoord(jPrime).getInf());
        }
        result.clear();
        result.add(0, c);
        result.add(1, n);
        result.add(2, Boolean.valueOf(false));
        result.add(3, Boolean.valueOf(mode));
        return result;
    }

    boolean newPruneMin(Obj o, int d, int k, List<InternalConstraint> ictrs) throws ContradictionException {
        boolean trace = false;
        if (trace) {
            LOGGER.info("//in:o" + o.getObjectId() + ':' + o + '(' + ictrs + ')');
        }
        boolean processing = true;
        GeostOptions cfr_ignored_0 = this.stp.opt;
        if (GeostOptions.serial != null) {
            LOGGER.info("COUCOU");
            try {
                GeostOptions cfr_ignored_1 = this.stp.opt;
                GeostOptions.serial.writeObject(o);
                GeostOptions cfr_ignored_2 = this.stp.opt;
                GeostOptions.serial.writeObject(d);
                GeostOptions cfr_ignored_3 = this.stp.opt;
                GeostOptions.serial.writeObject(k);
                GeostOptions cfr_ignored_4 = this.stp.opt;
                GeostOptions.serial.writeObject(ictrs);
            }
            catch (Exception e) {
                throw new SolverException("Prune:unable to serialize parameters param in");
            }
        }
        boolean b = true;
        boolean mode = false;
        Point c = new Point(k);
        Point n = new Point(k);
        for (int i = 0; i < o.getCoordinates().length; ++i) {
            c.setCoord(i, o.getCoord(i).getInf());
            n.setCoord(i, o.getCoord(i).getSup() + 1);
        }
        GeostOptions cfr_ignored_5 = this.stp.opt;
        List forbidRegion = this.getBestFR(d, k, o, c, n, ictrs, true, mode, GeostOptions.prop);
        boolean infeasible = (Boolean)forbidRegion.get(0);
        Region f = (Region)forbidRegion.get(1);
        if (processing) {
            int i;
            GeostOptions cfr_ignored_6 = this.stp.opt;
            LOGGER.info("if (phase==" + GeostOptions.phase + "){");
            LOGGER.info("sphereList.clear(); container_size(" + this.stp.getObject(3).getCoord(0).getInf() * 2 + ',' + this.stp.getObject(3).getCoord(1).getInf() * 2 + ',' + this.stp.getObject(3).getCoord(2).getInf() * 2 + ");");
            for (Integer l : this.stp.getObjectKeySet()) {
                Obj otmp = this.stp.getObject(l);
                if (!otmp.coordInstantiated()) continue;
                LOGGER.info(" sphere(" + o.getObjectId() + ',' + otmp.getRadius() + ',');
                for (int i2 = 0; i2 < k; ++i2) {
                    if (i2 != k - 1) {
                        LOGGER.info(otmp.getCoord(i2).getInf() + ",");
                        continue;
                    }
                    LOGGER.info(otmp.getCoord(i2).getInf() + ");");
                }
            }
            if (infeasible) {
                LOGGER.info(";mode=" + mode + ";d=" + d + ';');
                LOGGER.info("fr(");
                for (int i3 = 0; i3 < k; ++i3) {
                    if (i3 != k - 1) {
                        LOGGER.info(f.getMinimumBoundary(i3) + "," + f.getMaximumBoundary(i3) + ',');
                        continue;
                    }
                    LOGGER.info(f.getMinimumBoundary(i3) + "," + f.getMaximumBoundary(i3) + ");");
                }
            }
            LOGGER.info(" sweep_point(");
            for (i = 0; i < k; ++i) {
                if (i != k - 1) {
                    LOGGER.info(c.getCoord(i) + ",");
                    continue;
                }
                LOGGER.info(c.getCoord(i) + ");");
            }
            LOGGER.info(" jump_point(");
            for (i = 0; i < k; ++i) {
                if (i != k - 1) {
                    LOGGER.info(c.getCoord(i) + ",");
                    continue;
                }
                LOGGER.info(c.getCoord(i) + ");");
            }
            LOGGER.info("}");
            GeostOptions cfr_ignored_7 = this.stp.opt;
            ++GeostOptions.phase;
        }
        GeostOptions cfr_ignored_8 = this.stp.opt;
        if (GeostOptions.serial != null) {
            try {
                GeostOptions cfr_ignored_9 = this.stp.opt;
                GeostOptions.serial.writeObject(c);
                GeostOptions cfr_ignored_10 = this.stp.opt;
                GeostOptions.serial.writeObject(n);
                GeostOptions cfr_ignored_11 = this.stp.opt;
                GeostOptions.serial.writeObject(b);
                GeostOptions cfr_ignored_12 = this.stp.opt;
                GeostOptions.serial.writeObject(infeasible);
                GeostOptions cfr_ignored_13 = this.stp.opt;
                GeostOptions.serial.writeObject(f);
            }
            catch (Exception e) {
                throw new SolverException("Prune:unable to serialize parameters first iter");
            }
        }
        while (b && infeasible) {
            for (int i = 0; i < k; ++i) {
                n.setCoord(i, Math.min(n.getCoord(i), f.getMaximumBoundary(i) + 1));
            }
            Point initial_c = new Point(c);
            List adjUp = GeometricKernel.adjustUp(c, n, o, d, k, mode);
            c = (Point)adjUp.get(0);
            n = (Point)adjUp.get(1);
            b = (Boolean)adjUp.get(2);
            mode = (Boolean)adjUp.get(3);
            adjUp = null;
            GeostOptions cfr_ignored_14 = this.stp.opt;
            if (GeostOptions.delta.get(d) == null) {
                GeostOptions cfr_ignored_15 = this.stp.opt;
                GeostOptions.delta.put(d, new HashMap(16));
            }
            GeostOptions cfr_ignored_16 = this.stp.opt;
            HashMap<Integer, Integer> curDelta = GeostOptions.delta.get(d);
            int delta = Math.abs(c.getCoord(d) - initial_c.getCoord(d));
            if (curDelta.get(delta) == null) {
                curDelta.put(delta, 0);
            }
            curDelta.put(delta, curDelta.get(delta) + 1);
            GeostOptions cfr_ignored_17 = this.stp.opt;
            forbidRegion = this.getBestFR(d, k, o, c, n, ictrs, true, mode, GeostOptions.prop);
            if (processing) {
                int i;
                GeostOptions cfr_ignored_18 = this.stp.opt;
                LOGGER.info("if (phase==" + GeostOptions.phase + "){");
                LOGGER.info("sphereList.clear();");
                for (Integer l : this.stp.getObjectKeySet()) {
                    Obj otmp = this.stp.getObject(l);
                    if (!otmp.coordInstantiated()) continue;
                    LOGGER.info(" sphere(" + o.getObjectId() + ',' + otmp.getRadius() + ',');
                    for (int i4 = 0; i4 < k; ++i4) {
                        if (i4 != k - 1) {
                            LOGGER.info(otmp.getCoord(i4).getInf() + ",");
                            continue;
                        }
                        LOGGER.info(otmp.getCoord(i4).getInf() + ");");
                    }
                }
                LOGGER.info("}");
                if (infeasible) {
                    LOGGER.info(";mode=" + mode + ";d=" + d + ';');
                    LOGGER.info(" fr(");
                    for (int i5 = 0; i5 < k; ++i5) {
                        if (i5 != k - 1) {
                            LOGGER.info(f.getMinimumBoundary(i5) + "," + f.getMaximumBoundary(i5) + ',');
                            continue;
                        }
                        LOGGER.info(f.getMinimumBoundary(i5) + "," + f.getMaximumBoundary(i5) + ");");
                    }
                }
                LOGGER.info(" sweep_point(");
                for (i = 0; i < k; ++i) {
                    if (i != k - 1) {
                        LOGGER.info(c.getCoord(i) + ",");
                        continue;
                    }
                    LOGGER.info(c.getCoord(i) + ");");
                }
                LOGGER.info(" jump_point(");
                for (i = 0; i < k; ++i) {
                    if (i != k - 1) {
                        LOGGER.info(c.getCoord(i) + ",");
                        continue;
                    }
                    LOGGER.info(c.getCoord(i) + ");");
                }
                LOGGER.info("}");
                GeostOptions cfr_ignored_19 = this.stp.opt;
                ++GeostOptions.phase;
            }
            infeasible = (Boolean)forbidRegion.get(0);
            f = (Region)forbidRegion.get(1);
            forbidRegion = null;
            GeostOptions cfr_ignored_20 = this.stp.opt;
            if (GeostOptions.serial == null) continue;
            try {
                GeostOptions cfr_ignored_21 = this.stp.opt;
                GeostOptions.serial.writeObject(c);
                GeostOptions cfr_ignored_22 = this.stp.opt;
                GeostOptions.serial.writeObject(n);
                GeostOptions cfr_ignored_23 = this.stp.opt;
                GeostOptions.serial.writeObject(b);
                GeostOptions cfr_ignored_24 = this.stp.opt;
                GeostOptions.serial.writeObject(infeasible);
                GeostOptions cfr_ignored_25 = this.stp.opt;
                GeostOptions.serial.writeObject(f);
            }
            catch (Exception e) {
                throw new SolverException("Prune:unable to serialize parameters second iter");
            }
        }
        if (b) {
            o.getCoord(d).updateInf(c.getCoord(d), this.constraint, true);
            if (trace) {
                LOGGER.info("//out:o:" + o);
            }
        }
        GeostOptions cfr_ignored_26 = this.stp.opt;
        if (GeostOptions.serial != null) {
            try {
                GeostOptions cfr_ignored_27 = this.stp.opt;
                GeostOptions.serial.writeObject(o);
                GeostOptions cfr_ignored_28 = this.stp.opt;
                GeostOptions.serial.writeObject(b);
            }
            catch (Exception e) {
                throw new SolverException("Prune:unable to serialize parameters param out");
            }
        }
        return b;
    }

    boolean newPruneMax(Obj o, int d, int k, List<InternalConstraint> ictrs) throws ContradictionException {
        boolean b = true;
        boolean mode = false;
        Point c = new Point(k);
        Point n = new Point(k);
        for (int i = 0; i < o.getCoordinates().length; ++i) {
            c.setCoord(i, o.getCoord(i).getSup());
            n.setCoord(i, o.getCoord(i).getInf() - 1);
        }
        GeostOptions cfr_ignored_0 = this.stp.opt;
        List forbidRegion = this.getBestFR(d, k, o, c, n, ictrs, false, mode, GeostOptions.prop);
        boolean infeasible = (Boolean)forbidRegion.get(0);
        Region f = (Region)forbidRegion.get(1);
        while (b && infeasible) {
            for (int i = 0; i < k; ++i) {
                n.setCoord(i, Math.max(n.getCoord(i), f.getMinimumBoundary(i) - 1));
            }
            Point initial_c = new Point(c);
            List adjDown = GeometricKernel.adjustDown(c, n, o, d, k, mode);
            c = (Point)adjDown.get(0);
            n = (Point)adjDown.get(1);
            b = (Boolean)adjDown.get(2);
            mode = (Boolean)adjDown.get(3);
            adjDown = null;
            GeostOptions cfr_ignored_1 = this.stp.opt;
            if (GeostOptions.delta.get(d) == null) {
                GeostOptions cfr_ignored_2 = this.stp.opt;
                GeostOptions.delta.put(d, new HashMap(16));
            }
            GeostOptions cfr_ignored_3 = this.stp.opt;
            HashMap<Integer, Integer> curDelta = GeostOptions.delta.get(d);
            int delta = Math.abs(c.getCoord(d) - initial_c.getCoord(d));
            if (curDelta.get(delta) == null) {
                curDelta.put(delta, 0);
            }
            curDelta.put(delta, curDelta.get(delta) + 1);
            GeostOptions cfr_ignored_4 = this.stp.opt;
            forbidRegion = this.getBestFR(d, k, o, c, n, ictrs, false, mode, GeostOptions.prop);
            infeasible = (Boolean)forbidRegion.get(0);
            f = (Region)forbidRegion.get(1);
            forbidRegion = null;
        }
        if (b) {
            o.getCoord(d).updateSup(c.getCoord(d), this.constraint, true);
        }
        return b;
    }

    static boolean isFeasible(Point p, List<InternalConstraint> ictrs) {
        for (InternalConstraint ictr : ictrs) {
            if (!(ictr instanceof ForbiddenRegion)) {
                throw new SolverException("GeometricKernel:isFeasible():not a ForbiddenRegion constraint.");
            }
            ForbiddenRegion fr = (ForbiddenRegion)ictr;
            if (!fr.insideForbidden(p)) continue;
            return false;
        }
        return true;
    }

    static List<ForbiddenRegion> setOfCstrsOnPt(Point c, List<InternalConstraint> ictrs) {
        ArrayList<ForbiddenRegion> r = new ArrayList<ForbiddenRegion>(ictrs.size());
        for (InternalConstraint ictr : ictrs) {
            if (!(ictr instanceof ForbiddenRegion)) {
                throw new SolverException("GeometricKernel:SetOfCstrsOnPt():not a ForbiddenRegion constraint.");
            }
            ForbiddenRegion fr = (ForbiddenRegion)ictr;
            if (!fr.insideForbidden(c)) continue;
            r.add(fr);
        }
        return r;
    }

    static int nbrOfCstrsOnPt(Point c, List<InternalConstraint> ictrs) {
        return GeometricKernel.setOfCstrsOnPt(c, ictrs).size();
    }

    static Point maxPt(Point p1, Point p2, int d, boolean second_pt_is_defined, boolean increase) {
        if (!second_pt_is_defined || p1.getCoord(d) >= p2.getCoord(d) == increase) {
            return p1;
        }
        return p2;
    }

    static Point slidePt(Point p, int d, int value) {
        Point r = new Point(p);
        r.setCoord(d, value);
        return r;
    }

    static int prev(boolean increase) {
        if (increase) {
            return -1;
        }
        return 1;
    }

    static int succ(boolean increase) {
        if (increase) {
            return 1;
        }
        return -1;
    }

    static int min(int a, int b, boolean increase) {
        if (increase) {
            return Math.min(a, b);
        }
        return Math.max(a, b);
    }

    static int max(int a, int b, boolean increase) {
        if (increase) {
            return Math.max(a, b);
        }
        return Math.min(a, b);
    }

    static Region buildBox(int k, Point p1, Point p2) {
        Region box = new Region(k, 0);
        for (int i = 0; i < k; ++i) {
            box.setMinimumBoundary(i, Math.min(p1.getCoord(i), p2.getCoord(i)));
            box.setMaximumBoundary(i, Math.max(p1.getCoord(i), p2.getCoord(i)));
        }
        return box;
    }

    static double ratio(Region box) {
        return box.ratio();
    }

    Point extend(Point p, int d, int k, Point n, ForbiddenRegion ictr, boolean increase) {
        GeostOptions cfr_ignored_0 = this.stp.opt;
        if (GeostOptions.debug && !ictr.insideForbidden(p)) {
            throw new SolverException("GeometricKernel:Extend():Invariant 1 failed:p:" + p + " is not segInsideForbidden of ictr:" + ictr);
        }
        Region box = new Region(p);
        Point result = new Point(p);
        int m = ictr.maximizeSizeOfFBox(increase, d, k, box);
        result.setCoord(d, GeometricKernel.min(n.getCoord(d) + GeometricKernel.prev(increase), m, increase));
        return result;
    }

    Point extend2(Point p, int d, int k, Point cut_point, ForbiddenRegion ictr1, ForbiddenRegion ictr2, boolean increase) {
        GeostOptions cfr_ignored_0 = this.stp.opt;
        if (GeostOptions.debug) {
            if (ictr1 == ictr2) {
                throw new SolverException("GeometricKernel:Extend2():Invariant 1 failed:(ictr!=ictr2)");
            }
            if (!ictr1.insideForbidden(p)) {
                throw new SolverException("GeometricKernel:Extend2():Invariant 2 failed:(ictr.segInsideForbidden(p))");
            }
            if (!ictr2.insideForbidden(p)) {
                throw new SolverException("GeometricKernel:Extend2():Invariant 3 failed:(ictr2.segInsideForbidden(p))");
            }
        }
        Region box = new Region(p);
        Point result = new Point(p);
        result.setCoord(d, GeometricKernel.min(cut_point.getCoord(d), ictr1.maximizeSizeOfFBox(increase, d, k, box), increase));
        result.setCoord(d, GeometricKernel.min(result.getCoord(d), ictr2.maximizeSizeOfFBox(increase, d, k, box), increase));
        return result;
    }

    static Point extend_both(Point p, int d, int k, Point cut_point, ForbiddenRegion ictr, ForbiddenRegion ictr2, boolean increase) {
        Point result = new Point(p);
        if (ictr.insideForbidden(result)) {
            result.setCoord(d, GeometricKernel.min(cut_point.getCoord(d), ictr.maximizeSizeOfFBox(increase, d, k, new Region(result)), increase));
        }
        if (ictr2.insideForbidden(result)) {
            result.setCoord(d, GeometricKernel.min(cut_point.getCoord(d), ictr2.maximizeSizeOfFBox(increase, d, k, new Region(result)), increase));
        }
        if (ictr.insideForbidden(result)) {
            result.setCoord(d, GeometricKernel.min(cut_point.getCoord(d), ictr.maximizeSizeOfFBox(increase, d, k, new Region(result)), increase));
        }
        if (ictr2.insideForbidden(result)) {
            result.setCoord(d, GeometricKernel.min(cut_point.getCoord(d), ictr2.maximizeSizeOfFBox(increase, d, k, new Region(result)), increase));
        }
        return result;
    }

    static boolean largestInverseLex(int d_prune, int k, boolean increase, Region box, Region best_box) {
        if (box == null || best_box == null) {
            throw new SolverException("GeometricKernel:LargestInverseLex():invariant 1 failed");
        }
        for (int d = 0; d <= k + 1; ++d) {
            int bb;
            int b;
            int d_prime = (d + d_prune) % k;
            if (increase) {
                b = box.getMaximumBoundary(d_prime);
                bb = best_box.getMaximumBoundary(d_prime);
            } else {
                b = box.getMinimumBoundary(d_prime);
                bb = best_box.getMinimumBoundary(d_prime);
            }
            if (b == bb) {
                continue;
            }
            return b > bb == increase;
        }
        return false;
    }

    static Region largestInvLexBox(int d_prune, int k, boolean increase, Region box, Region best_box) {
        if (box == null) {
            return best_box;
        }
        if (best_box == null) {
            return box;
        }
        if (GeometricKernel.largestInverseLex(d_prune, k, increase, box, best_box)) {
            return box;
        }
        return best_box;
    }

    static boolean equalInverseLex(int k, Region box, Region best_box) {
        for (int i = 0; i < k; ++i) {
            if (box.getSize(i) == best_box.getSize(i)) continue;
            return false;
        }
        return true;
    }

    static Region bestVolume(Region box, Region best_box) {
        int best_box_volume;
        if (box == null) {
            return best_box;
        }
        if (best_box == null) {
            return box;
        }
        int box_volume = box.volume();
        if (box_volume > (best_box_volume = best_box.volume())) {
            return box;
        }
        return best_box;
    }

    static boolean equalVolume(Region box, Region best_box) {
        return box.volume() == best_box.volume();
    }

    Region selectionCriteria(int d_prune, int k, boolean increase, Region box1, Region box2) {
        double ratio2;
        GeostOptions cfr_ignored_0 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("/*debug*/SelectionCriteria(d_prune=" + d_prune + ", k=" + k + ", increase=" + increase + " box1=" + box1 + " ,box2=" + box2 + ')');
        }
        if (box1 == null) {
            GeostOptions cfr_ignored_1 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("/*debug*/SelectionCriteria() returns null");
                return box2;
            }
        }
        if (box2 == null) {
            GeostOptions cfr_ignored_2 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("/*debug*/SelectionCriteria() returns null");
                return box1;
            }
        }
        int won1 = 0;
        int won2 = 0;
        assert (box1 != null);
        assert (box2 != null);
        if (box1.ratio() <= 0.1 && box2.ratio() <= 0.1 && !box1.included(box2) && !box2.included(box1)) {
            Region tmp = GeometricKernel.largestLexBox(d_prune, k, increase, box1, box2);
            GeostOptions cfr_ignored_3 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("/*debug*/SelectionCriteria() returns " + tmp);
            }
            return tmp;
        }
        if (!GeometricKernel.equalVolume(box1, box2)) {
            if (GeometricKernel.bestVolume(box1, box2) == box1) {
                ++won1;
            } else {
                ++won2;
            }
        }
        boolean not_same = !GeometricKernel.equalInverseLex(k, box1, box2);
        boolean first_box = false;
        if (not_same) {
            boolean bl = first_box = GeometricKernel.largestInvLexBox(d_prune, k, increase, box1, box2) == box1;
            if (first_box) {
                ++won1;
            } else {
                ++won2;
            }
        }
        if (k != 2) {
            throw new SolverException("GeometricKernel:SelectionCriteria():only k=2 is supported.");
        }
        double ratio1 = GeometricKernel.ratio(box1);
        if (ratio1 != (ratio2 = GeometricKernel.ratio(box2))) {
            if (ratio1 > ratio2) {
                ++won1;
            } else {
                ++won2;
            }
        }
        if (won1 == won2) {
            if (not_same) {
                if (first_box) {
                    GeostOptions cfr_ignored_4 = this.stp.opt;
                    if (GeostOptions.debug) {
                        LOGGER.info("/*debug*/SelectionCriteria() returns " + box1);
                    }
                    return box1;
                }
                GeostOptions cfr_ignored_5 = this.stp.opt;
                if (GeostOptions.debug) {
                    LOGGER.info("/*debug*/SelectionCriteria() returns " + box2);
                }
                return box2;
            }
            Region tmp = GeometricKernel.largestInvLexBox(d_prune, k, increase, box1, box2);
            GeostOptions cfr_ignored_6 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("/*debug*/SelectionCriteria() returns " + tmp);
            }
            return tmp;
        }
        if (won1 > won2) {
            GeostOptions cfr_ignored_7 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("/*debug*/SelectionCriteria() returns " + box1);
            }
            return box1;
        }
        GeostOptions cfr_ignored_8 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("/*debug*/SelectionCriteria() returns " + box2);
        }
        return box2;
    }

    static Region finishToExtendBox(int d_prune, int k, Point n, boolean increase, ForbiddenRegion ictr, int todim, Region box) {
        for (int d = k - 1; d >= todim; --d) {
            int d_prime = (d + d_prune) % k;
            if (k == 3 && d == d_prune) continue;
            if (box.getMinimumBoundary(d_prime) != box.getMaximumBoundary(d_prime)) {
                throw new SolverException("GeometricKernel:FinishToExtendBox():box:" + box + ";d:" + d_prime);
            }
            if (increase) {
                box.setMaximumBoundary(d_prime, Math.min(n.getCoord(d_prime) - 1, ictr.maximizeSizeOfFBox(increase, d_prime, k, box)));
                continue;
            }
            box.setMinimumBoundary(d_prime, Math.max(n.getCoord(d_prime) + 1, ictr.maximizeSizeOfFBox(increase, d_prime, k, box)));
        }
        return box;
    }

    static Region getGreedyBoxFromPoint(int d_prune, int k, Point c, Point n, ForbiddenRegion ictr, boolean increase, int limit_prune) {
        Region box = new Region(c);
        if (k == 3) {
            if (increase) {
                if (box.getMinimumBoundary(d_prune) + limit_prune - 1 > ictr.maximizeSizeOfFBox(increase, d_prune, k, box)) {
                    throw new SolverException("GeometricKernel:GetGreedyBoxFromPoint():invariant failed");
                }
                box.setMaximumBoundary(d_prune, box.getMinimumBoundary(d_prune) + limit_prune - 1);
            } else {
                if (box.getMaximumBoundary(d_prune) - limit_prune + 1 < ictr.maximizeSizeOfFBox(increase, d_prune, k, box)) {
                    throw new SolverException("GeometricKernel:GetGreedyBoxFromPoint():invariant failed");
                }
                box.setMinimumBoundary(d_prune, box.getMaximumBoundary(d_prune) - limit_prune + 1);
            }
        }
        Region r = GeometricKernel.finishToExtendBox(d_prune, k, n, increase, ictr, 0, box);
        r.setType("Greedy");
        r.father = "GreedyPoint";
        return r;
    }

    static Region getGreedyBoxFromJumpVector(int d_prev_least, int d_prune, int k, Point c, Point n, int inter, ForbiddenRegion ictr, boolean increase, int limit_prune) {
        int m;
        Region box = new Region(c);
        if (k == 3) {
            if (increase) {
                if (box.getMinimumBoundary(d_prune) + limit_prune - 1 > ictr.maximizeSizeOfFBox(increase, d_prune, k, box)) {
                    throw new SolverException("GeometricKernel:GetGreedyBoxFromPoint():invariant failed");
                }
                box.setMaximumBoundary(d_prune, box.getMinimumBoundary(d_prune) + limit_prune - 1);
            } else {
                if (box.getMaximumBoundary(d_prune) - limit_prune + 1 < ictr.maximizeSizeOfFBox(increase, d_prune, k, box)) {
                    throw new SolverException("GeometricKernel:GetGreedyBoxFromPoint():invariant failed");
                }
                box.setMinimumBoundary(d_prune, box.getMaximumBoundary(d_prune) - limit_prune + 1);
            }
        }
        if (increase) {
            m = Math.min(n.getCoord(d_prev_least) - 1, inter);
            m = Math.min(m, ictr.maximizeSizeOfFBox(increase, d_prev_least, k, box));
            box.setMaximumBoundary(d_prev_least, m);
        } else {
            m = Math.max(n.getCoord(d_prev_least) + 1, inter);
            m = Math.max(m, ictr.maximizeSizeOfFBox(increase, d_prev_least, k, box));
            box.setMinimumBoundary(d_prev_least, m);
        }
        Region r = GeometricKernel.finishToExtendBox(d_prune, k, n, increase, ictr, (d_prev_least + 1 - d_prune + k) % k, box);
        r.setType("Vector");
        r.father = "GreedyVector";
        return r;
    }

    Pair<Boolean, Integer> findBoxInterIn(int d_least, int d_prev_least, int k, Point c, Point n, boolean increase, ForbiddenRegion ictr_c, ForbiddenRegion ictr_g, int low, int up) {
        if (low >= up) {
            return new Pair<Boolean, Integer>(false, 0);
        }
        Point low_pt = GeometricKernel.slidePt(c, d_least, low);
        Point up_pt = GeometricKernel.slidePt(c, d_least, up);
        if (!ictr_c.insideForbidden(low_pt) || !ictr_c.insideForbidden(up_pt)) {
            throw new SolverException("GeometricKernel:FindBoxInterIn():invariant2");
        }
        if (GeometricKernel.min(up, ictr_c.maximizeSizeOfFBox(increase, d_least, k, new Region(low_pt)), increase) != up) {
            throw new SolverException("GeometricKernel:FindBoxInterIn():invariant3");
        }
        Point maxl_pt = this.extend(low_pt, d_prev_least, k, n, ictr_c, increase);
        boolean low_g = ictr_g.insideForbidden(maxl_pt);
        Point maxu_pt = this.extend(up_pt, d_prev_least, k, n, ictr_c, increase);
        boolean up_g = ictr_g.insideForbidden(maxu_pt);
        int mid = -1;
        Point mid_ext = null;
        while (low_g != up_g && low < up) {
            mid = (low + up) / 2;
            Point mid_pt = GeometricKernel.slidePt(c, d_least, mid);
            mid_ext = this.extend(mid_pt, d_prev_least, k, n, ictr_c, increase);
            boolean mid_g = ictr_g.insideForbidden(mid_ext);
            if (mid_g == low_g) {
                low = mid + 1;
                low_pt = GeometricKernel.slidePt(c, d_least, low);
                maxl_pt = this.extend(low_pt, d_prev_least, k, n, ictr_c, increase);
                low_g = ictr_g.insideForbidden(maxl_pt);
                continue;
            }
            up = mid - 1;
            up_pt = GeometricKernel.slidePt(c, d_least, up);
            maxu_pt = this.extend(up_pt, d_prev_least, k, n, ictr_c, increase);
            up_g = ictr_g.insideForbidden(maxu_pt);
        }
        if (low >= up) {
            return new Pair<Boolean, Integer>(true, mid_ext.getCoord(d_prev_least));
        }
        return new Pair<Boolean, Integer>(false, 0);
    }

    Region findBoxInter(int d_prune, int d_least, int d_prev_least, int k, Point c, Point g, Point n, boolean increase, ForbiddenRegion ictr_c, ForbiddenRegion ictr_g, int pos_p) {
        GeostOptions cfr_ignored_0 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("/*debug*/FindBoxInter(d_prune=" + d_prune + ", d_least=" + d_least + ", d_prev_least=" + d_prev_least + ", k=" + k + ", c=" + c + ", g=" + g + ", n=" + n + ", increase" + increase + ", ictr_c=" + ictr_c + ", ictr_g=" + ictr_g + ", pos_p=" + pos_p + ')');
        }
        if (!(increase && c.getCoord(d_least) <= g.getCoord(d_least) || !increase && c.getCoord(d_least) >= g.getCoord(d_least))) {
            throw new SolverException("GeometricKernel:Region FindBoxInterIn():invariant1");
        }
        int low = 0;
        int up = 0;
        if (increase) {
            low = c.getCoord(d_least);
            up = g.getCoord(d_least);
        } else {
            up = c.getCoord(d_least);
            low = g.getCoord(d_least);
        }
        Pair<Boolean, Integer> p = this.findBoxInterIn(d_least, d_prev_least, k, c, n, increase, ictr_c, ictr_g, low, up);
        boolean b = (Boolean)p.fst;
        int inter = (Integer)p.snd;
        if (b) {
            GeostOptions cfr_ignored_1 = this.stp.opt;
            if (GeostOptions.processing) {
                LOGGER.info("\n/*Processing*/intersection(" + d_prune + ',' + inter + ");");
            }
            Region rbox = GeometricKernel.getGreedyBoxFromJumpVector(d_prev_least, d_prune, k, c, n, inter, ictr_c, increase, pos_p);
            rbox.father = "FindBoxInter";
            GeostOptions cfr_ignored_2 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("/*debug*/FindBoxInter() returns " + rbox);
            }
            return rbox;
        }
        GeostOptions cfr_ignored_3 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("/*debug*/FindBoxInter() returns null");
        }
        return null;
    }

    List longestCommonInterval(int d, int k, Point p, ForbiddenRegion ictr, ForbiddenRegion ictr2, Point jump, boolean increase) {
        ForbiddenRegion otherIctr;
        ForbiddenRegion startingIctr;
        GeostOptions cfr_ignored_0 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("/*debug*/LongestCommonInterval(d=" + d + ", k=" + k + ", p=" + p + ", ictr=" + ictr + ", ictr2=" + ictr2 + ", jump=" + jump + ", increase=" + increase + ')');
        }
        ArrayList<Serializable> result = new ArrayList<Serializable>(3);
        boolean inIctr = ictr.insideForbidden(p);
        boolean inIctr2 = ictr2.insideForbidden(p);
        if (inIctr && inIctr2) {
            Point max = this.extend2(p, d, k, jump, ictr, ictr2, increase);
            Point min = new Point(p);
            result.add(Boolean.valueOf(true));
            result.add(min);
            result.add(max);
            GeostOptions cfr_ignored_1 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("/*debug*/LongestCommonInterval() returns " + result);
            }
            return result;
        }
        if (inIctr) {
            startingIctr = ictr;
            otherIctr = ictr2;
        } else {
            startingIctr = ictr2;
            otherIctr = ictr;
        }
        Point max = this.extend(p, d, k, jump, startingIctr, increase);
        Point min = new Point(max);
        if (!otherIctr.insideForbidden(max)) {
            result.add(Boolean.valueOf(false));
            result.add(min);
            result.add(max);
            GeostOptions cfr_ignored_2 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("/*debug*/LongestCommonInterval() returns " + result);
            }
            return result;
        }
        Region box = new Region(min);
        min.setCoord(d, GeometricKernel.max(p.getCoord(d), otherIctr.maximizeSizeOfFBox(!increase, d, k, box), increase));
        result.add(Boolean.valueOf(true));
        result.add(min);
        result.add(max);
        GeostOptions cfr_ignored_3 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("/*debug*/LongestCommonInterval() returns " + result);
        }
        return result;
    }

    boolean infeasibleTriangle(Point a, Point b, Point c, ForbiddenRegion ictr, int k) {
        GeostOptions cfr_ignored_0 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("/*debug*/InfeasibleTriangle(a=" + a + ", b=" + b + ", c=" + c + ", ictr=" + ictr + ", k=" + k + ')');
        }
        if (ictr instanceof DistGeqIC) {
            DistGeqIC dgeqic = (DistGeqIC)ictr;
            boolean r = dgeqic.insideForbidden(a) && dgeqic.insideForbidden(b) && dgeqic.insideForbidden(c);
            GeostOptions cfr_ignored_1 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("/*debug*/InfeasibleTriangle() returns " + r);
            }
            return r;
        }
        if (ictr instanceof DistLeqIC) {
            DistLeqIC dleqic = (DistLeqIC)ictr;
            boolean r = dleqic.insideForbidden(a) && dleqic.insideForbidden(b) && dleqic.insideForbidden(c) && dleqic.segInsideForbidden(a, b) && dleqic.segInsideForbidden(b, c) && dleqic.segInsideForbidden(c, a);
            GeostOptions cfr_ignored_2 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("/*debug*/InfeasibleTriangle() returns " + r);
            }
            return r;
        }
        throw new SolverException("GeometricKernel:InfeasibleTriangle():could not identify constraint.");
    }

    boolean checkBoxTriangle(Point Pra, Point Pdiag, Point h, Point f, ForbiddenRegion ictr, ForbiddenRegion ictr2) {
        int k = Pra.getCoords().length;
        return this.infeasibleTriangle(Pra, Pdiag, f, ictr, k) && this.infeasibleTriangle(h, Pdiag, f, ictr2, k);
    }

    static boolean infeasibleSegment(Point a, Point b, ForbiddenRegion ictr) {
        if (ictr instanceof DistLeqIC) {
            DistLeqIC dleqic = (DistLeqIC)ictr;
            boolean cond1 = dleqic.segInsideForbidden(a, b);
            return cond1;
        }
        if (ictr instanceof DistGeqIC) {
            DistGeqIC dgeqic = (DistGeqIC)ictr;
            boolean cond1 = dgeqic.insideForbidden(a, b);
            return cond1;
        }
        throw new SolverException("GeometricKernel:InfeasibleTriangle():could not identify constraint.");
    }

    Region findBoxTriangleDicho1(int d_prune, int d_dicho_ext, int d_dicho_int, int k, Point Pra, Point Pdiag, Point n, boolean increase, ForbiddenRegion ictr_pradiag, ForbiddenRegion ictr_pdiag, int pos_p) {
        GeostOptions cfr_ignored_0 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("/*debug*/FindBoxTriangleDicho1(d_prune=" + d_prune + ", d_dicho_ext=" + d_dicho_ext + ", d_dicho_int" + d_dicho_int + "=, k=" + k + ", Pra=" + Pra + ", Pdiag=" + Pdiag + ", n=" + n + ", increase=" + increase + ", ictr_pradiag=" + ictr_pradiag + ", ictr_pdiag=" + ictr_pdiag + ", pos_p=" + pos_p + ')');
        }
        if (!(ictr_pradiag.insideForbidden(Pra) && ictr_pradiag.insideForbidden(Pdiag) && ictr_pdiag.insideForbidden(Pdiag))) {
            throw new SolverException("Precondition of GeometricKernel.FindBoxTriangleDicho1() not verified. Pra in ictr_pradiag:" + ictr_pradiag.insideForbidden(Pra) + "; Pdiag in ictr_pradiag " + ictr_pradiag.insideForbidden(Pdiag) + "; Pdiag in ictr_pdiag:" + ictr_pdiag.insideForbidden(Pdiag));
        }
        boolean found_box = false;
        Point best_found = null;
        Point h = this.extend(Pdiag, d_dicho_int, k, n, ictr_pdiag, increase);
        List r = this.longestCommonInterval(d_dicho_int, k, Pra, ictr_pradiag, ictr_pdiag, h, increase);
        boolean found = (Boolean)r.get(0);
        Point low = (Point)r.get(1);
        Point up = (Point)r.get(2);
        if (!found) {
            GeostOptions cfr_ignored_1 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("/*debug*/FindBoxTriangleDicho1() returns null");
            }
            return null;
        }
        String laststr = "";
        do {
            Point cut = new Point(h);
            cut.setCoord(d_dicho_int, GeometricKernel.min(cut.getCoord(d_dicho_int), up.getCoord(d_dicho_int), increase));
            boolean upOk = this.checkBoxTriangle(Pra, Pdiag, cut, up, ictr_pradiag, ictr_pdiag);
            String upstr = MessageFormat.format("FindBoxTriangleDicho1:up:CheckBoxTriangle({0},{1},{2},{3},{4},{5},{6},{7}", Pra, Pdiag, cut, up, ictr_pradiag, ictr_pdiag, d_dicho_int, increase);
            cut = new Point(h);
            cut.setCoord(d_dicho_int, GeometricKernel.min(cut.getCoord(d_dicho_int), low.getCoord(d_dicho_int), increase));
            boolean lowOk = this.checkBoxTriangle(Pra, Pdiag, cut, low, ictr_pradiag, ictr_pdiag);
            String lowstr = MessageFormat.format("FindBoxTriangleDicho1:low:CheckBoxTriangle({0},{1},{2},{3},{4},{5},{6},{7}", Pra, Pdiag, cut, low, ictr_pradiag, ictr_pdiag, d_dicho_int, increase);
            Point mid = new Point(low);
            mid.setCoord(d_dicho_int, (low.getCoord(d_dicho_int) + up.getCoord(d_dicho_int)) / 2);
            cut = new Point(h);
            cut.setCoord(d_dicho_int, GeometricKernel.min(cut.getCoord(d_dicho_int), mid.getCoord(d_dicho_int), increase));
            boolean midOk = this.checkBoxTriangle(Pra, Pdiag, cut, mid, ictr_pradiag, ictr_pdiag);
            String midstr = MessageFormat.format("FindBoxTriangleDicho1:mid:CheckBoxTriangle({0},{1},{2},{3},{4},{5},{6},{7}", Pra, Pdiag, cut, mid, ictr_pradiag, ictr_pdiag, d_dicho_int, increase);
            if (!lowOk && !midOk && !upOk) break;
            if (upOk) {
                best_found = GeometricKernel.maxPt(up, best_found, d_dicho_int, found_box, increase);
                found_box = true;
                laststr = upstr;
                break;
            }
            if (midOk) {
                best_found = GeometricKernel.maxPt(mid, best_found, d_dicho_int, found_box, increase);
                found_box = true;
                low.setCoord(d_dicho_int, mid.getCoord(d_dicho_int) + GeometricKernel.succ(increase));
                laststr = midstr;
                continue;
            }
            if (!lowOk) continue;
            best_found = GeometricKernel.maxPt(low, best_found, d_dicho_int, found_box, increase);
            found_box = true;
            up.setCoord(d_dicho_int, mid.getCoord(d_dicho_int) + GeometricKernel.prev(increase));
            laststr = lowstr;
        } while ((!increase || low.getCoord(d_dicho_int) <= up.getCoord(d_dicho_int)) && (increase || low.getCoord(d_dicho_int) >= up.getCoord(d_dicho_int)));
        if (found_box) {
            Region result = GeometricKernel.buildBox(k, Pdiag, best_found);
            result.setType("diagonal");
            result.father = "FindBoxTriangleDicho1";
            result.info = laststr;
            GeostOptions cfr_ignored_2 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("/*debug*/FindBoxTriangleDicho1() returns " + result);
            }
            return result;
        }
        GeostOptions cfr_ignored_3 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("/*debug*/FindBoxTriangleDicho1() returns null");
        }
        return null;
    }

    Region findBoxTriangleDicho2(int d_prune, int d_dicho_ext, int d_dicho_int, int k, Point Pra, Point Pdiag, Point n, boolean increase, ForbiddenRegion ictr_pradiag, ForbiddenRegion ictr_pdiag, int pos_p) {
        GeostOptions cfr_ignored_0 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("/*debug*/FindBoxTriangleDicho2(d_prune=" + d_prune + ", d_dicho_ext=" + d_dicho_ext + ", d_dicho_int=" + d_dicho_int + ", k=" + k + ", Pra=" + Pra + ", Pdiag=" + Pdiag + ", n=" + n + ", increase=" + increase + ", ictr_pradiag=" + ictr_pradiag + ", ictr_pdiag=" + ictr_pdiag + ", pos_p=" + pos_p + ')');
        }
        if (!(ictr_pradiag.insideForbidden(Pra) && ictr_pradiag.insideForbidden(Pdiag) && ictr_pdiag.insideForbidden(Pdiag))) {
            throw new SolverException("Precondition of GeometricKernel.FindBoxTriangleDicho2() not verified.");
        }
        boolean case_a_or_c = GeometricKernel.min(Pra.getCoord(d_dicho_ext), Pdiag.getCoord(d_dicho_ext), increase) == Pra.getCoord(d_dicho_ext);
        Point low = new Point(Pdiag);
        Point up = this.extend(Pdiag, d_dicho_int, k, n, ictr_pdiag, increase);
        boolean found = false;
        Point best_found = null;
        boolean upOk = false;
        boolean lowOk = false;
        boolean midOk = false;
        String laststr = "";
        do {
            Point h_mid;
            String lowstr;
            Point h_low;
            String upstr;
            Point h_up;
            Point mid = new Point(low);
            mid.setCoord(d_dicho_int, (low.getCoord(d_dicho_int) + up.getCoord(d_dicho_int)) / 2);
            String midstr = null;
            if (case_a_or_c) {
                h_up = GeometricKernel.slidePt(Pra, d_dicho_int, up.getCoord(d_dicho_int));
                upOk = ictr_pradiag.insideForbidden(h_up) && ictr_pdiag.insideForbidden(h_up) && this.checkBoxTriangle(Pra, Pdiag, up, h_up, ictr_pradiag, ictr_pdiag);
                upstr = MessageFormat.format("FindBoxTriangleDicho2.1:up:CheckBoxTriangle({0},{1},{2},{3},{4},{5},{6},{7}", Pra, Pdiag, up, h_up, ictr_pradiag, ictr_pdiag, d_dicho_int, increase);
                h_low = GeometricKernel.slidePt(Pra, d_dicho_int, low.getCoord(d_dicho_int));
                lowOk = ictr_pradiag.insideForbidden(h_low) && ictr_pdiag.insideForbidden(h_low) && this.checkBoxTriangle(Pra, Pdiag, low, h_low, ictr_pradiag, ictr_pdiag);
                lowstr = MessageFormat.format("FindBoxTriangleDicho2.1:low:CheckBoxTriangle({0},{1},{2},{3},{4},{5},{6},{7}", Pra, Pdiag, low, h_low, ictr_pradiag, ictr_pdiag, d_dicho_int, increase);
                h_mid = GeometricKernel.slidePt(Pra, d_dicho_int, mid.getCoord(d_dicho_int));
                midOk = ictr_pradiag.insideForbidden(h_mid);
                midOk = midOk && ictr_pdiag.insideForbidden(h_mid);
                midOk = midOk && this.checkBoxTriangle(Pra, Pdiag, mid, h_mid, ictr_pradiag, ictr_pdiag);
                midstr = MessageFormat.format("FindBoxTriangleDicho2.1:mid:CheckBoxTriangle({0},{1},{2},{3},{4},{5},{6},{7}={8}", Pra, Pdiag, mid, h_mid, ictr_pradiag, ictr_pdiag, d_dicho_int, increase, midOk);
            } else {
                h_up = this.extend(up, d_dicho_ext, k, n, ictr_pdiag, increase);
                Point p = GeometricKernel.slidePt(Pra, d_dicho_ext, h_up.getCoord(d_dicho_ext));
                upOk = ictr_pradiag.insideForbidden(p) && ictr_pradiag.insideForbidden(h_up) && this.checkBoxTriangle(p, Pdiag, up, h_up, ictr_pradiag, ictr_pdiag);
                upstr = String.format("FindBoxTriangleDicho2.2:up:CheckBoxTriangle(%s,%s,%s,%s,%s,%s,%d,%s", p, Pdiag, up, h_up, ictr_pradiag, ictr_pdiag, d_dicho_int, increase);
                h_low = this.extend(low, d_dicho_ext, k, n, ictr_pdiag, increase);
                p = GeometricKernel.slidePt(Pra, d_dicho_ext, h_low.getCoord(d_dicho_ext));
                lowOk = ictr_pradiag.insideForbidden(p) && ictr_pradiag.insideForbidden(h_low) && this.checkBoxTriangle(p, Pdiag, low, h_low, ictr_pradiag, ictr_pdiag);
                lowstr = String.format("FindBoxTriangleDicho2.2:low:CheckBoxTriangle(%s,%s,%s,%s,%s,%s,%d,%s", p, Pdiag, low, h_low, ictr_pradiag, ictr_pdiag, d_dicho_int, increase);
                h_mid = this.extend(mid, d_dicho_ext, k, n, ictr_pdiag, increase);
                p = GeometricKernel.slidePt(Pra, d_dicho_ext, h_mid.getCoord(d_dicho_ext));
                midOk = ictr_pradiag.insideForbidden(p) && ictr_pradiag.insideForbidden(h_mid) && this.checkBoxTriangle(p, Pdiag, mid, h_mid, ictr_pradiag, ictr_pdiag);
                midstr = String.format("FindBoxTriangleDicho2.2:mid:CheckBoxTriangle(%s,%s,%s,%s,%s,%s,%d,%s", p, Pdiag, mid, h_mid, ictr_pradiag, ictr_pdiag, d_dicho_int, increase);
            }
            if (!lowOk && !midOk && !upOk) break;
            if (upOk) {
                best_found = GeometricKernel.maxPt(h_up, best_found, d_dicho_int, found, increase);
                found = true;
                laststr = upstr;
                break;
            }
            if (midOk) {
                best_found = GeometricKernel.maxPt(h_mid, best_found, d_dicho_int, found, increase);
                found = true;
                low.setCoord(d_dicho_int, mid.getCoord(d_dicho_int) + GeometricKernel.succ(increase));
                laststr = midstr;
                continue;
            }
            best_found = GeometricKernel.maxPt(h_low, best_found, d_dicho_int, found, increase);
            found = true;
            up.setCoord(d_dicho_int, mid.getCoord(d_dicho_int) + GeometricKernel.prev(increase));
            laststr = lowstr;
        } while ((!increase || low.getCoord(d_dicho_int) <= up.getCoord(d_dicho_int)) && (increase || low.getCoord(d_dicho_int) >= up.getCoord(d_dicho_int)));
        if (found) {
            Region result = GeometricKernel.buildBox(k, Pdiag, best_found);
            result.setType("diagonal");
            result.father = "FindBoxTriangleDicho2";
            result.info = laststr;
            result.case_a_or_c = case_a_or_c;
            GeostOptions cfr_ignored_1 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("/*debug*/FindBoxTriangleDicho2() returns " + result);
            }
            return result;
        }
        GeostOptions cfr_ignored_2 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("/*debug*/FindBoxTriangleDicho2() returns null");
        }
        return null;
    }

    Region findBoxTriangleDicho(int d_prune, int d_dicho_ext, int d_dicho_int, int k, Point Pra, Point Pdiag, Point n, boolean increase, ForbiddenRegion ictr_pradiag, ForbiddenRegion ictr_pdiag, int pos_p) {
        if (!ictr_pdiag.insideForbidden(Pdiag)) {
            throw new SolverException("GeometricKernel:FindBoxTriangleDicho():Pdiag not in ictr_pdiag");
        }
        Region b1 = this.findBoxTriangleDicho1(d_prune, d_dicho_ext, d_dicho_int, k, Pra, Pdiag, n, increase, ictr_pradiag, ictr_pdiag, pos_p);
        Region b2 = this.findBoxTriangleDicho2(d_prune, d_dicho_ext, d_dicho_int, k, Pra, Pdiag, n, increase, ictr_pradiag, ictr_pdiag, pos_p);
        return this.selectionCriteria(d_prune, k, increase, b1, b2);
    }

    Region checkTriangleDDicho(int d_prune, int d_dicho_ext, int d_dicho_int, int k, Point Pra, Point Pdiag, Point n, boolean increase, ForbiddenRegion ictr_pradiag, ForbiddenRegion ictr_pdiag, int pos_p, int mid) {
        GeostOptions cfr_ignored_0 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("/*debug*/CheckTriangleDDicho(d_prune=" + d_prune + ", d_dicho_ext=" + d_dicho_ext + ", d_dicho_int=" + d_dicho_int + ", k=" + k + ", Pra=" + Pra + ", Pdiag=" + Pdiag + ", n=" + n + ", increase=" + increase + ", ictr_pradiag=" + ictr_pradiag + ", ictr_pdiag=" + ictr_pdiag + ", pos_p=" + pos_p + ", mid=" + mid + ')');
        }
        Region box = null;
        ForbiddenRegion ictr = null;
        Point P = null;
        if (GeometricKernel.min(Pra.getCoord(d_dicho_ext), Pdiag.getCoord(d_dicho_ext), increase) == Pra.getCoord(d_dicho_ext)) {
            P = new Point(Pra);
            Point Qra = GeometricKernel.slidePt(Pra, d_dicho_ext, mid);
            ictr = ictr_pradiag;
            if (!ictr_pdiag.insideForbidden(Pdiag)) {
                throw new SolverException("GeometricKernel:CheckTriangleDDicho():Pdiag not in ictr_pdiag for m=2 (2)");
            }
            box = this.findBoxTriangleDicho(d_prune, d_dicho_ext, d_dicho_int, k, Qra, Pdiag, n, increase, ictr_pradiag, ictr_pdiag, pos_p);
        } else {
            P = new Point(Pdiag);
            Point Qdiag = GeometricKernel.slidePt(Pdiag, d_dicho_ext, mid);
            ictr = ictr_pdiag;
            if (!ictr_pdiag.insideForbidden(Qdiag)) {
                throw new SolverException("GeometricKernel:CheckTriangleDDicho():Qdiag not in ictr_pdiag for m=2 (2)");
            }
            box = this.findBoxTriangleDicho(d_prune, d_dicho_ext, d_dicho_int, k, Pra, Qdiag, n, increase, ictr_pradiag, ictr_pdiag, pos_p);
        }
        if (box != null) {
            Region check_box = new Region(P);
            if (increase) {
                if (box.getMinimumBoundary(d_dicho_ext) != P.getCoord(d_dicho_ext)) {
                    check_box.setMaximumBoundary(d_dicho_ext, mid - 1);
                    check_box.setMaximumBoundary(d_dicho_int, ictr.maximizeSizeOfFBox(increase, d_dicho_int, k, check_box));
                    if (check_box.getMaximumBoundary(d_dicho_int) >= box.getMaximumBoundary(d_dicho_int)) {
                        box.setMinimumBoundary(d_dicho_ext, P.getCoord(d_dicho_ext));
                    } else {
                        box = null;
                    }
                }
            } else if (box.getMaximumBoundary(d_dicho_ext) != P.getCoord(d_dicho_ext)) {
                check_box.setMinimumBoundary(d_dicho_ext, mid + 1);
                check_box.setMinimumBoundary(d_dicho_int, ictr.maximizeSizeOfFBox(increase, d_dicho_int, k, check_box));
                if (check_box.getMinimumBoundary(d_dicho_int) <= box.getMinimumBoundary(d_dicho_int)) {
                    box.setMaximumBoundary(d_dicho_ext, P.getCoord(d_dicho_ext));
                } else {
                    box = null;
                }
            }
        }
        GeostOptions cfr_ignored_1 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("/*debug*/CheckTriangleDDicho() returns " + box);
        }
        return box;
    }

    Region findBoxTriangleDDicho(int d_prune, int d_dicho_ext, int d_dicho_int, int k, Point Pra, Point Pdiag, Point n, boolean increase, ForbiddenRegion ictr_pradiag, ForbiddenRegion ictr_pdiag, int pos_p) {
        GeostOptions cfr_ignored_0 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("/*debug*/FindBoxTriangleDDicho(int d_prune=" + d_prune + ", int d_dicho_ext=" + d_dicho_ext + ", int d_dicho_int=" + d_dicho_int + ", int k=" + k + ", Point Pra=" + Pra + ", Point Pdiag=" + Pdiag + ", Point n=" + n + ",boolean increase=" + increase + ", ForbiddenRegion ictr_pradiag=" + ictr_pradiag + ", ForbiddenRegion ictr_pdiag=" + ictr_pdiag + ", int pos_p=" + pos_p + ')');
        }
        Pdiag = new Point(Pdiag);
        Region best_box = null;
        if (!ictr_pdiag.insideForbidden(Pdiag)) {
            throw new SolverException("GeometricKernel:FindBoxTriangleDDicho():Pdiag not in ictr_pdiag init");
        }
        Region best_sem = this.findBoxTriangleDicho(d_prune, d_dicho_ext, d_dicho_int, k, Pra, Pdiag, n, increase, ictr_pradiag, ictr_pdiag, pos_p);
        boolean CASE_A_OR_C = GeometricKernel.min(Pra.getCoord(d_dicho_ext), Pdiag.getCoord(d_dicho_ext), increase) == Pra.getCoord(d_dicho_ext);
        boolean minimize = false;
        if (best_sem != null) {
            best_sem.setType("diagonal");
        }
        int low = 0;
        int up = 0;
        for (int m = 1; m <= 2; ++m) {
            if (m == 2 && CASE_A_OR_C) {
                if (!ictr_pdiag.insideForbidden(Pdiag)) {
                    throw new SolverException("GeometricKernel:FindBoxTriangleDDicho():Pdiag not in ictr_pdiag for m=2aaaaaaa");
                }
                Point Pdiag_initial = new Point(Pdiag);
                int pos = ictr_pdiag.maximizeSizeOfFBox(!increase, d_dicho_ext, k, new Region(Pdiag));
                Pdiag.setCoord(d_dicho_ext, GeometricKernel.max(Pra.getCoord(d_dicho_ext), pos, increase));
                if (!ictr_pdiag.insideForbidden(Pdiag)) {
                    throw new SolverException("GeometricKernel:FindBoxTriangleDDicho():Pdiag not in ictr_pdiag for m=2 increase=" + increase + " d_dicho_ext=" + d_dicho_ext + " Pra=" + Pra + ' ' + " Pdiaginit:" + Pdiag_initial + ' ' + Pdiag + " maxSize=" + ictr_pdiag.maximizeSizeOfFBox(!increase, d_dicho_ext, k, new Region(Pdiag)));
                }
            }
            if (!CASE_A_OR_C && m != 1) continue;
            int mid = -1;
            minimize = false;
            do {
                minimize ^= true;
                best_box = null;
                mid = -1;
                if (CASE_A_OR_C) {
                    low = Pra.getCoord(d_dicho_ext);
                    up = Pdiag.getCoord(d_dicho_ext);
                } else {
                    low = Pdiag.getCoord(d_dicho_ext);
                    up = GeometricKernel.min(Pra.getCoord(d_dicho_ext), ictr_pdiag.maximizeSizeOfFBox(increase, d_dicho_ext, k, new Region(Pdiag)), increase);
                }
                int low_prev = low;
                int up_prev = up;
                do {
                    if (!(increase && low >= low_prev && up <= up_prev || !increase && up >= up_prev && low <= low_prev)) {
                        throw new SolverException("GeometricKernel:FindBoxTriangleDDicho():invariant1");
                    }
                    if (Math.abs(up_prev - low_prev) < Math.abs(up - low)) {
                        throw new SolverException("GeometricKernel:FindBoxTriangleDDicho():invariant2");
                    }
                    low_prev = low;
                    up_prev = up;
                    mid = (low + up) / 2;
                    if (!ictr_pdiag.insideForbidden(Pdiag)) {
                        throw new SolverException("GeometricKernel:FindBoxTriangleDDicho():Pdiag not in ictr_pdiag for m=2 (2)");
                    }
                    Region box = this.checkTriangleDDicho(d_prune, d_dicho_ext, d_dicho_int, k, Pra, Pdiag, n, increase, ictr_pradiag, ictr_pdiag, pos_p, mid);
                    if (box != null) {
                        box.setType("diagonal+rect");
                        box.mid = mid;
                        box.dicho_ext = d_dicho_ext;
                        box.dicho_int = d_dicho_int;
                    }
                    if (box != null && box.getType().equals("diagonal+rect")) {
                        boolean d2_in_both_inv;
                        int i;
                        Region cbox = new Region(box);
                        if (cbox.mid == -1) {
                            throw new SolverException("GeometricKernel:FinxBoxTriangleDDicho():box.mid is -1.Pra:" + Pra + " Pdiag:" + Pdiag + " increase:" + increase + " CASE_A_OR_C:" + CASE_A_OR_C + " m:" + m + ' ' + cbox + ' ' + cbox.father + ' ' + ictr_pdiag + ' ' + ictr_pradiag);
                        }
                        if (cbox.mid < cbox.getMinimumBoundary(cbox.dicho_ext) || cbox.mid > cbox.getMaximumBoundary(cbox.dicho_ext)) {
                            throw new SolverException("GeometricKernel:FinxBoxTriangleDDicho():box.mid is outside box. Pra:" + Pra + " Pdiag:" + Pdiag + " increase:" + increase + " CASE_A_OR_C:" + CASE_A_OR_C + " m:" + m + ' ' + cbox + ' ' + cbox.father + " mid:" + cbox.mid + ' ' + ictr_pdiag + ' ' + ictr_pradiag);
                        }
                        Region dbox = new Region(box);
                        if (increase) {
                            dbox.setMinimumBoundary(dbox.dicho_ext, mid);
                        } else {
                            dbox.setMaximumBoundary(dbox.dicho_ext, mid);
                        }
                        Point p1 = new Point(2);
                        Point p2 = new Point(2);
                        for (i = 0; i < k; ++i) {
                            if (increase) {
                                p1.setCoord(i, dbox.getMinimumBoundary(i));
                                continue;
                            }
                            p1.setCoord(i, dbox.getMaximumBoundary(i));
                        }
                        for (i = 0; i < k; ++i) {
                            if (increase) {
                                p2.setCoord(i, dbox.getMaximumBoundary(i));
                                continue;
                            }
                            p2.setCoord(i, dbox.getMinimumBoundary(i));
                        }
                        Point p3 = new Point(2);
                        Point p4 = new Point(2);
                        if (increase) {
                            p3.setCoord(dbox.dicho_ext, dbox.getMinimumBoundary(dbox.dicho_ext));
                            p3.setCoord(dbox.dicho_int, dbox.getMaximumBoundary(dbox.dicho_int));
                            p4.setCoord(dbox.dicho_ext, dbox.getMaximumBoundary(dbox.dicho_ext));
                            p4.setCoord(dbox.dicho_int, dbox.getMinimumBoundary(dbox.dicho_int));
                        } else {
                            p3.setCoord(dbox.dicho_ext, dbox.getMaximumBoundary(dbox.dicho_ext));
                            p3.setCoord(dbox.dicho_int, dbox.getMinimumBoundary(dbox.dicho_int));
                            p4.setCoord(dbox.dicho_ext, dbox.getMinimumBoundary(dbox.dicho_ext));
                            p4.setCoord(dbox.dicho_int, dbox.getMaximumBoundary(dbox.dicho_int));
                        }
                        boolean d1_in_both = GeometricKernel.infeasibleSegment(p1, p2, ictr_pdiag) && GeometricKernel.infeasibleSegment(p1, p2, ictr_pradiag);
                        boolean d1_in_both_inv = GeometricKernel.infeasibleSegment(p2, p1, ictr_pdiag) && GeometricKernel.infeasibleSegment(p2, p1, ictr_pradiag);
                        boolean d2_in_both = GeometricKernel.infeasibleSegment(p3, p4, ictr_pdiag) && GeometricKernel.infeasibleSegment(p3, p4, ictr_pradiag);
                        boolean bl = d2_in_both_inv = GeometricKernel.infeasibleSegment(p4, p3, ictr_pdiag) && GeometricKernel.infeasibleSegment(p4, p3, ictr_pradiag);
                        if (d1_in_both != d1_in_both_inv) {
                            StringBuilder st = new StringBuilder(128);
                            st.append("GeometricKernel:FinxBoxTriangleDDicho():(!(d1_in_both==d1_in_both_inv))");
                            st.append("Pra:").append(Pra).append(" Pdiag:").append(Pdiag).append(" increase:").append(increase).append(" CASE_A_OR_C:").append(CASE_A_OR_C).append(" m:").append(m).append(" cbox:").append(cbox).append(" dbox:").append(dbox).append(" dicho_ext:").append(dbox.dicho_ext).append(" info:").append(cbox.father).append(" mid:").append(cbox.mid).append(' ').append(ictr_pdiag).append(' ').append(ictr_pradiag);
                            st.append("d1_in_both:").append(d1_in_both).append(" d1_in_both_inv:").append(d1_in_both_inv).append(" d2_in_both:").append(d2_in_both).append(" d2_in_both_inv:").append(d2_in_both_inv);
                            st.append("p1:").append(p1).append(" p2:").append(p2).append(" p3:").append(p3).append(" p4:").append(p4);
                            throw new SolverException(st.toString());
                        }
                        if (d2_in_both != d2_in_both_inv) {
                            StringBuilder st = new StringBuilder(128);
                            st.append("GeometricKernel:FinxBoxTriangleDDicho():(!(d2_in_both==d2_in_both_inv))");
                            st.append("Pra:").append(Pra).append(" Pdiag:").append(Pdiag).append(" increase:").append(increase).append(" CASE_A_OR_C:").append(CASE_A_OR_C).append(" m:").append(m).append(" cbox:").append(cbox).append(" dbox:").append(dbox).append(" dicho_ext:").append(dbox.dicho_ext).append(" info:").append(cbox.father).append(" mid:").append(cbox.mid).append(' ').append(ictr_pdiag).append(' ').append(ictr_pradiag);
                            st.append("d1_in_both:").append(d1_in_both).append(" d1_in_both_inv:").append(d1_in_both_inv).append(" d2_in_both:").append(d2_in_both).append(" d2_in_both_inv:").append(d2_in_both_inv);
                            st.append("p1:").append(p1).append(" p2:").append(p2).append(" p3:").append(p3).append(" p4:").append(p4);
                            st.append("InfeasibleSegment(").append(p3).append(',').append(p4).append(',').append(ictr_pdiag).append(")):").append(GeometricKernel.infeasibleSegment(p3, p4, ictr_pdiag)).append(" && (InfeasibleSegment(").append(p3).append(',').append(p4).append(',').append(ictr_pradiag).append("):").append(GeometricKernel.infeasibleSegment(p3, p4, ictr_pradiag)).append(')');
                            st.append("InfeasibleSegment(").append(p4).append(',').append(p3).append(',').append(ictr_pdiag).append(")):").append(GeometricKernel.infeasibleSegment(p4, p3, ictr_pdiag)).append(" && (InfeasibleSegment(").append(p4).append(',').append(p3).append(',').append(ictr_pradiag).append("):").append(GeometricKernel.infeasibleSegment(p4, p3, ictr_pradiag)).append(')');
                            st.append('1');
                            st.append('2');
                            throw new SolverException(st.toString());
                        }
                        if (!d1_in_both && !d2_in_both) {
                            StringBuilder st = new StringBuilder(128);
                            st.append("GeometricKernel:FinxBoxTriangleDDicho():(!(d1_in_both || d2_in_both))");
                            st.append("Pra:").append(Pra).append(" Pdiag:").append(Pdiag).append(" increase:").append(increase).append(" CASE_A_OR_C:").append(CASE_A_OR_C).append(" m:").append(m).append(" cbox:").append(cbox).append(" dbox:").append(dbox).append(" dicho_ext:").append(dbox.dicho_ext).append(" info:").append(cbox.info).append(" father:").append(cbox.father).append(" mid:").append(cbox.mid).append(' ').append(ictr_pdiag).append(' ').append(ictr_pradiag);
                            st.append("d1_in_both:").append(d1_in_both).append(" d1_in_both_inv:").append(d1_in_both_inv).append(" d2_in_both:").append(d2_in_both).append(" d2_in_both_inv:").append(d2_in_both_inv);
                            st.append("p1:").append(p1).append(" p2:").append(p2).append(" p3:").append(p3).append(" p4:").append(p4);
                            throw new SolverException(st.toString());
                        }
                    }
                    if (box != null) {
                        best_box = this.selectionCriteria(d_prune, k, increase, best_box, box);
                    }
                    if (box != null == minimize) {
                        up = mid + GeometricKernel.prev(increase);
                        continue;
                    }
                    low = mid + GeometricKernel.succ(increase);
                } while ((!increase || low <= up) && (increase || low >= up));
                best_sem = this.selectionCriteria(d_prune, k, increase, best_sem, best_box);
            } while (minimize);
        }
        if (best_sem != null) {
            best_sem.dicho_ext = d_dicho_ext;
            best_sem.dicho_int = d_dicho_int;
            best_sem.orientation = CASE_A_OR_C ? 0 : 1;
            best_sem.case_a_or_c = CASE_A_OR_C;
        }
        GeostOptions cfr_ignored_1 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("/*debug*/FindBoxTriangleDDicho() returns " + best_sem);
        }
        return best_sem;
    }

    static boolean feasiblePtInRegion() {
        return false;
    }

    static boolean nextPtIsFree(Point p, int d, Obj o, List<InternalConstraint> ictrs, boolean increase) {
        Point g_prime = new Point(p);
        g_prime.setCoord(d, g_prime.getCoord(d) + GeometricKernel.succ(increase));
        return o.isInside(g_prime) && GeometricKernel.isFeasible(g_prime, ictrs);
    }

    /*
     * Unable to fully structure code
     */
    Pair<Boolean, Region> getDeltaFR(int d_prune, int k, Obj o, Point c, Point n, List<InternalConstraint> ictrs, boolean increase, int delta_prune, int mode) {
        if (mode == 1) ** GOTO lbl-1000
        this.stp.opt;
        if (GeostOptions.singleboxonly) lbl-1000:
        // 2 sources

        {
            p = this.getDeltaFRSingle(d_prune, k, o, c, n, ictrs, increase, delta_prune);
            infeasible = (Boolean)p.fst;
            b = (Region)p.snd;
            if (!infeasible) {
                return p;
            }
        } else {
            p = this.getDeltaFRMultiple(d_prune, k, o, c, n, ictrs, increase, delta_prune);
            infeasible = (Boolean)p.fst;
            b = (Region)p.snd;
            if (!infeasible) {
                return p;
            }
            c_prime = new Point(c);
            d_least = (k - 1 + d_prune) % k;
            if (increase) {
                c_prime.setCoord(d_least, b.getMaximumBoundary(d_least) + 1);
            } else {
                c_prime.setCoord(d_least, b.getMinimumBoundary(d_least) - 1);
            }
            c_prime_prime = new Point(c);
            if (increase) {
                c_prime_prime.setCoord(d_least, b.getMaximumBoundary(d_least));
            } else {
                c_prime_prime.setCoord(d_least, b.getMinimumBoundary(d_least));
            }
            GeometricKernel.setOfCstrsOnPt(c_prime, ictrs);
            if (b.getMaximumBoundary(d_least) - b.getMinimumBoundary(d_least) >= 2 && (increase && c_prime.getCoord(d_least) <= o.getCoord(d_least).getSup() || !increase && c_prime.getCoord(d_least) >= o.getCoord(d_least).getInf()) && GeometricKernel.nbrOfCstrsOnPt(c_prime, ictrs) == 1 && GeometricKernel.nbrOfCstrsOnPt(c_prime_prime, ictrs) > 1) {
                if (increase) {
                    b.setMaximumBoundary(d_least, b.getMaximumBoundary(d_least) - 1);
                } else {
                    b.setMinimumBoundary(d_least, b.getMinimumBoundary(d_least) + 1);
                }
            }
        }
        this.stp.opt;
        if (GeostOptions.debug) {
            GeometricKernel.LOGGER.info("best_b:" + b);
            GeometricKernel.LOGGER.info("/*example*/b:" + b);
        }
        this.writeBox(b, increase, false);
        if (b.father.indexOf("GreedyPoint") != -1) {
            this.stp.opt;
            if (GeostOptions.debug) {
                GeometricKernel.LOGGER.info("*** box:" + b + ";b.father:" + b.father + ";b.mid:" + b.mid + ";b.info:" + b.info + ";b.case_a_or_c:" + b.case_a_or_c + ";b.dicho_ext:" + b.dicho_ext + ";volume:" + b.volume() + ";c=" + c + ";increase=" + increase);
            }
        }
        return new Pair<Boolean, Region>(true, b);
    }

    Pair<Boolean, Region> getDeltaFRSingle(int d_prune, int k, Obj o, Point c, Point n, List<InternalConstraint> ictrs, boolean increase, int delta_prune) {
        int d_least;
        GeostOptions cfr_ignored_0 = this.stp.opt;
        if (GeostOptions.processing) {
            LOGGER.info("\n/*Processing*/sweep_point(" + c.getCoord(0) + ',' + c.getCoord(1) + ");");
        }
        if ((d_least = (k - 1 + d_prune) % k) < 0) {
            d_least += k;
        }
        int d_prev_least = (k - 2 + d_prune) % k;
        if (d_least < 0) {
            d_prev_least += k;
        }
        Region best_greedy = null;
        int pos_p = 0;
        List<ForbiddenRegion> C_c = GeometricKernel.setOfCstrsOnPt(c, ictrs);
        GeostOptions cfr_ignored_1 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("Set Of Cstrs On c:");
            for (ForbiddenRegion fr : C_c) {
                LOGGER.info(fr + " ");
            }
        }
        if (C_c.isEmpty()) {
            return new Pair<Boolean, Object>(false, null);
        }
        for (ForbiddenRegion ictr_c : C_c) {
            Point g = this.extend(c, d_least, k, n, ictr_c, increase);
            if (GeometricKernel.nextPtIsFree(g, d_least, o, ictrs, increase)) {
                Region box = GeometricKernel.buildBox(k, c, g);
                box.setType("single");
                return new Pair<Boolean, Region>(true, box);
            }
            Region box_greedy = GeometricKernel.getGreedyBoxFromPoint(d_prune, k, c, n, ictr_c, increase, pos_p);
            if (box_greedy != null) {
                box_greedy.setType("single");
            }
            this.writeBox(box_greedy, increase, true);
            best_greedy = this.selectionCriteria(d_prune, k, increase, box_greedy, best_greedy);
        }
        GeostOptions cfr_ignored_2 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("/*example*/returns (true," + best_greedy + ')');
        }
        return new Pair<Boolean, Object>(true, best_greedy);
    }

    Pair<Boolean, Region> getDeltaFRMultiple(int d_prune, int k, Obj o, Point c, Point n, List<InternalConstraint> ictrs, boolean increase, int delta_prune) {
        GeostOptions cfr_ignored_0 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("/*debug*/GetDeltaFRMultiple(d_prune=" + d_prune + ", k=" + k + ", o=" + o + ", c=" + c + ", n=" + n + ", ictrs=" + ictrs + ", increase=" + increase + ", delta_prune=" + delta_prune + ')');
        }
        GeostOptions cfr_ignored_1 = this.stp.opt;
        if (GeostOptions.processing) {
            LOGGER.info("\n/*Processing*/sweep_point(" + c.getCoord(0) + ',' + c.getCoord(1) + ");");
        }
        List<ForbiddenRegion> C_c = GeometricKernel.setOfCstrsOnPt(c, ictrs);
        GeostOptions cfr_ignored_2 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("Set Of Cstrs On c:");
            for (ForbiddenRegion fr : C_c) {
                LOGGER.info(fr + " ");
            }
        }
        if (C_c.isEmpty()) {
            GeostOptions cfr_ignored_3 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("/*debug*/GetDeltaFRMultiple() returns (false,null)");
            }
            return new Pair<Boolean, Object>(false, null);
        }
        int d_least = (k - 1 + d_prune) % k;
        if (d_least < 0) {
            d_least += k;
        }
        int d_prev_least = (k - 2 + d_prune) % k;
        if (d_least < 0) {
            d_prev_least += k;
        }
        Region best_box = null;
        int pos_p = 0;
        for (ForbiddenRegion ictr_c : C_c) {
            Point g = this.extend(c, d_least, k, n, ictr_c, increase);
            if (GeometricKernel.nextPtIsFree(g, d_least, o, ictrs, increase)) {
                Region box = GeometricKernel.buildBox(k, c, g);
                box.setType("single");
                GeostOptions cfr_ignored_4 = this.stp.opt;
                if (GeostOptions.debug) {
                    LOGGER.info("/*debug*/GetDeltaFRMultiple() returns (true" + box + ')');
                }
                return new Pair<Boolean, Region>(true, box);
            }
            Point gpl = this.extend(c, d_prev_least, k, n, ictr_c, increase);
            List<ForbiddenRegion> C_g = GeometricKernel.setOfCstrsOnPt(g, ictrs);
            if (C_g.size() > 1) {
                GeostOptions cfr_ignored_5 = this.stp.opt;
                if (GeostOptions.firstTimeGetDeltaFR) {
                    GeostOptions cfr_ignored_6 = this.stp.opt;
                    GeostOptions.firstTimeGetDeltaFR = false;
                    LOGGER.info("Relevant.");
                }
            }
            for (ForbiddenRegion ictr_g : C_g) {
                if (ictr_g == ictr_c) continue;
                Region box_inter = null;
                GeostOptions cfr_ignored_7 = this.stp.opt;
                if (GeostOptions.useinterbox) {
                    box_inter = this.findBoxInter(d_prune, d_least, d_prev_least, k, c, g, n, increase, ictr_c, ictr_g, pos_p);
                }
                if (box_inter != null) {
                    box_inter.setType("inter_in");
                }
                this.writeBox(box_inter, increase, true);
                best_box = this.selectionCriteria(d_prune, k, increase, best_box, box_inter);
                GeostOptions cfr_ignored_8 = this.stp.opt;
                if (GeostOptions.processing) {
                    LOGGER.info("/*Processing*///Dicho1");
                }
                if (!ictr_g.insideForbidden(g)) {
                    throw new SolverException("GeometricKernel:GetBestFR():g not in ictr_g");
                }
                Region box_tri = this.findBoxTriangleDDicho(d_prune, d_least, d_prev_least, k, c, g, n, increase, ictr_c, ictr_g, pos_p);
                this.writeBox(box_tri, increase, true);
                best_box = this.selectionCriteria(d_prune, k, increase, best_box, box_tri);
            }
            List<ForbiddenRegion> C_gpl = GeometricKernel.setOfCstrsOnPt(gpl, ictrs);
            if (C_gpl.size() > 1) {
                GeostOptions cfr_ignored_9 = this.stp.opt;
                if (GeostOptions.firstTimeGetDeltaFR) {
                    GeostOptions cfr_ignored_10 = this.stp.opt;
                    GeostOptions.firstTimeGetDeltaFR = false;
                    LOGGER.info("Relevant.");
                }
            }
            for (ForbiddenRegion ictr_gpl : C_gpl) {
                if (ictr_gpl == ictr_c) continue;
                Region box_inter = null;
                box_inter.setType("inter_in");
                this.writeBox(box_inter, increase, true);
                best_box = this.selectionCriteria(d_prune, k, increase, best_box, box_inter);
                if (!ictr_gpl.insideForbidden(gpl)) {
                    throw new SolverException("GeometricKernel:GetBestFR():gpl not in ictr_gpl");
                }
                Region box_tri = this.findBoxTriangleDDicho(d_prune, d_prev_least, d_least, k, c, gpl, n, increase, ictr_c, ictr_gpl, pos_p);
                this.writeBox(box_tri, increase, true);
                best_box = this.selectionCriteria(d_prune, k, increase, best_box, box_tri);
            }
            for (ForbiddenRegion ictr_c_prime : C_c) {
                if (ictr_c == ictr_c_prime) continue;
                GeostOptions cfr_ignored_11 = this.stp.opt;
                if (GeostOptions.processing) {
                    LOGGER.info("/*Processing*///Dicho3");
                }
                Region box = this.findBoxTriangleDDicho(d_prune, d_least, d_prev_least, k, g, c, n, increase, ictr_c, ictr_c_prime, pos_p);
                this.writeBox(box, increase, true);
                best_box = this.selectionCriteria(d_prune, k, increase, best_box, box);
                GeostOptions cfr_ignored_12 = this.stp.opt;
                if (GeostOptions.processing) {
                    LOGGER.info("/*Processing*///Dicho4");
                }
                if (!ictr_c_prime.insideForbidden(c)) {
                    throw new SolverException("GeometricKernel:GetBestFR():c not in ictr_c_prime");
                }
                box = this.findBoxTriangleDDicho(d_prune, d_prev_least, d_least, k, gpl, c, n, increase, ictr_c, ictr_c_prime, pos_p);
                this.writeBox(box, increase, true);
                best_box = this.selectionCriteria(d_prune, k, increase, best_box, box);
            }
            Region box_greedy = GeometricKernel.getGreedyBoxFromPoint(d_prune, k, c, n, ictr_c, increase, pos_p);
            if (box_greedy != null) {
                box_greedy.setType("single");
            }
            this.writeBox(box_greedy, increase, true);
            best_box = this.selectionCriteria(d_prune, k, increase, best_box, box_greedy);
            if (d_prev_least != d_prune && k == 2) {
                LOGGER.info("GeometricKernel:GetDeltaFRMultiple():invariant (d_prev_least!=d_prune) && (k==2)");
            }
            Region box_vector = null;
            GeostOptions cfr_ignored_13 = this.stp.opt;
            if (GeostOptions.usevectorbox) {
                box_vector = GeometricKernel.getGreedyBoxFromJumpVector(d_prev_least, d_prune, k, c, n, n.getCoord(d_prev_least), ictr_c, increase, pos_p);
            }
            if (box_vector != null) {
                box_vector.setType("vector");
            }
            this.writeBox(box_vector, increase, true);
            best_box = this.selectionCriteria(d_prune, k, increase, best_box, box_vector);
        }
        GeostOptions cfr_ignored_14 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("best_box:" + best_box);
        }
        GeostOptions cfr_ignored_15 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("/*debug*/GetDeltaFRMultiple() returns (true," + best_box + ')');
        }
        return new Pair<Boolean, Object>(true, best_box);
    }

    static boolean compareAndChooseBox(int d_prune, int k, boolean increase, Region box, Region best_box) {
        return GeometricKernel.largestInverseLex(d_prune, k, increase, box, best_box);
    }

    void writeBox(Region chosen_box, boolean increase, boolean temp) {
        GeostOptions cfr_ignored_0 = this.stp.opt;
        if (GeostOptions.processing) {
            String function = "";
            function = temp ? "fr_temp" : "fr";
            if (chosen_box != null) {
                if (!chosen_box.getType().equals("diagonal+rect")) {
                    LOGGER.info("\n/*Processing*/" + function + '(' + chosen_box.getMinimumBoundary(0) + ',' + chosen_box.getMaximumBoundary(0) + ',' + chosen_box.getMinimumBoundary(1) + ',' + chosen_box.getMaximumBoundary(1) + ",\"" + chosen_box.getType() + "\",\"\",0);");
                } else if (chosen_box.mid == -1) {
                    LOGGER.info("\n/*Processing*/" + function + '(' + chosen_box.getMinimumBoundary(0) + ',' + chosen_box.getMaximumBoundary(0) + ',' + chosen_box.getMinimumBoundary(1) + ',' + chosen_box.getMaximumBoundary(1) + ",\"" + "diagonal\",\"\"," + chosen_box.orientation + ");");
                } else if (increase) {
                    String info = "";
                    Region box = new Region(chosen_box);
                    box.setMaximumBoundary(box.dicho_ext, box.mid);
                    if (box.father.equals("FindBoxTriangleDicho1")) {
                        info = box.case_a_or_c ? (box.dicho_ext == 1 ? "1.A" : "1.C") : (box.dicho_ext == 1 ? "1.B" : "1.D");
                    }
                    if (box.father.equals("FindBoxTriangleDicho2")) {
                        info = box.case_a_or_c ? (box.dicho_ext == 1 ? "2.A" : "2.C") : (box.dicho_ext == 1 ? "2.B" : "2.D");
                    }
                    LOGGER.info("\n/*Processing*/" + function + '(' + box.getMinimumBoundary(0) + ',' + box.getMaximumBoundary(0) + ',' + box.getMinimumBoundary(1) + ',' + box.getMaximumBoundary(1) + ",\"" + "low_diag\",\"" + info + "\"," + chosen_box.orientation + ");");
                    box = new Region(chosen_box);
                    box.setMinimumBoundary(box.dicho_ext, box.mid);
                    LOGGER.info("\n/*Processing*/" + function + '(' + box.getMinimumBoundary(0) + ',' + box.getMaximumBoundary(0) + ',' + box.getMinimumBoundary(1) + ',' + box.getMaximumBoundary(1) + ",\"" + "diagonal\",\"" + info + "\"," + chosen_box.orientation + ");");
                } else {
                    String info = "";
                    Region box = new Region(chosen_box);
                    box.setMinimumBoundary(box.dicho_ext, box.mid);
                    if (box.father.equals("FindBoxTriangleDicho1")) {
                        info = box.case_a_or_c ? (box.dicho_ext == 1 ? "1.A" : "1.C") : (box.dicho_ext == 1 ? "1.B" : "1.D");
                    }
                    if (box.father.equals("FindBoxTriangleDicho2")) {
                        info = box.case_a_or_c ? (box.dicho_ext == 1 ? "2.A" : "2.C") : (box.dicho_ext == 1 ? "2.B" : "2.D");
                    }
                    LOGGER.info("\n/*Processing*/" + function + '(' + box.getMinimumBoundary(0) + ',' + box.getMaximumBoundary(0) + ',' + box.getMinimumBoundary(1) + ',' + box.getMaximumBoundary(1) + ",\"" + "low_diag\",\"" + info + "\"," + chosen_box.orientation + ");");
                    box = new Region(chosen_box);
                    box.setMaximumBoundary(box.dicho_ext, box.mid);
                    LOGGER.info("\n/*Processing*/" + function + '(' + box.getMinimumBoundary(0) + ',' + box.getMaximumBoundary(0) + ',' + box.getMinimumBoundary(1) + ',' + box.getMaximumBoundary(1) + ",\"" + "diagonal\",\"" + info + "\"," + chosen_box.orientation + ");");
                }
            }
        }
    }

    Pair<Integer, Integer> dealWithSucc(int d, int last_dprune, int last_diff, int diff_counter, Point c, Point initial_c, int k) {
        int diff = -1;
        GeostOptions cfr_ignored_0 = this.stp.opt;
        if (GeostOptions.deltasucc) {
            int d_current = 0;
            for (int i = 0; i <= k - 1 && Math.abs(c.getCoord(d_current = (i + d) % k) - initial_c.getCoord(d_current)) == 0; ++i) {
            }
            diff = Math.abs(c.getCoord(d_current) - initial_c.getCoord(d_current));
            GeostOptions cfr_ignored_1 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("last_diff:" + last_diff + ";diff:" + diff + "d:" + d + ";d_current" + d_current);
            }
            GeostOptions cfr_ignored_2 = this.stp.opt;
            if (GeostOptions.delta.get(d_current) == null) {
                GeostOptions cfr_ignored_3 = this.stp.opt;
                GeostOptions.delta.put(d_current, new HashMap(16));
            }
            GeostOptions cfr_ignored_4 = this.stp.opt;
            HashMap<Integer, Integer> curDelta = GeostOptions.delta.get(d_current);
            if (curDelta.get(diff) == null) {
                curDelta.put(diff, 0);
            }
            curDelta.put(diff, curDelta.get(diff) + 1);
            if (diff != 0) {
                if (diff == last_diff && last_dprune == d_current) {
                    ++diff_counter;
                } else if (last_diff != -1 && diff_counter != 0 && last_dprune != -1) {
                    GeostOptions cfr_ignored_5 = this.stp.opt;
                    if (GeostOptions.succDelta.get(last_dprune) == null) {
                        GeostOptions cfr_ignored_6 = this.stp.opt;
                        GeostOptions.succDelta.put(d, new HashMap(16));
                    }
                    GeostOptions cfr_ignored_7 = this.stp.opt;
                    HashMap<Integer, List<Integer>> curSuccDelta = GeostOptions.succDelta.get(last_dprune);
                    if (curSuccDelta.get(last_diff) == null) {
                        curSuccDelta.put(last_diff, new ArrayList(16));
                    }
                    List<Integer> succ_list = curSuccDelta.get(last_diff);
                    succ_list.add(diff_counter);
                    diff_counter = 0;
                }
                if (diff == 0) {
                    throw new SolverException("GeometricKernel:DealWithSucc():diff is zero, which should not happen since c and initial_c should always be different in at least one dimesion when AdjustUp is called.");
                }
                last_diff = diff;
                last_dprune = d_current;
            }
        }
        return new Pair<Integer, Integer>(diff, diff_counter);
    }

    static List checkTrashingState(Point c, int d, int k, int cdpl, Region f, boolean bad_ratio, int nbr_steps, int mode) {
        int d_prev_least = (k - 2 + k + d) % k;
        boolean bl = bad_ratio = bad_ratio || f.ratio() < 0.1;
        if (cdpl != c.getCoord(d_prev_least)) {
            if (mode == 0) {
                if (!bad_ratio) {
                    nbr_steps = 0;
                } else if (++nbr_steps >= 3) {
                    mode = 1;
                    nbr_steps = 0;
                }
            } else if (mode == 1) {
                if (!bad_ratio) {
                    mode = 0;
                    nbr_steps = 0;
                } else if (++nbr_steps >= 100) {
                    mode = 2;
                }
            } else if (mode == 2) {
                nbr_steps = 0;
                mode = bad_ratio ? 1 : 0;
            }
            bad_ratio = false;
        }
        ArrayList<Comparable<Boolean>> r = new ArrayList<Comparable<Boolean>>(3);
        r.add(Boolean.valueOf(bad_ratio));
        r.add(Integer.valueOf(nbr_steps));
        r.add(Integer.valueOf(mode));
        return r;
    }

    static List checkTrashingState_dl(Point c, int d, int k, int cdpl, Region f, boolean bad_ratio, int nbr_steps, int mode) {
        int d_prev_least = (k - 2 + d) % k;
        boolean bl = bad_ratio = f.ratio() < 0.1;
        if (cdpl != c.getCoord(d_prev_least)) {
            if (mode == 0) {
                if (!bad_ratio) {
                    nbr_steps = 0;
                } else if (++nbr_steps >= 3) {
                    mode = 1;
                    nbr_steps = 0;
                }
            } else if (mode == 1) {
                if (++nbr_steps >= 100) {
                    mode = 2;
                }
            } else if (mode == 2) {
                nbr_steps = 0;
                mode = bad_ratio ? 1 : 0;
            }
            bad_ratio = false;
        }
        ArrayList<Comparable<Boolean>> r = new ArrayList<Comparable<Boolean>>(3);
        r.add(Boolean.valueOf(bad_ratio));
        r.add(Integer.valueOf(nbr_steps));
        r.add(Integer.valueOf(mode));
        return r;
    }

    boolean newDeltaPruneMin(Obj o, int d, int k, List<InternalConstraint> ICTRS) throws ContradictionException {
        int local_nbr_jumps = 0;
        int last_diff = -1;
        int diff_counter = 0;
        int last_dprune = -1;
        boolean b = true;
        Point c = new Point(k);
        for (int i = 0; i < k; ++i) {
            c.setCoord(i, o.getCoord(i).getInf());
        }
        Point n = new Point(k);
        for (int i = 0; i < k; ++i) {
            n.setCoord(i, o.getCoord(i).getSup() + 1);
        }
        GeostOptions cfr_ignored_0 = this.stp.opt;
        if (GeostOptions.processing) {
            GeostOptions cfr_ignored_1 = this.stp.opt;
            LOGGER.info("\n/*Processing*/endchunk();\n/*Processing*/break;case " + GeostOptions.phase++ + ":\n/*Processing*/beginchunk();");
            for (Integer i : this.stp.getObjectKeySet()) {
                Obj tmp = this.stp.getObject(i);
                if (!tmp.coordInstantiated() || !tmp.isSphere()) continue;
                LOGGER.info("\n/*Processing*/sphere_object(" + tmp.getCoord(0).getSup() + ',' + tmp.getCoord(1).getSup() + ',' + tmp.getRadius() + ',' + tmp.getObjectId() + ");");
            }
            for (InternalConstraint ictr : ICTRS) {
                ForbiddenRegion dlic;
                if (!(ictr instanceof ForbiddenRegion)) continue;
                ForbiddenRegion fr = (ForbiddenRegion)ictr;
                if (fr instanceof DistLeqIC) {
                    dlic = (DistLeqIC)fr;
                    if (this.stp.getObject(((DistLeqIC)dlic).o2).coordInstantiated()) {
                        if (((DistLeqIC)dlic).hasDistanceVar()) {
                            LOGGER.info("\n/*Processing*/constraint(" + this.stp.getObject(((DistLeqIC)dlic).o2).getCoord(0).getSup() + ',' + this.stp.getObject(((DistLeqIC)dlic).o2).getCoord(1).getSup() + ',' + ((DistLeqIC)dlic).getDistanceVar().getSup() + ",\"LeqVar\");");
                        } else {
                            LOGGER.info("\n/*Processing*/constraint(" + this.stp.getObject(((DistLeqIC)dlic).o2).getCoord(0).getSup() + ',' + this.stp.getObject(((DistLeqIC)dlic).o2).getCoord(1).getSup() + ',' + ((DistLeqIC)dlic).D + ",\"Leq\");");
                        }
                    }
                }
                if (fr instanceof DistGeqIC) {
                    dlic = (DistGeqIC)fr;
                    if (this.stp.getObject(((DistGeqIC)dlic).o2).coordInstantiated()) {
                        if (((DistGeqIC)dlic).hasDistanceVar()) {
                            LOGGER.info("\n/*Processing*/constraint(" + this.stp.getObject(((DistGeqIC)dlic).o2).getCoord(0).getSup() + ',' + this.stp.getObject(((DistGeqIC)dlic).o2).getCoord(1).getSup() + ',' + ((DistGeqIC)dlic).getDistanceVar().getInf() + ",\"GeqVar\");");
                        } else {
                            LOGGER.info("\n/*Processing*/constraint(" + this.stp.getObject(((DistGeqIC)dlic).o2).getCoord(0).getSup() + ',' + this.stp.getObject(((DistGeqIC)dlic).o2).getCoord(1).getSup() + ',' + ((DistGeqIC)dlic).D + ",\"Geq\");");
                        }
                    }
                }
                if (!(fr instanceof DistLinearIC)) continue;
                dlic = (DistLinearIC)fr;
                LOGGER.info("\n/*Processing*/constraint(" + ((DistLinearIC)dlic).a[0] + ',' + ((DistLinearIC)dlic).a[1] + ',' + ((DistLinearIC)dlic).b + ",\"Linear\");");
            }
            LOGGER.info("\n/*Processing*/sweep_point(" + c.getCoord(0) + ',' + c.getCoord(1) + ");");
        }
        int mode = 0;
        int nbr_steps = 0;
        boolean bad_ratio = false;
        int delta = 1;
        int cd = c.getCoord(d);
        int nj = 0;
        boolean first = true;
        int delta_prev = delta;
        int nj_prev = nj;
        int d_prev_least = (k - 2 + k + d) % k;
        int cdpl = c.getCoord(d_prev_least);
        Pair<Boolean, Region> r = this.getDeltaFR(d, k, o, c, n, ICTRS, true, c.getCoord(d) + delta, mode);
        boolean infeasible = (Boolean)r.fst;
        Region f = (Region)r.snd;
        GeostOptions cfr_ignored_2 = this.stp.opt;
        if (GeostOptions.debug && infeasible && GeometricKernel.feasiblePtInRegion()) {
            throw new SolverException("GeometricKernel:NewDeltaPruneMin():feasiblePtInRegion is true");
        }
        Point initial_c = new Point(c);
        if (infeasible) {
            GeostOptions cfr_ignored_3 = this.stp.opt;
            ++GeostOptions.nbr_propagations;
        }
        while (b && infeasible) {
            for (int i = 0; i < k; ++i) {
                n.setCoord(i, Math.min(n.getCoord(i), f.getMaximumBoundary(i) + 1));
            }
            initial_c = new Point(c);
            GeostOptions cfr_ignored_4 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("/*example*/Adjustup(c=" + c + ",n=" + n + ",o=" + o + ",d=" + d + ",k=" + k + ')');
            }
            List adjUp = GeometricKernel.adjustUp(c, n, o, d, k);
            GeostOptions cfr_ignored_5 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("/*example*/returns c=" + c + ",n=" + n + ",b=" + b);
            }
            c = (Point)adjUp.get(0);
            n = (Point)adjUp.get(1);
            b = (Boolean)adjUp.get(2);
            GeostOptions cfr_ignored_6 = this.stp.opt;
            ++GeostOptions.nbr_jumps;
            ++local_nbr_jumps;
            GeostOptions cfr_ignored_7 = this.stp.opt;
            if (GeostOptions.mixmode) {
                List rcts = GeometricKernel.checkTrashingState_dl(c, d, k, cdpl, f, bad_ratio, nbr_steps, mode);
                bad_ratio = (Boolean)rcts.get(0);
                nbr_steps = (Integer)rcts.get(1);
                mode = (Integer)rcts.get(2);
                cdpl = c.getCoord(d_prev_least);
            }
            GeostOptions cfr_ignored_8 = this.stp.opt;
            if (GeostOptions.processing && Math.abs(c.getCoord(d) - initial_c.getCoord(d)) != 0) {
                GeostOptions cfr_ignored_9 = this.stp.opt;
                LOGGER.info("\n/*Processing*/endchunk();\n/*Processing*/break;case " + GeostOptions.phase++ + ":\n/*Processing*/beginchunk();");
                for (Integer i : this.stp.getObjectKeySet()) {
                    Obj tmp = this.stp.getObject(i);
                    if (!tmp.coordInstantiated() || !tmp.isSphere()) continue;
                    LOGGER.info("\n/*Processing*/sphere_object(" + tmp.getCoord(0).getSup() + ',' + tmp.getCoord(1).getSup() + ',' + tmp.getRadius() + ',' + tmp.getObjectId() + ");");
                }
                for (InternalConstraint ictr : ICTRS) {
                    ForbiddenRegion dlic;
                    if (!(ictr instanceof ForbiddenRegion)) continue;
                    ForbiddenRegion fr = (ForbiddenRegion)ictr;
                    if (fr instanceof DistLeqIC) {
                        dlic = (DistLeqIC)fr;
                        if (this.stp.getObject(dlic.o2).coordInstantiated() && !this.stp.getObject(dlic.o1).coordInstantiated()) {
                            LOGGER.info("\n/*Processing*/constraint(" + this.stp.getObject(dlic.o2).getCoord(0).getSup() + ',' + this.stp.getObject(dlic.o2).getCoord(1).getSup() + ',' + dlic.D + ",\"Leq\");");
                        }
                    }
                    if (fr instanceof DistGeqIC) {
                        dlic = (DistGeqIC)fr;
                        if (this.stp.getObject(((DistGeqIC)dlic).o2).coordInstantiated() && !this.stp.getObject(((DistGeqIC)dlic).o1).coordInstantiated()) {
                            LOGGER.info("\n/*Processing*/constraint(" + this.stp.getObject(((DistGeqIC)dlic).o2).getCoord(0).getSup() + ',' + this.stp.getObject(((DistGeqIC)dlic).o2).getCoord(1).getSup() + ',' + ((DistGeqIC)dlic).D + ",\"Geq\");");
                        }
                    }
                    if (!(fr instanceof DistLinearIC)) continue;
                    dlic = (DistLinearIC)fr;
                    LOGGER.info("\n/*Processing*/constraint(" + ((DistLinearIC)dlic).a[0] + ',' + ((DistLinearIC)dlic).a[1] + ',' + ((DistLinearIC)dlic).b + ",\"Linear\");");
                }
                LOGGER.info("\n/*Processing*/new_position(" + c.getCoord(0) + ',' + c.getCoord(1) + ");");
            }
            Pair<Integer, Integer> p = this.dealWithSucc(d, last_dprune, last_diff, diff_counter, c, initial_c, k);
            last_diff = (Integer)p.fst;
            last_dprune = d;
            diff_counter = (Integer)p.snd;
            if (cd != c.getCoord(d)) {
                delta = c.getCoord(d) - cd;
                long s = (o.getCoord(d).getSup() - c.getCoord(d) + delta - 1) / delta * nj;
                long s_prev = (o.getCoord(d).getSup() - c.getCoord(d) + delta_prev - 1) / delta_prev * nj_prev;
                nj = nj_prev;
                int maxDiameter = 0;
                for (Integer i : this.stp.getShapeKeySet()) {
                    for (ShiftedBox sb : this.stp.getShape(i)) {
                        if (sb.getSize(d) + sb.getOffset(d) < maxDiameter) continue;
                        maxDiameter = sb.getSize(d) + sb.getOffset(d);
                    }
                }
                if (first || s < s_prev) {
                    delta_prev = delta;
                    delta = Math.min(delta + delta, o.getRadius() + maxDiameter);
                    first = false;
                } else {
                    int tmp = Math.min((delta + delta_prev) / 2, o.getRadius() + maxDiameter);
                    delta_prev = delta;
                    delta = tmp;
                }
                cd = c.getCoord(d);
            } else {
                ++nj;
            }
            Pair<Boolean, Region> forbidRegion = this.getDeltaFR(d, k, o, c, n, ICTRS, true, c.getCoord(d) + delta, mode);
            infeasible = (Boolean)forbidRegion.fst;
            f = (Region)forbidRegion.snd;
            GeostOptions cfr_ignored_10 = this.stp.opt;
            if (!GeostOptions.debug || !infeasible || !GeometricKernel.feasiblePtInRegion()) continue;
            throw new SolverException("GeometricKernel:NewDeltaPruneMin():feasiblePtInRegion is true");
        }
        Pair<Integer, Integer> p = this.dealWithSucc(d, last_dprune, last_diff, diff_counter, c, initial_c, k);
        last_diff = (Integer)p.fst;
        last_dprune = d;
        diff_counter = (Integer)p.snd;
        GeostOptions cfr_ignored_11 = this.stp.opt;
        if (local_nbr_jumps > GeostOptions.max_nbr_jumps) {
            GeostOptions cfr_ignored_12 = this.stp.opt;
            GeostOptions.max_nbr_jumps = local_nbr_jumps;
            GeostOptions cfr_ignored_13 = this.stp.opt;
            GeostOptions.worst_increase = true;
        }
        GeostOptions cfr_ignored_14 = this.stp.opt;
        GeostOptions.sum_jumps += local_nbr_jumps;
        GeostOptions cfr_ignored_15 = this.stp.opt;
        GeostOptions.sum_square_jumps += (long)(local_nbr_jumps * local_nbr_jumps);
        if (b) {
            o.getCoord(d).updateInf(c.getCoord(d), this.constraint, true);
        }
        return b;
    }

    boolean newDeltaPruneMax(Obj o, int d, int k, List<InternalConstraint> ICTRS) throws ContradictionException {
        int local_nbr_jumps = 0;
        int last_diff = -1;
        int diff_counter = 0;
        int last_dprune = -1;
        boolean b = true;
        Point c = new Point(k);
        for (int i = 0; i < k; ++i) {
            c.setCoord(i, o.getCoord(i).getSup());
        }
        Point n = new Point(k);
        for (int i = 0; i < k; ++i) {
            n.setCoord(i, o.getCoord(i).getInf() - 1);
        }
        GeostOptions cfr_ignored_0 = this.stp.opt;
        if (GeostOptions.processing) {
            GeostOptions cfr_ignored_1 = this.stp.opt;
            LOGGER.info("\n/*Processing*/endchunk();\n/*Processing*/break;case " + GeostOptions.phase++ + ":\n/*Processing*/beginchunk();");
            for (Integer i : this.stp.getObjectKeySet()) {
                Obj tmp = this.stp.getObject(i);
                if (!tmp.coordInstantiated() || !tmp.isSphere()) continue;
                LOGGER.info("\n/*Processing*/sphere_object(" + tmp.getCoord(0).getSup() + ',' + tmp.getCoord(1).getSup() + ',' + tmp.getRadius() + ',' + tmp.getObjectId() + ");");
            }
            for (InternalConstraint ictr : ICTRS) {
                ForbiddenRegion dlic;
                if (!(ictr instanceof ForbiddenRegion)) continue;
                ForbiddenRegion fr = (ForbiddenRegion)ictr;
                if (fr instanceof DistLeqIC) {
                    dlic = (DistLeqIC)fr;
                    if (this.stp.getObject(dlic.o2).coordInstantiated()) {
                        LOGGER.info("\n/*Processing*/constraint(" + this.stp.getObject(dlic.o2).getCoord(0).getSup() + ',' + this.stp.getObject(dlic.o2).getCoord(1).getSup() + ',' + dlic.D + ",\"Leq\");");
                    }
                }
                if (fr instanceof DistGeqIC) {
                    dlic = (DistGeqIC)fr;
                    if (this.stp.getObject(((DistGeqIC)dlic).o2).coordInstantiated()) {
                        LOGGER.info("\n/*Processing*/constraint(" + this.stp.getObject(((DistGeqIC)dlic).o2).getCoord(0).getSup() + ',' + this.stp.getObject(((DistGeqIC)dlic).o2).getCoord(1).getSup() + ',' + ((DistGeqIC)dlic).D + ",\"Geq\");");
                    }
                }
                if (!(fr instanceof DistLinearIC)) continue;
                dlic = (DistLinearIC)fr;
                LOGGER.info("\n/*Processing*/constraint(" + ((DistLinearIC)dlic).a[0] + ',' + ((DistLinearIC)dlic).a[1] + ',' + ((DistLinearIC)dlic).b + ",\"Linear\");");
            }
            LOGGER.info("\n/*Processing*/sweep_point(" + c.getCoord(0) + ',' + c.getCoord(1) + ");");
        }
        int d_least = (k - 1 + d) % k;
        int d_prev_least = (k - 2 + d) % k;
        int cdpl = c.getCoord(d_least);
        int nbr_steps = 0;
        boolean bad_ratio = false;
        int mode = 0;
        int delta = 1;
        int cd = c.getCoord(d);
        int nj = 0;
        boolean first = true;
        int delta_prev = delta;
        int nj_prev = nj;
        Pair<Boolean, Region> r = this.getDeltaFR(d, k, o, c, n, ICTRS, false, c.getCoord(d) - delta, mode);
        boolean infeasible = (Boolean)r.fst;
        Region f = (Region)r.snd;
        GeostOptions cfr_ignored_2 = this.stp.opt;
        if (GeostOptions.debug && infeasible && GeometricKernel.feasiblePtInRegion()) {
            throw new SolverException("GeometricKernel:NewDeltaPruneMax():feasiblePtInRegion is true");
        }
        Point initial_c = new Point(c);
        if (infeasible) {
            GeostOptions cfr_ignored_3 = this.stp.opt;
            ++GeostOptions.nbr_propagations;
        }
        while (b && infeasible) {
            for (int i = 0; i < k; ++i) {
                n.setCoord(i, Math.max(n.getCoord(i), f.getMinimumBoundary(i) - 1));
            }
            initial_c = new Point(c);
            List adjUp = GeometricKernel.adjustDown(c, n, o, d, k);
            GeostOptions cfr_ignored_4 = this.stp.opt;
            ++GeostOptions.nbr_jumps;
            ++local_nbr_jumps;
            c = (Point)adjUp.get(0);
            n = (Point)adjUp.get(1);
            b = (Boolean)adjUp.get(2);
            GeostOptions cfr_ignored_5 = this.stp.opt;
            if (GeostOptions.mixmode) {
                List rcts = GeometricKernel.checkTrashingState_dl(c, d, k, cdpl, f, bad_ratio, nbr_steps, mode);
                bad_ratio = (Boolean)rcts.get(0);
                nbr_steps = (Integer)rcts.get(1);
                mode = (Integer)rcts.get(2);
                cdpl = c.getCoord(d_prev_least);
            }
            GeostOptions cfr_ignored_6 = this.stp.opt;
            if (GeostOptions.processing && Math.abs(c.getCoord(d) - initial_c.getCoord(d)) != 0) {
                GeostOptions cfr_ignored_7 = this.stp.opt;
                LOGGER.info("\n/*Processing*/endchunk();\n/*Processing*/break;case " + GeostOptions.phase++ + ":\n/*Processing*/beginchunk();");
                for (Integer i : this.stp.getObjectKeySet()) {
                    Obj tmp = this.stp.getObject(i);
                    if (!tmp.coordInstantiated() || !tmp.isSphere()) continue;
                    LOGGER.info("\n/*Processing*/sphere_object(" + tmp.getCoord(0).getSup() + ',' + tmp.getCoord(1).getSup() + ',' + tmp.getRadius() + ',' + tmp.getObjectId() + ");");
                }
                for (InternalConstraint ictr : ICTRS) {
                    ForbiddenRegion dlic;
                    if (!(ictr instanceof ForbiddenRegion)) continue;
                    ForbiddenRegion fr = (ForbiddenRegion)ictr;
                    if (fr instanceof DistLeqIC) {
                        dlic = (DistLeqIC)fr;
                        if (this.stp.getObject(dlic.o2).coordInstantiated()) {
                            LOGGER.info("\n/*Processing*/constraint(" + this.stp.getObject(dlic.o2).getCoord(0).getSup() + ',' + this.stp.getObject(dlic.o2).getCoord(1).getSup() + ',' + dlic.D + ",\"Leq\");");
                        }
                    }
                    if (fr instanceof DistGeqIC) {
                        dlic = (DistGeqIC)fr;
                        if (this.stp.getObject(((DistGeqIC)dlic).o2).coordInstantiated()) {
                            LOGGER.info("\n/*Processing*/constraint(" + this.stp.getObject(((DistGeqIC)dlic).o2).getCoord(0).getSup() + ',' + this.stp.getObject(((DistGeqIC)dlic).o2).getCoord(1).getSup() + ',' + ((DistGeqIC)dlic).D + ",\"Geq\");");
                        }
                    }
                    if (!(fr instanceof DistLinearIC)) continue;
                    dlic = (DistLinearIC)fr;
                    LOGGER.info("\n/*Processing*/constraint(" + ((DistLinearIC)dlic).a[0] + ',' + ((DistLinearIC)dlic).a[1] + ',' + ((DistLinearIC)dlic).b + ",\"Linear\");");
                }
                LOGGER.info("\n/*Processing*/new_position(" + c.getCoord(0) + ',' + c.getCoord(1) + ");");
            }
            Pair<Integer, Integer> p = this.dealWithSucc(d, last_dprune, last_diff, diff_counter, c, initial_c, k);
            last_diff = (Integer)p.fst;
            last_dprune = d;
            diff_counter = (Integer)p.snd;
            if (cd != c.getCoord(d)) {
                delta = cd - c.getCoord(d);
                long s = (c.getCoord(d) - o.getCoord(d).getInf() - delta + 1) / delta * nj;
                long s_prev = (c.getCoord(d) - o.getCoord(d).getInf() - delta_prev + 1) / delta_prev * nj_prev;
                nj = nj_prev;
                int maxDiameter = 0;
                for (Integer i : this.stp.getShapeKeySet()) {
                    for (ShiftedBox sb : this.stp.getShape(i)) {
                        if (sb.getSize(d) + sb.getOffset(d) < maxDiameter) continue;
                        maxDiameter = sb.getSize(d) + sb.getOffset(d);
                    }
                }
                if (first || s < s_prev) {
                    delta_prev = delta;
                    delta = Math.min(delta + delta, o.getRadius() + maxDiameter);
                    first = false;
                } else {
                    int tmp = Math.min((delta + delta_prev) / 2, o.getRadius() + maxDiameter);
                    delta_prev = delta;
                    delta = tmp;
                }
                cd = c.getCoord(d);
            } else {
                ++nj;
            }
            Pair<Boolean, Region> forbidRegion = this.getDeltaFR(d, k, o, c, n, ICTRS, false, c.getCoord(d) - delta, mode);
            infeasible = (Boolean)forbidRegion.fst;
            f = (Region)forbidRegion.snd;
            GeostOptions cfr_ignored_8 = this.stp.opt;
            if (!GeostOptions.debug || !infeasible || !GeometricKernel.feasiblePtInRegion()) continue;
            throw new SolverException("GeometricKernel:NewDeltaPruneMax():feasiblePtInRegion is true");
        }
        Pair<Integer, Integer> p = this.dealWithSucc(d, last_dprune, last_diff, diff_counter, c, initial_c, k);
        last_diff = (Integer)p.fst;
        last_dprune = d;
        diff_counter = (Integer)p.snd;
        if (b) {
            o.getCoord(d).updateSup(c.getCoord(d), this.constraint, true);
        }
        GeostOptions cfr_ignored_9 = this.stp.opt;
        if (local_nbr_jumps > GeostOptions.max_nbr_jumps) {
            GeostOptions cfr_ignored_10 = this.stp.opt;
            GeostOptions.max_nbr_jumps = local_nbr_jumps;
            GeostOptions cfr_ignored_11 = this.stp.opt;
            GeostOptions.worst_increase = false;
        }
        GeostOptions cfr_ignored_12 = this.stp.opt;
        GeostOptions.sum_jumps += local_nbr_jumps;
        GeostOptions cfr_ignored_13 = this.stp.opt;
        GeostOptions.sum_square_jumps += (long)(local_nbr_jumps * local_nbr_jumps);
        return b;
    }

    public static List<Point> circleIntersectiont(double x1, double y1, double r1, double x2, double y2, double r2) {
        double distance = Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
        if (distance > r1 + r2 || distance < Math.abs(r1 - r2)) {
            return null;
        }
        double x = (x2 + x1) / 2.0 + (x2 - x1) * (r1 * r1 - r2 * r2) / (2.0 * Math.pow(distance, 2.0));
        double xvar = (y2 - y1) / (2.0 * distance * distance) * Math.sqrt((Math.pow(r1 + r2, 2.0) - distance * distance) * (distance * distance - Math.pow(r2 - r1, 2.0)));
        double x_1 = x + xvar;
        double x_2 = x - xvar;
        double y = (y2 + y1) / 2.0 + (y2 - y1) * (r1 * r1 - r2 * r2) / (2.0 * Math.pow(distance, 2.0));
        double yvar = (x2 - x1) / (2.0 * distance * distance) * Math.sqrt((Math.pow(r1 + r2, 2.0) - distance * distance) * (distance * distance - Math.pow(r2 - r1, 2.0)));
        double y_1 = y - yvar;
        double y_2 = y + yvar;
        int x_1i = (int)Math.floor(x_1);
        int x_2i = (int)Math.floor(x_2);
        int y_1i = (int)Math.floor(y_1);
        int y_2i = (int)Math.floor(y_2);
        ArrayList<Point> listOfPoints = new ArrayList<Point>(2);
        Point p1 = new Point(2);
        p1.setCoord(0, x_1i);
        p1.setCoord(1, y_1i);
        listOfPoints.add(p1);
        Point p2 = new Point(2);
        p2.setCoord(0, x_2i);
        p2.setCoord(1, y_2i);
        if (distance != Math.abs(r1 - r2)) {
            listOfPoints.add(p2);
        }
        return listOfPoints;
    }

    IntDomainVar getE(int oid) {
        if (this.E == null) {
            this.E = new IntDomainVar[this.stp.getObjectKeySet().size()];
            for (int i = 0; i < this.stp.getObjectKeySet().size(); ++i) {
                this.E[i] = null;
            }
        }
        IntDomainVar found = null;
        if (this.E[oid] != null) {
            found = this.E[oid];
        } else {
            for (ExternalConstraint ectr : this.stp.getConstraints()) {
                DistLeq dl;
                if (!(ectr instanceof DistLeq) || !(dl = (DistLeq)ectr).hasDistanceVar() || dl.getObjectIds()[0] != oid) continue;
                if (found == null) {
                    found = dl.getDistanceVar();
                    continue;
                }
                throw new SolverException("GeometricKernel:getE():Two E variables for variable oid " + oid + '.');
            }
        }
        if (found == null) {
            throw new SolverException("GeometricKernel:getE():No E variables for variable oid " + oid + '.');
        }
        this.E[oid] = found;
        return found;
    }

    IntDomainVar getD(int oid) {
        if (this.D == null) {
            this.D = new IntDomainVar[this.stp.getObjectKeySet().size()];
            for (int i = 0; i < this.stp.getObjectKeySet().size(); ++i) {
                this.D[i] = null;
            }
        }
        IntDomainVar found = null;
        if (this.D[oid] != null) {
            found = this.D[oid];
        } else {
            for (ExternalConstraint ectr : this.stp.getConstraints()) {
                DistGeq dl;
                if (!(ectr instanceof DistGeq) || !(dl = (DistGeq)ectr).hasDistanceVar() || dl.getObjectIds()[0] != oid) continue;
                if (found == null) {
                    found = dl.getDistanceVar();
                    continue;
                }
                throw new SolverException("GeometricKernel:getD():Two D variables for variable oid " + oid + '.');
            }
        }
        if (found == null) {
            throw new SolverException("GeometricKernel:getD():No D variables for variable oid " + oid + '.');
        }
        this.D[oid] = found;
        return found;
    }

    boolean propagDistConstraints() throws ContradictionException {
        boolean nonFix = false;
        for (int i = 1; i < this.stp.getObjectKeySet().size() - 1; ++i) {
            IntDomainVar Dprec = this.getD(i - 1);
            if (!Dprec.isInstantiated()) continue;
            LOGGER.info("D of oid:" + (i - 1) + " is instantiated:" + Dprec);
            IntDomainVar D = this.getD(i);
            int oldSup = D.getSup();
            int newSup = Dprec.getVal() - (this.stp.getObject(i).getRadius() + this.stp.getObject(i - 1).getRadius());
            LOGGER.info("D:[" + D.getInf() + ',' + D.getSup() + "] oldSup:" + oldSup + " newSup:" + newSup);
            if (newSup >= oldSup) continue;
            D.setSup(newSup);
            nonFix |= true;
        }
        return nonFix;
    }
}

